/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ftplet;

import org.apache.ftpserver.ftplet.FtpReply;

public class DefaultFtpReply
implements FtpReply {
    private int code;
    private String message;
    private static final String CRLF = "\r\n";

    public DefaultFtpReply(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public DefaultFtpReply(int code, String[] message) {
        this.code = code;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < message.length; ++i) {
            sb.append(message[i]);
            sb.append('\n');
        }
        this.message = sb.toString();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public String toString() {
        int code = this.getCode();
        String notNullMessage = this.getMessage();
        if (notNullMessage == null) {
            notNullMessage = "";
        }
        StringBuffer sb = new StringBuffer();
        if (notNullMessage.indexOf(10) == -1) {
            sb.append(code);
            sb.append(" ");
            sb.append(notNullMessage);
            sb.append(CRLF);
        } else {
            String[] lines = notNullMessage.split("\n");
            sb.append(code);
            sb.append("-");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i + 1 == lines.length) {
                    sb.append(code);
                    sb.append(" ");
                }
                if (i > 0 && i + 1 < lines.length && line.length() > 2 && this.isDigit(line.charAt(0)) && this.isDigit(line.charAt(1)) && this.isDigit(line.charAt(2))) {
                    sb.append("  ");
                }
                sb.append(line);
                sb.append(CRLF);
            }
        }
        return sb.toString();
    }
}

