process.env.NODE_TLS_REJECT_UNAUTHORIZED = '0'; // !! disable certificates verification because of vagrant self signed. Remove if use in production.

const {default: axios} = require('axios');
const config = require('e2e-conf');

const path = require('path');

config.init(path.join(__dirname, '../../..'));
const {host, loginId, password, client} = config.get('platformProxy');

let token = '';
const options = {
    method: 'POST',
    url: `https://${host}/token/${client}`,
    headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
    },
    data: `loginId=${loginId}&password=${password}`
};
axios.request(options).then(response => {
    token = response.data.token;
}).catch(e => {});

setInterval(() => {
    axios.request(options).then(response => {
        token = response.data.token;
    }).catch(e => {});
}, 1000 * 60 * 3);

const PROXY_CONFIG = {
    /** proxy to the remote platform **/
    "/pas/*": {
        "target": `https://${host}/${client}/`,
        "secure": false,
        "logLevel": "debug",
        "changeOrigin": true,
        "pathRewrite": {
            "^/pas": ""
        },
        "bypass": function (req) {
            if(req.headers["Authorization"] == null) {
                req.headers["Authorization"] = "Bearer " + token;
            }
        }
    }
};

module.exports = PROXY_CONFIG;
