import {Injectable} from '@angular/core';
import {ActivatedRoute, ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot, UrlTree} from '@angular/router';
import {SecurityService} from "@pas/app-core";

@Injectable({
    providedIn: 'root'
})
export class InstanceListGuard implements CanActivate {

    constructor(
        private router: Router,
        private route:  ActivatedRoute,
        private security: SecurityService
    ) {
        this.router.onSameUrlNavigation = 'reload';
    }

    async canActivate(
        routeSnapshot: ActivatedRouteSnapshot,
        state: RouterStateSnapshot): Promise<boolean|UrlTree> {
        const processName = routeSnapshot.data.processName;

        const resourceId = "process/" + processName;
        if(!this.security.isAuthorized(resourceId, "instanceList")){
            return this.router.navigate(['/'], {
                replaceUrl: true
            });
        }

        return true;
    }

}
