import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { combineLatest } from 'rxjs';
import { NotificationService } from '@pas/app-core';
import { ProcessService } from '@pas/xuml-communication';
import { filter } from 'rxjs/operators';

@Component({
  templateUrl: './default.component.html'
})
export class DefaultComponent implements OnInit {
  private navigationEndSub = null;
  public processName = '';
  public instanceId = '';
  public taskName = '';
  public overviewLink: string;

  private timeout: any;

  constructor(
      private route: ActivatedRoute,
      private router: Router,
      private process: ProcessService,
      private notification: NotificationService
  ) {
    this.router.onSameUrlNavigation = 'reload';
  }

  ngOnInit() {
    combineLatest([
          this.route.params,
          this.route.data
        ]
    ).subscribe(data => {
      const merged = {...data[0], ...data[1]};
      this.processName = merged.processName;
      this.taskName = merged.taskName;
      this.instanceId = merged.instanceId;
      this.overviewLink = this.router.createUrlTree([this.processName]).toString();
    });

    this.timeoutReloadInstance();
    this.navigationEndSub = this.router.events
        .pipe(filter(event => event instanceof NavigationEnd))
        .subscribe((event) => {
          this.timeoutReloadInstance();
        });
  }

  timeoutReloadInstance() {
    // refresh page after 2 seconds
    this.timeout = setTimeout(() => {
      this.reloadInstance();
    }, 2000);
  }

  async reloadInstance() {
    try {
      await this.router.navigate([this.processName, this.instanceId],
          {
            replaceUrl: true
          });
    } catch (error) {
      this.notification.sendError(error.message);
      await this.router.navigate([this.processName]);
    }
  }

  ngOnDestroy() {
    // turn off the reload timer
    clearTimeout(this.timeout);
    if (this.navigationEndSub) {
      this.navigationEndSub.unsubscribe();
    }
  }
}
