import {Component, Input, OnInit} from '@angular/core';
import {faUserCircle, faCaretDown, faQuestion, faSignOutAlt, IconDefinition} from '@fortawesome/free-solid-svg-icons';

export interface UserMenuOption {
  faIcon?: IconDefinition;
  clickFunc: any;
  label: string;
}

@Component({
  selector: 'app-user',
  templateUrl: './user.component.html',
  styleUrls: ['./user.component.scss']
})
export class UserComponent implements OnInit {

  @Input() name: string;
  @Input() company: string;

  @Input()settings: any = {};
  userMenuOptions: UserMenuOption[];

  faUserCircle = faUserCircle;
  faCaretDown = faCaretDown;
  faQuestion = faQuestion;
  faSignOutAlt = faSignOutAlt;

  constructor() {
  }

  ngOnInit(): void {
    this._initUserMenu();
  }

  public onLogout() {
  }

  public onManual() {
    window.open(this.settings.manualLink, '_blank');
  }

  private _initUserMenu() {
    this.userMenuOptions = [];
    if (this.settings.showManual) {
      this.userMenuOptions.push({
        faIcon: this.faQuestion,
        label: 'Manual',
        clickFunc: this.onManual.bind(this),
      });
    }
    if (this.settings.showLogout) {
      this.userMenuOptions.push({
        faIcon: this.faSignOutAlt,
        label: 'Logout',
        clickFunc: this.onLogout.bind(this),
      });
    }
  }
}
