/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitTestTreeModel;
import ch.e2e.resource.ImageLoader;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon errorIcon;
    private Icon okIcon;
    private Icon failureIcon;
    private Icon testunitIcon;

    public TestTreeCellRenderer() {
        this.loadIcons();
    }

    private void loadIcons() {
        this.errorIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/error.gif", (boolean)true);
        this.okIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/ok.gif", (boolean)true);
        this.failureIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/failure.gif", (boolean)true);
        this.testunitIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/testunit.gif", (boolean)true);
    }

    private String stripParenthesis(Object o) {
        String text = o.toString();
        int pos = text.indexOf(40);
        if (pos < 1) {
            return text;
        }
        return text.substring(0, pos);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setText(this.stripParenthesis(value));
        TreeModel model = tree.getModel();
        if (model instanceof JUnitTestTreeModel) {
            JUnitTestTreeModel testModel = (JUnitTestTreeModel)((Object)model);
            if (value instanceof TestSuite) {
                this.setIcon(this.testunitIcon);
            } else if (value instanceof Test) {
                Test t = (Test)value;
                String s = "";
                if (testModel.getRoot().isFailure(t)) {
                    if (this.failureIcon != null) {
                        this.setIcon(this.failureIcon);
                    }
                    s = " - Failed";
                } else if (testModel.getRoot().isError(t)) {
                    if (this.errorIcon != null) {
                        this.setIcon(this.errorIcon);
                    }
                    s = " - Error";
                } else if (testModel.getRoot().wasRun(t)) {
                    if (this.okIcon != null) {
                        this.setIcon(this.okIcon);
                    }
                    s = " - Passed";
                }
                if (c instanceof JComponent) {
                    ((JComponent)c).setToolTipText(this.getText() + s);
                }
            }
        }
        return c;
    }
}

