/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.JUnitGuiRegistry;
import ch.e2e.ant.gui.junit.JUnitStatusLine;
import ch.e2e.resource.ImageLoader;
import ch.e2e.test.Testable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import junit.framework.TestSuite;

public class CounterPanel
extends JPanel {
    private JTextField numberOfErrors;
    private JTextField numberOfFailures;
    private JTextField numberOfRuns;
    private Icon failureIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/failure.gif", (boolean)true);
    private Icon errorIcon = ImageLoader.loadIcon((String)"ch/e2e/gui/junit/error.gif", (boolean)true);
    private int total;

    public CounterPanel() {
        super(new GridBagLayout());
        this.createGui();
        JUnitGuiRegistry.getInstance().registerGui(this);
    }

    private void createGui() {
        this.numberOfErrors = this.createOutputField(5);
        this.numberOfFailures = this.createOutputField(5);
        this.numberOfRuns = this.createOutputField(9);
        this.addToGrid(new JLabel("Runs:", 0), 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToGrid(this.numberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel("Errors:", this.errorIcon, 2), 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.numberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        this.addToGrid(new JLabel("Failures:", this.failureIcon, 2), 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToGrid(this.numberOfFailures, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
    }

    private JTextField createOutputField(int width) {
        JTextField field = new JTextField("0", width);
        field.setMinimumSize(field.getPreferredSize());
        field.setMaximumSize(field.getPreferredSize());
        field.setHorizontalAlignment(2);
        field.setFont(JUnitStatusLine.BOLD_FONT);
        field.setEditable(false);
        field.setBorder(BorderFactory.createEmptyBorder());
        return field;
    }

    public void addToGrid(Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        this.add(comp, constraints);
    }

    public void reset() {
        this.setLabelValue(this.numberOfErrors, 0);
        this.setLabelValue(this.numberOfFailures, 0);
        this.setLabelValue(this.numberOfRuns, 0);
        this.total = 0;
    }

    public void setTotal(int value) {
        this.total = value;
    }

    public void setRunValue(int value) {
        this.numberOfRuns.setText(Integer.toString(value) + "/" + this.total);
    }

    public void setErrorValue(int value) {
        this.setLabelValue(this.numberOfErrors, value);
    }

    public void setFailureValue(int value) {
        this.setLabelValue(this.numberOfFailures, value);
    }

    private void setLabelValue(JTextField label, int value) {
        label.setText(Integer.toString(value));
    }

    public void testSelected(Testable test) {
        this.total = test instanceof TestSuite ? test.countTestCases() : 1;
        this.setRunValue(0);
    }
}

