/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types;

import ch.e2e.ant.AntProjectFactory;
import ch.e2e.ant.gui.AntConsole;
import ch.e2e.ant.gui.configuration.AntExecuter;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.types.AntParam;
import ch.e2e.ant.gui.configuration.types.AntTarget;
import ch.e2e.ant.gui.configuration.types.Output;
import ch.e2e.ant.gui.configuration.types.condition.Property;
import ch.e2e.resource.Properties;
import ch.e2e.transaction.TransactionEvent;
import ch.e2e.transaction.TransactionException;
import ch.e2e.transaction.TransactionListener;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public class Antcall
implements TransactionListener,
BuildListener {
    private int outputLevel = 2;
    private String antfile;
    private ArrayList<AntTarget> targets = new ArrayList();
    private int index = Integer.MIN_VALUE;
    private Properties properties;
    private String debugLevel = "info";
    private boolean returnAllProperties = false;
    private ArrayList<Result> resultList = new ArrayList();
    private String ifString;
    private String unless;
    private String os;
    private ArrayList<AntParam> params = new ArrayList();
    private File basedir;
    private ArrayList<Property> propertyList = new ArrayList();
    private int indent;

    public Antcall clone(Properties properties) {
        Antcall result = new Antcall();
        if (this.basedir != null) {
            result.setBasedir(new File(StringTools.replaceProperties((String)this.basedir.getAbsolutePath(), (Map)properties)));
        }
        if (this.antfile != null) {
            result.setAntfile(StringTools.replaceProperties((String)this.antfile, (Map)properties));
        }
        result.setDebugLevel(StringTools.replaceProperties((String)this.debugLevel, (Map)properties));
        if (this.ifString != null) {
            result.setIf(StringTools.replaceProperties((String)this.ifString, (Map)properties));
        }
        if (this.unless != null) {
            result.setUnless(StringTools.replaceProperties((String)this.unless, (Map)properties));
        }
        if (this.os != null) {
            result.setOs(StringTools.replaceProperties((String)this.os, (Map)properties));
        }
        for (AntTarget antTarget : this.targets) {
            result.addTarget(antTarget.clone(properties));
        }
        for (AntParam antParam : this.params) {
            result.addParam(antParam.clone(properties));
        }
        result.outputLevel = this.outputLevel;
        result.index = this.index;
        result.properties = properties;
        result.returnAllProperties = this.returnAllProperties;
        result.resultList = this.resultList;
        result.propertyList = this.propertyList;
        result.indent = this.indent;
        return result;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected String getIf() {
        return this.ifString;
    }

    public void setIf(String ifString) {
        this.ifString = ifString;
    }

    protected String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    protected String getUnless() {
        return this.unless;
    }

    public void setUnless(String unless) {
        this.unless = unless;
    }

    public void setReturnAllProperties(boolean returnAllProperties) {
        this.returnAllProperties = returnAllProperties;
    }

    public void setAntfile(String antfile) {
        this.antfile = antfile;
    }

    public String getAntfile() {
        return this.antfile;
    }

    public void setTarget(String target) {
        AntTarget antTarget = new AntTarget();
        antTarget.setName(target);
        this.targets.add(antTarget);
    }

    public void addTarget(AntTarget target) {
        this.targets.add(target);
    }

    public void setIndex(int index) {
        if (this.index == Integer.MIN_VALUE) {
            this.index = index;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void addParam(AntParam param) {
        this.params.add(param);
    }

    public void addResult(Result result) {
        this.resultList.add(result);
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean hasExecutableTarget(Properties properties) {
        boolean result;
        boolean bl = result = ConfigurationTools.checkOs(this.os) && ConfigurationTools.checkIfUnless(this.ifString, this.unless, properties);
        if (result) {
            boolean noExecutableTarget = this.targets.size() != 0;
            Iterator<AntTarget> targets = this.targets.iterator();
            while (noExecutableTarget && targets.hasNext()) {
                noExecutableTarget = !targets.next().isExecutable(properties);
            }
            result = !noExecutableTarget;
        }
        return result;
    }

    public void execute(AntConsole antConsole, Properties properties) throws IOException, TransformerException {
        if (ConfigurationTools.checkOs(this.os) && ConfigurationTools.checkIfUnless(this.ifString, this.unless, properties)) {
            this.properties = properties;
            Properties executionProperties = this.setAntParameter(properties);
            Project project = ConfigurationTools.antProjectFactory.getProject(this.antfile, executionProperties, this.basedir);
            ArrayList<AntTarget> targets = this.findExecutableTargets(project, properties);
            if (targets.size() > 0) {
                this.execute(antConsole, targets, project);
            }
        }
    }

    private ArrayList<AntTarget> findExecutableTargets(Project project, Properties properties) {
        String defaultTarget;
        ArrayList<AntTarget> targets = new ArrayList<AntTarget>();
        int length = this.targets.size();
        if (length == 0 && (defaultTarget = project.getDefaultTarget()) != null) {
            AntTarget target = new AntTarget();
            target.setName(defaultTarget);
            targets.add(target);
        }
        for (int i = 0; i < length; ++i) {
            AntTarget antTarget = this.targets.get(i);
            if (!antTarget.isExecutable(properties)) continue;
            targets.add(antTarget);
        }
        return targets;
    }

    private void execute(AntConsole antConsole, ArrayList<AntTarget> targets, Project project) {
        this.outputLevel = Output.getOutputLevel(this.debugLevel);
        String oldDebugLevel = null;
        if (antConsole != null) {
            oldDebugLevel = antConsole.getDebugLevel();
            if (this.debugLevel != null) {
                antConsole.setDebugLevel(this.debugLevel);
            }
        }
        AntExecuter executer = new AntExecuter(project, targets, this);
        executer.execute();
        if (antConsole != null) {
            antConsole.setDebugLevel(oldDebugLevel);
        }
    }

    public void addProperty(Property property) {
        this.propertyList.add(property);
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected Properties setAntParameter(Properties properties) {
        int i;
        Properties executionProperties = this.params.size() == 0 ? properties : this.createExecutionProperties(properties);
        int length = this.resultList.size();
        for (i = 0; i < length; ++i) {
            Result result = this.resultList.get(i);
            executionProperties.remove((Object)result.property);
        }
        length = this.propertyList.size();
        for (i = 0; i < length; ++i) {
            Property property = this.propertyList.get(i);
            executionProperties.putAll(property.getProperties(properties));
        }
        return executionProperties;
    }

    private Properties createExecutionProperties(Properties properties) {
        Properties executionProperties = new Properties();
        executionProperties.putAll((Map)properties);
        int length = this.params.size();
        for (int i = 0; i < length; ++i) {
            AntParam param = this.params.get(i);
            if (!param.isUseable(properties)) continue;
            String name = StringTools.replaceProperties((String)param.getName(), (Map)properties);
            String value = StringTools.replaceProperties((String)param.getValue(), (Map)properties);
            String property = (String)executionProperties.get((Object)name);
            if (property == null) {
                executionProperties.put((Object)name, (Object)value);
                continue;
            }
            executionProperties.put((Object)name, (Object)(property + ' ' + value));
        }
        return executionProperties;
    }

    public void transactionStart(TransactionEvent event) {
    }

    public void transactionEnd(TransactionEvent event) {
    }

    public void transactionFailed(TransactionException exception) {
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        this.printAntMessage(event.getTarget() + ":", 2);
        ++this.indent;
    }

    public void targetFinished(BuildEvent event) {
        --this.indent;
        this.fillProperties(event.getProject());
    }

    public void taskStarted(BuildEvent event) {
        if (!event.getTask().getTaskName().equals("antcall")) {
            ++this.indent;
        }
    }

    public void taskFinished(BuildEvent event) {
        if (!event.getTask().getTaskName().equals("antcall")) {
            --this.indent;
        }
    }

    public void messageLogged(BuildEvent event) {
        String taskName = event.getTask() == null ? "unknown task" : event.getTask().getTaskName();
        this.printAntMessage("[" + taskName + "] " + event.getMessage(), event.getPriority());
    }

    private void printAntMessage(String message, int priority) {
        if (this.outputLevel >= priority) {
            StringBuffer messageBuf = new StringBuffer();
            for (int i = 0; i < this.indent; ++i) {
                messageBuf.append("  ");
            }
            System.out.println(messageBuf.toString() + message);
        }
    }

    private void fillProperties(Project project) {
        if (this.returnAllProperties) {
            for (Object key : project.getProperties().keySet()) {
                if (AntProjectFactory.antProperties.contains(key)) continue;
                this.properties.put(key, (Object)project.getProperty((String)key));
            }
        } else {
            int length = this.resultList.size();
            for (int i = 0; i < length; ++i) {
                Result result = this.resultList.get(i);
                String value = project.getProperty(result.property);
                if (value == null) continue;
                this.properties.setProperty(result.property, value);
            }
        }
    }

    public static class Result {
        private String property;

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

