/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.ant.gui.configuration.Logging;
import ch.e2e.ant.gui.configuration.MethodsNotFoundException;
import ch.e2e.ant.gui.configuration.types.ConfigurationTask;
import ch.e2e.ant.gui.configuration.types.Iterator;
import ch.e2e.ant.gui.configuration.types.PropertiesObject;
import ch.e2e.ant.gui.configuration.types.RootObject;
import ch.e2e.dom.DomUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Parser
implements Logging {
    private static final String UPDATE = "update";
    private static final String ADD = "add";
    private static final String CREATE = "create";
    private static final String TEXT = "TEXT";
    private static final String SET = "set";
    private HashMap<Integer, Element> elements = new HashMap();
    private HashMap<Element, Object> objects = new HashMap();
    private HashMap<Object, Integer> uniqueIds = new HashMap();
    private Properties types;
    private Properties properties;
    private Document document;

    public Parser(Document document, Properties types) {
        this.document = document;
        this.types = types;
    }

    public void parse(RootObject rootObject) {
        Integer id = this.uniqueIds.get(rootObject);
        Element rootElement = this.elements.get(id);
        this.parse((Object)rootObject, rootElement, true);
    }

    public void update(RootObject rootObject) {
        Integer id = this.uniqueIds.get(rootObject);
        Element rootElement = this.elements.get(id);
        this.update(rootObject, rootElement);
    }

    public void parse(Object project, Properties properties, String root) {
        this.properties = properties;
        Element projectElement = this.document.getDocumentElement();
        if (!projectElement.getNodeName().equals(root)) {
            throw new ConfigurationParseException("No " + root + " project found.");
        }
        this.parse(project, projectElement, false);
    }

    private Object createClass(Element element) {
        String name = element.getNodeName();
        String classname = (String)this.types.get((Object)name);
        if (classname == null && element.hasAttribute("class")) {
            classname = element.getAttribute("class");
        }
        if (classname == null) {
            throw new ConfigurationParseException("The element " + name + " must be a registered type or must have a classname attribute.");
        }
        return this.createClass(classname);
    }

    private void update(Object object, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        ObjectMethod[] allMethods = this.copyMethods(object.getClass().getMethods(), new Method[0], object, null);
        HashMap methodMap = this.createUpdateMethods(attributes, allMethods);
        this.updateAttributes(attributes, methodMap);
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        if (length == 1 && children.item(0) instanceof Text) {
            ObjectMethod method = (ObjectMethod)methodMap.get(TEXT);
            if (method != null) {
                this.callTextMethod(children.item(0), method);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Object obj = this.objects.get(child);
                if (obj instanceof Iterator) {
                    this.updateIterator((Iterator)obj, (Element)child);
                    continue;
                }
                this.update(obj, (Element)child);
            }
        }
        if (object instanceof ConfigurationTask) {
            ((ConfigurationTask)object).execute(this.properties);
        }
    }

    private void updateIterator(Iterator iterator, Element iteratorElement) {
        String oldPropertyValue = null;
        String property = iterator.getProperty();
        try {
            oldPropertyValue = this.properties.getString(property);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        ObjectMethod[] allMethods = this.createIteratorMethods(iterator, iteratorElement);
        NamedNodeMap attributes = iteratorElement.getAttributes();
        HashMap methodMap = this.createUpdateMethods(attributes, allMethods);
        this.updateAttributes(attributes, methodMap);
        NodeList children = iteratorElement.getChildNodes();
        while (iterator.hasNext()) {
            this.properties.put((Object)"index", (Object)String.valueOf(iterator.getIndex()));
            this.properties.put((Object)property, iterator.next());
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Object obj = this.objects.get(child);
                if (obj instanceof Iterator) {
                    this.updateIterator((Iterator)obj, (Element)child);
                    continue;
                }
                this.update(obj, (Element)child);
            }
        }
        if (oldPropertyValue == null) {
            this.properties.removeProperty(property);
        } else {
            this.properties.setProperty(property, oldPropertyValue);
        }
    }

    private Integer createUniqueId(Object element) {
        int uniqueId = element.hashCode();
        while (this.uniqueIds.containsKey(uniqueId)) {
            ++uniqueId;
        }
        return uniqueId;
    }

    private void callTextMethod(Node textNode, ObjectMethod method) {
        String text = textNode.getNodeValue();
        text = ConfigurationTools.getInstance().getTranslatedString(text);
        text = StringTools.replaceProperties((String)text, (Map)this.properties);
        this.invoke(method, text);
    }

    private void updateAttributes(NamedNodeMap attributes, HashMap methodMap) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String name = attribute.getName();
            ObjectMethod method = (ObjectMethod)methodMap.get(name);
            if (method == null) continue;
            this.callAttributeMethod(method, this.createValue(attribute.getValue()));
        }
    }

    private Object parse(Object parserObject, Element element, boolean parseRoot) {
        this.registerObject(parserObject, element);
        if (parserObject instanceof PropertiesObject) {
            ((PropertiesObject)parserObject).setProperties(this.properties);
        }
        Method[] methods = parserObject.getClass().getMethods();
        ObjectMethod[] objectMethods = new ObjectMethod[methods.length];
        for (int i = 0; i < objectMethods.length; ++i) {
            objectMethods[i] = new ObjectMethod(methods[i], parserObject);
        }
        NamedNodeMap attributes = element.getAttributes();
        if (parserObject instanceof Iterator) {
            this.parseIterator((Iterator)parserObject, element, parseRoot);
        } else if (parserObject instanceof RootObject) {
            RootObject root = (RootObject)parserObject;
            if (!root.areAttributesParsed()) {
                HashMap setterMap = this.createSetterMethods(element.getNodeName(), attributes, objectMethods);
                this.setAttributes(setterMap, attributes);
                root.setAttributesParsed(true);
            }
            if (parseRoot) {
                this.addChildren(element, objectMethods, parseRoot);
            }
        } else {
            HashMap setterMap = this.createSetterMethods(element.getNodeName(), attributes, objectMethods);
            this.setAttributes(setterMap, attributes);
            this.addChildren(element, objectMethods, parseRoot);
        }
        if (parserObject instanceof ConfigurationTask) {
            ((ConfigurationTask)parserObject).execute(this.properties);
        }
        return parserObject;
    }

    private void addChildren(Element element, ObjectMethod[] objectMethods, boolean parseRoot) {
        NodeList children = element.getChildNodes();
        HashMap childMethodMap = this.createChildMethods(element.getNodeName(), children, objectMethods);
        this.addChildElements(children, childMethodMap, parseRoot);
    }

    private void parseIterator(Iterator iterator, Element iteratorElement, boolean parseRoot) {
        String oldPropertyValue = null;
        String property = iterator.getProperty();
        try {
            oldPropertyValue = this.properties.getString(property);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        ObjectMethod[] allMethods = this.createIteratorMethods(iterator, iteratorElement);
        NamedNodeMap attributes = iteratorElement.getAttributes();
        HashMap setterMethods = this.createSetterMethods(iteratorElement.getNodeName(), attributes, allMethods);
        this.setAttributes(setterMethods, attributes);
        HashMap childMethods = this.createChildMethods(iteratorElement.getNodeName(), iteratorElement.getChildNodes(), allMethods);
        NodeList children = iteratorElement.getChildNodes();
        while (iterator.hasNext()) {
            this.properties.put((Object)"index", (Object)String.valueOf(iterator.getIndex()));
            this.properties.put((Object)property, iterator.next());
            this.addChildElements(children, childMethods, parseRoot);
        }
        if (oldPropertyValue == null) {
            this.properties.removeProperty(property);
        } else {
            this.properties.setProperty(property, oldPropertyValue);
        }
    }

    private ObjectMethod[] createIteratorMethods(Iterator iterator, Element iteratorElement) {
        Element parentElement = (Element)iteratorElement.getParentNode();
        Object parent = this.objects.get(parentElement);
        Method[] parentMethods = parent.getClass().getMethods();
        Method[] iteratorMethods = iterator.getClass().getMethods();
        return this.copyMethods(iteratorMethods, parentMethods, iterator, parent);
    }

    private ObjectMethod[] copyMethods(Method[] iteratorMethods, Method[] parentMethods, Object object, Object parent) {
        int i;
        ObjectMethod[] allMethods = new ObjectMethod[parentMethods.length + iteratorMethods.length];
        for (i = 0; i < iteratorMethods.length; ++i) {
            allMethods[i] = new ObjectMethod(iteratorMethods[i], object);
        }
        for (i = 0; i < parentMethods.length; ++i) {
            allMethods[iteratorMethods.length + i] = new ObjectMethod(parentMethods[i], parent);
        }
        return allMethods;
    }

    private void registerObject(Object parserObject, Element element) {
        Integer objectId = this.createUniqueId(parserObject);
        this.uniqueIds.put(parserObject, objectId);
        this.elements.put(objectId, element);
        this.objects.put(element, parserObject);
    }

    private Object parse(Element element, boolean parseRoot) {
        Object parsedObject = this.createClass(element);
        parsedObject = this.parse(parsedObject, element, parseRoot);
        return parsedObject;
    }

    private void addChildElements(NodeList children, HashMap methods, boolean parseRoot) {
        block16: {
            if (children != null) {
                try {
                    int length = children.getLength();
                    if (length == 1 && children.item(0) instanceof Text) {
                        ObjectMethod method = (ObjectMethod)methods.get(TEXT);
                        if (method != null) {
                            this.callTextMethod(children.item(0), method);
                        }
                        break block16;
                    }
                    for (int i = 0; i < length; ++i) {
                        Object elementObject;
                        Node child = children.item(i);
                        if (!(child instanceof Element)) continue;
                        String name = child.getNodeName();
                        ObjectMethod method = (ObjectMethod)methods.get(name);
                        if (method.method.getName().startsWith(ADD)) {
                            try {
                                elementObject = this.parse((Element)child, parseRoot);
                                this.invoke(method, elementObject);
                                continue;
                            }
                            catch (ConfigurationParseException cpEx) {
                                try {
                                    elementObject = this.createClass(method.method.getParameterTypes()[0]);
                                }
                                catch (ConfigurationParseException e) {
                                    throw cpEx;
                                }
                                this.parse(elementObject, (Element)child, parseRoot);
                                this.invoke(method, elementObject);
                                continue;
                            }
                        }
                        elementObject = method.method.invoke(method.object, new Object[0]);
                        this.parse(elementObject, (Element)child, parseRoot);
                    }
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof ConfigurationParseException) {
                        throw (ConfigurationParseException)ex.getTargetException();
                    }
                    throw new ConfigurationParseException(ex.getTargetException());
                }
                catch (Exception ex) {
                    if (ex instanceof ConfigurationParseException) {
                        throw (ConfigurationParseException)ex;
                    }
                    throw new ConfigurationParseException(ex);
                }
            }
        }
    }

    private HashMap createSetterMethods(String elementName, NamedNodeMap attributes, ObjectMethod[] methods) {
        HashMap<String, ObjectMethod> setterMap = new HashMap<String, ObjectMethod>();
        ArrayList<String> setter = this.getAttributeNames(attributes);
        for (ObjectMethod method : methods) {
            String methodName = method.method.getName();
            this.checkSetter(setter, methodName, method, setterMap);
        }
        if (setter.size() > 0) {
            throw new MethodsNotFoundException("The element " + elementName + " does not support the " + setter.get(0) + " attribute.", setter, null);
        }
        return setterMap;
    }

    private HashMap createChildMethods(String elementName, NodeList children, ObjectMethod[] methods) {
        HashMap<String, ObjectMethod> childMethodMap = new HashMap<String, ObjectMethod>();
        ArrayList<String> elements = this.getElementNames(children);
        for (ObjectMethod method : methods) {
            String methodName = method.method.getName();
            this.checkElementMethods(elements, methodName, method, childMethodMap);
        }
        if (elements.size() > 0) {
            throw new MethodsNotFoundException("The element " + elementName + " does not support the nested " + elements.get(0) + " element.", null, elements);
        }
        return childMethodMap;
    }

    private HashMap createUpdateMethods(NamedNodeMap attributes, ObjectMethod[] methods) {
        HashMap<String, ObjectMethod> methodMap = new HashMap<String, ObjectMethod>();
        ArrayList<String> attributeNames = this.getAttributeNames(attributes);
        for (ObjectMethod method : methods) {
            String methodName = method.method.getName();
            if (methodName.equalsIgnoreCase("updateTEXT")) {
                methodMap.put(TEXT, method);
            }
            int length = attributeNames.size();
            for (int j = 0; j < length; ++j) {
                if (!methodName.equalsIgnoreCase(UPDATE + attributeNames.get(j)) || method.method.getParameterTypes().length != 1) continue;
                methodMap.put(attributeNames.get(j), method);
            }
        }
        return methodMap;
    }

    private ArrayList<String> getElementNames(NodeList children) {
        ArrayList<String> elements = new ArrayList<String>();
        if (children != null) {
            int length = children.getLength();
            if (length == 1 && children.item(0) instanceof Text) {
                if (!DomUtilities.containsOnlyWhiteSpaces((String)children.item(0).getNodeValue())) {
                    elements.add(TEXT);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element) || elements.contains(child.getNodeName())) continue;
                    elements.add(child.getNodeName());
                }
            }
        }
        return elements;
    }

    private ArrayList<String> getAttributeNames(NamedNodeMap attributes) {
        ArrayList<String> setter = new ArrayList<String>();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                setter.add(((Attr)attributes.item(i)).getName());
            }
        }
        return setter;
    }

    private void checkElementMethods(ArrayList<String> elements, String methodName, ObjectMethod method, HashMap<String, ObjectMethod> methodMap) {
        int length = elements.size();
        for (int j = 0; j < length; ++j) {
            String elementName = elements.get(j);
            if ((!methodName.equalsIgnoreCase(ADD + elementName) || method.method.getParameterTypes().length != 1) && (!methodName.equalsIgnoreCase(CREATE + elementName) || method.method.getParameterTypes().length != 0)) continue;
            elements.remove(j);
            methodMap.put(elementName, method);
            break;
        }
    }

    private void checkSetter(ArrayList<String> setter, String methodName, ObjectMethod method, HashMap<String, ObjectMethod> methodMap) {
        int length = setter.size();
        for (int i = 0; i < length; ++i) {
            String searchMethodName = SET + setter.get(i);
            if (!methodName.equalsIgnoreCase(searchMethodName) || method.method.getParameterTypes().length != 1) continue;
            methodMap.put(searchMethodName, method);
            setter.remove(i);
            break;
        }
    }

    private Object createClass(String classname) throws ConfigurationParseException {
        try {
            return this.createClass(Class.forName(classname));
        }
        catch (Exception ex) {
            if (ex instanceof ConfigurationParseException) {
                throw (ConfigurationParseException)ex;
            }
            throw new ConfigurationParseException("Class '" + classname + "' could not be created.", ex);
        }
    }

    private Object createClass(Class elementClass) throws ConfigurationParseException {
        try {
            return elementClass.newInstance();
        }
        catch (Exception ex) {
            throw new ConfigurationParseException("Class '" + elementClass.getName() + "' could not be created.", ex);
        }
    }

    private void setAttributes(HashMap methods, NamedNodeMap attributes) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            ObjectMethod setter = (ObjectMethod)methods.get(SET + attribute.getName());
            String value = this.createValue(attribute.getValue());
            this.callAttributeMethod(setter, value);
        }
    }

    private String createValue(String value) {
        value = ConfigurationTools.getInstance().getTranslatedString(value);
        value = StringTools.replaceProperties((String)value, (Map)this.properties);
        return value;
    }

    private void callAttributeMethod(ObjectMethod setter, String value) {
        Object param;
        Class<?> valueType = setter.method.getParameterTypes()[0];
        if (valueType.equals(String.class)) {
            param = value;
        } else if (valueType.equals(Character.TYPE) || valueType.equals(Character.class)) {
            param = Character.valueOf(value.charAt(0));
        } else if (valueType.equals(Boolean.TYPE) || valueType.equals(Boolean.class)) {
            param = ConfigurationTools.createBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            if (valueType.equals(Byte.TYPE) || valueType.equals(Byte.class)) {
                try {
                    param = new Byte(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a byte value when calling " + setter);
                }
            }
            if (valueType.equals(Short.TYPE) || valueType.equals(Short.class)) {
                try {
                    param = new Short(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a short value when calling " + setter);
                }
            }
            if (valueType.equals(Integer.TYPE) || valueType.equals(Integer.class)) {
                try {
                    param = new Integer(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a integer value when calling " + setter);
                }
            }
            if (valueType.equals(Long.TYPE) || valueType.equals(Long.class)) {
                try {
                    param = new Long(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a long value when calling " + setter);
                }
            }
            if (valueType.equals(Float.TYPE) || valueType.equals(Float.class)) {
                try {
                    param = new Float(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a float value when calling " + setter);
                }
            }
            if (valueType.equals(Double.TYPE) || valueType.equals(Double.class)) {
                try {
                    param = new Double(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Wrong format for a double value when calling " + setter);
                }
            }
            if (valueType.equals(Color.class)) {
                param = ConfigurationTools.createColor(value);
                if (param == null) {
                    throw new ConfigurationParseException("Wrong format for a color value when calling " + setter);
                }
            } else {
                try {
                    Constructor<?> constructor = valueType.getConstructor(String.class);
                    param = constructor.newInstance(value);
                }
                catch (Exception ex) {
                    throw new ConfigurationParseException("Error invoking setter method " + setter, ex);
                }
            }
        }
        this.invoke(setter, param);
    }

    private void invoke(ObjectMethod method, Object param) {
        try {
            method.method.invoke(method.object, param);
        }
        catch (InvocationTargetException itEx) {
            if (itEx.getTargetException() instanceof ConfigurationParseException) {
                throw (ConfigurationParseException)itEx.getTargetException();
            }
        }
        catch (Exception ex) {
            throw new ConfigurationParseException("Error invoking method " + method, ex);
        }
    }

    private class ObjectMethod {
        private Method method;
        private Object object;

        private ObjectMethod(Method method, Object object) {
            this.method = method;
            this.object = object;
        }
    }
}

