/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.Substring;
import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.Parser;
import ch.e2e.ant.gui.configuration.border.AbstractBorder;
import ch.e2e.ant.gui.configuration.border.BevelBorder;
import ch.e2e.ant.gui.configuration.border.EtchedBorder;
import ch.e2e.ant.gui.configuration.border.LineBorder;
import ch.e2e.ant.gui.configuration.border.MatteBorder;
import ch.e2e.ant.gui.configuration.border.SoftBevelBorder;
import ch.e2e.ant.gui.configuration.border.TitledBorder;
import ch.e2e.ant.gui.configuration.types.AbstractGuiElement;
import ch.e2e.ant.gui.configuration.types.Addition;
import ch.e2e.ant.gui.configuration.types.Antcall;
import ch.e2e.ant.gui.configuration.types.Echo;
import ch.e2e.ant.gui.configuration.types.GuiElement;
import ch.e2e.ant.gui.configuration.types.LineBreak;
import ch.e2e.ant.gui.configuration.types.Loop;
import ch.e2e.ant.gui.configuration.types.PropertiesObject;
import ch.e2e.ant.gui.configuration.types.RootObject;
import ch.e2e.ant.gui.configuration.types.Test;
import ch.e2e.ant.gui.configuration.types.condition.Condition;
import ch.e2e.ant.gui.configuration.types.condition.Modulo;
import ch.e2e.ant.gui.configuration.types.condition.Property;
import ch.e2e.ant.gui.configuration.types.display.Image;
import ch.e2e.ant.gui.configuration.types.display.Message;
import ch.e2e.ant.gui.configuration.types.input.CheckBox;
import ch.e2e.ant.gui.configuration.types.input.FolderSelection;
import ch.e2e.ant.gui.configuration.types.input.InputElement;
import ch.e2e.ant.gui.configuration.types.input.IntegerField;
import ch.e2e.ant.gui.configuration.types.input.List;
import ch.e2e.ant.gui.configuration.types.input.RadioButton;
import ch.e2e.ant.gui.configuration.types.input.TextField;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.Properties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ConfigurationPanel
extends JPanel
implements InputFieldListener,
PropertiesObject,
GuiElement,
RootObject {
    protected HashMap<GuiElement, JComponent> components = new HashMap();
    protected ArrayList<Object> elements = new ArrayList();
    private ConfigurationPanel parentPanel;
    private Properties properties;
    private boolean guicreated = false;
    private HashMap<String, ButtonGroup> buttonGroups = new HashMap();
    protected int top = 0;
    protected int left = 0;
    protected int bottom = 0;
    protected int right = 0;
    private String title;
    private int insetsOffset = 0;
    private String anchor = "northwest";
    private String fill = "both";
    private ArrayList<AbstractBorder> borders = new ArrayList();
    private boolean configured = false;
    private int gridwidth = -1;
    private ArrayList<Antcall> antcalls = new ArrayList();
    private ArrayList<Test> tests = new ArrayList();
    private boolean attributesParsed = false;
    private ArrayList<Condition> conditions = new ArrayList();
    private String visibleIf;
    private String visibleUnless;

    public ConfigurationPanel getParentPanel() {
        return this.parentPanel;
    }

    public void setParentPanel(ConfigurationPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    @Override
    public JComponent getComponent() {
        this.configureGui();
        Border border = AbstractBorder.createBorder(this.borders);
        if (border != null) {
            this.setBorder(border);
        }
        return this;
    }

    @Override
    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getAnchor() {
        return AbstractGuiElement.getAnchor(this.anchor);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    @Override
    public int getBottom() {
        return 0;
    }

    @Override
    public void setLeft(int left) {
        this.left = left;
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public void setRight(int right) {
        this.right = right;
    }

    @Override
    public int getRight() {
        return 0;
    }

    @Override
    public void setTop(int top) {
        this.top = top;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getFill() {
        return AbstractGuiElement.getFill(this.fill);
    }

    @Override
    public void setFill(String fill) {
        this.fill = fill;
    }

    @Override
    public void setGridwidth(int gridwidth) {
        this.gridwidth = gridwidth;
    }

    @Override
    public int getGridwidth() {
        return this.gridwidth > 0 ? this.gridwidth : 0;
    }

    public void addMessage(Message message) {
        this.add(message, null);
    }

    public void addList(List list) {
        this.add(list, "list");
    }

    public void addCheckBox(CheckBox checkbox) {
        this.add(checkbox, "checkbox");
    }

    public void addRadioButton(RadioButton radioButton) {
        this.add(radioButton, "radiobutton");
    }

    public void addLineBreak(LineBreak linebreak) {
        this.add(linebreak, null);
    }

    public void addIntegerInput(IntegerField integerField) {
        this.add(integerField, "integerinput");
    }

    public void addDoubleInput(IntegerField integerField) {
        this.add(integerField, "doubleinput");
    }

    public void addTextInput(TextField textField) {
        this.add(textField, "textinput");
    }

    public void addPasswordInput(TextField textField) {
        this.add(textField, "passwordinput");
        textField.setPassword(true);
    }

    public void addImage(Image image) {
        this.add(image, null);
    }

    public void addDirectorySelection(FolderSelection folderSelection) {
        this.add(folderSelection, "directoryselection");
    }

    public void setVisibleIf(String visibleIf) {
        this.visibleIf = visibleIf;
    }

    public boolean isPanelVisible() {
        boolean result = this.visibleIf == null || this.properties.containsKey((Object)this.visibleIf);
        return result &= this.visibleUnless == null || !this.properties.containsKey((Object)this.visibleUnless);
    }

    public void setVisibleUnless(String visibleUnless) {
        this.visibleUnless = visibleUnless;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void addEcho(Echo echo) {
        System.out.println(echo.getMessage());
    }

    public void prepare() {
        this.fillProperties(this.properties);
        int length = this.elements.size();
        JComponent lastVisibleComponent = null;
        boolean weighty = false;
        for (int i = 0; i < length; ++i) {
            Object element = this.elements.get(i);
            if (!(element instanceof GuiElement)) continue;
            GuiElement guiElement = (GuiElement)element;
            JComponent component = this.components.get(element);
            boolean visible = guiElement.isVisible();
            component.setVisible(visible);
            if (visible) {
                lastVisibleComponent = component;
                if (guiElement.getFill() == 3 || guiElement.getFill() == 1) {
                    weighty = true;
                }
            }
            if (element instanceof ConfigurationPanel) {
                if (((ConfigurationPanel)element).isPanelVisible()) {
                    ((ConfigurationPanel)element).prepare();
                    ((ConfigurationPanel)element).setVisible(true);
                    continue;
                }
                ((ConfigurationPanel)element).setVisible(false);
                continue;
            }
            if (!(element instanceof InputElement)) continue;
            ((InputElement)element).setEnabled(this.properties);
            ((InputElement)element).setEditable(this.properties);
        }
        if (!weighty && lastVisibleComponent != null) {
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            GridBagConstraints c = layout.getConstraints(lastVisibleComponent);
            c.weighty = 1.0;
            layout.setConstraints(lastVisibleComponent, c);
        }
    }

    public void setInsetsOffset(int insetsOffset) {
        this.insetsOffset = insetsOffset;
    }

    public void fillProperties(Properties properties) {
        this.fillProperties(properties, new ArrayList<ConfigurationPanel>());
        this.fillConditions(properties, new ArrayList<ConfigurationPanel>());
    }

    private void fillProperties(Properties properties, ArrayList<ConfigurationPanel> panels) {
        if (!panels.contains(this)) {
            panels.add(this);
            int length = this.elements.size();
            for (int i = 0; i < length; ++i) {
                Object guiElement = this.elements.get(i);
                if (guiElement instanceof InputElement) {
                    InputElement element = (InputElement)guiElement;
                    String value = element.getValue();
                    if (value == null) {
                        if (element instanceof RadioButton) {
                            RadioButton button = (RadioButton)element;
                            if (!this.isRadioButtonSelected(button)) {
                                properties.removeProperty(button.getName());
                            }
                        } else {
                            properties.removeProperty(element.getName());
                        }
                    } else if (element.isEnabled()) {
                        properties.setProperty(element.getName(), value);
                    } else {
                        properties.removeProperty(element.getName());
                    }
                }
                if (!(guiElement instanceof ConfigurationPanel)) continue;
                ((ConfigurationPanel)guiElement).fillProperties(properties, panels);
            }
            if (this.parentPanel != null) {
                this.parentPanel.fillProperties(properties, panels);
            }
        }
    }

    private void fillConditions(Properties properties, ArrayList<ConfigurationPanel> panels) {
        if (!panels.contains(this)) {
            panels.add(this);
            for (Condition condition : this.conditions) {
                condition.execute(properties);
            }
            for (Object element : this.elements) {
                if (!(element instanceof ConfigurationPanel)) continue;
                ((ConfigurationPanel)element).fillConditions(properties, panels);
            }
            if (this.parentPanel != null) {
                this.parentPanel.fillConditions(properties, panels);
            }
        }
    }

    private boolean isRadioButtonSelected(RadioButton radioButton) {
        ButtonGroup gp = this.buttonGroups.get(radioButton.getGroup());
        ButtonModel selection = gp.getSelection();
        return selection != null && selection.getActionCommand().equals(radioButton.getName());
    }

    public void componentShown() {
    }

    public void inputFieldChanged(InputFieldEvent e) {
        Properties properties = new Properties();
        properties.putAll((Map)this.getProperties());
        this.fillProperties(properties);
        this.enableInputElements(properties, new ArrayList<ConfigurationPanel>());
    }

    public void enableInputElements(Properties properties, ArrayList<ConfigurationPanel> panels) {
        if (!panels.contains(this)) {
            panels.add(this);
            for (Object element : this.elements) {
                if (element instanceof InputElement) {
                    ((InputElement)element).setEnabled(properties);
                    ((InputElement)element).setEditable(properties);
                    continue;
                }
                if (!(element instanceof ConfigurationPanel)) continue;
                ((ConfigurationPanel)element).enableInputElements(properties, panels);
            }
            if (this.parentPanel != null) {
                this.parentPanel.enableInputElements(properties, panels);
            }
        }
    }

    public void configureGui() {
        if (!this.guicreated) {
            this.guicreated = true;
            this.setBorder(new EmptyBorder(this.top, this.left, this.bottom, this.right));
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.prependElements(c);
            this.addElements(this, this.elements, c);
            this.appendElements(c);
        }
    }

    public void addLoop(Loop loop) {
    }

    public void addModulo(Modulo modulo) {
    }

    public void addAddition(Addition modulo) {
    }

    public void addProperty(Property property) {
    }

    public void addSubstring(Substring substring) {
    }

    public ConfigurationPanel createPanel() {
        ConfigurationPanel panel = new ConfigurationPanel();
        this.add((Object)panel, null);
        return panel;
    }

    public void addEmptyBorder(LineBorder border) {
        this.borders.add(border);
    }

    public void addLineBorder(LineBorder border) {
        this.borders.add(border);
    }

    public void addBevelBorder(BevelBorder border) {
        this.borders.add(border);
    }

    public void addEtchedBorder(EtchedBorder border) {
        this.borders.add(border);
    }

    public void addSoftBevelBorder(SoftBevelBorder border) {
        this.borders.add(border);
    }

    public void addMatteBorder(MatteBorder border) {
        this.borders.add(border);
    }

    public void addTitledBorder(TitledBorder border) {
        this.borders.add(border);
    }

    public void addAntcall(Antcall antcall) {
        if (this.parentPanel == null) {
            this.antcalls.add(antcall);
        } else {
            this.parentPanel.addAntcall(antcall);
        }
    }

    public ArrayList<Antcall> getAntcalls() {
        return this.antcalls;
    }

    public void addTest(Test test) {
        this.addAntcall(test);
    }

    public ArrayList<Test> getTests() {
        return this.tests;
    }

    protected void prependElements(GridBagConstraints c) {
    }

    protected void appendElements(GridBagConstraints c) {
    }

    protected void addElements(JPanel panel, ArrayList elements) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.addElements(panel, elements, c);
    }

    protected void addElements(JPanel panel, ArrayList elements, GridBagConstraints c) {
        int length = elements.size();
        boolean weighty = false;
        for (int i = 0; i < length; ++i) {
            InputElement input;
            Object element = elements.get(i);
            if (element instanceof InputElement && (input = (InputElement)element).getName() == null) {
                throw new ConfigurationParseException("The 'name' attribute of element '" + input.getDisplayName() + "' must be set.");
            }
            if (!(element instanceof GuiElement)) continue;
            GuiElement guiElement = (GuiElement)element;
            int nextIndex = i + 1;
            while (elements.size() > nextIndex) {
                if (elements.get(nextIndex) instanceof LineBreak) {
                    LineBreak linebreak = (LineBreak)elements.get(nextIndex);
                    if (linebreak.isVisible(this.properties)) {
                        guiElement.setGridwidth(-1);
                        nextIndex = elements.size();
                        continue;
                    }
                    ++nextIndex;
                    continue;
                }
                nextIndex = elements.size();
            }
            JComponent component = guiElement.getComponent();
            c.fill = guiElement.getFill();
            if (c.fill == 3 || c.fill == 1) {
                c.weighty = 1.0;
                weighty = true;
            }
            if (i == length - 1 && !weighty && !(guiElement instanceof ConfigurationPanel)) {
                c.weighty = 1.0;
            }
            c.anchor = guiElement.getAnchor();
            c.insets = new Insets(this.insetsOffset + guiElement.getTop(), 5 + this.insetsOffset + guiElement.getLeft(), guiElement.getBottom(), this.insetsOffset + guiElement.getRight());
            c.gridwidth = guiElement.getGridwidth();
            this.addElement(guiElement, component, c, panel);
            c.weighty = 0.0;
        }
    }

    protected void addElement(GuiElement element, JComponent component, GridBagConstraints c, JPanel panel) {
        RadioButton radioButton;
        if (element instanceof RadioButton && (radioButton = (RadioButton)element).getGroup() != null) {
            ButtonGroup bg = this.buttonGroups.get(radioButton.getGroup());
            if (bg == null) {
                bg = new ButtonGroup();
                this.buttonGroups.put(radioButton.getGroup(), bg);
            }
            bg.add((AbstractButton)component);
        }
        if (component instanceof JTextField) {
            JPanel helpPanel = new JPanel(new GridBagLayout());
            Insets original = c.insets;
            c.insets = new Insets(0, 0, 0, 0);
            helpPanel.add((Component)component, c);
            c.insets = original;
            if (c.fill != 1) {
                c.fill = 2;
            }
            panel.add((Component)helpPanel, c);
        } else {
            panel.add((Component)component, c);
        }
        if (element.getForeground() != null) {
            component.setForeground(element.getForeground());
        }
        if (element.getBackground() != null) {
            component.setBackground(element.getBackground());
        }
        this.components.put(element, component);
    }

    protected void add(Object element, String displayName) {
        if (element instanceof InputElement) {
            ((InputElement)element).addInputFieldListener(this);
            ((InputElement)element).setDisplayName(displayName);
        }
        if (element instanceof ConfigurationPanel) {
            ((ConfigurationPanel)element).setParentPanel(this);
        }
        this.elements.add(element);
    }

    @Override
    public void configure(Parser parser) {
        if (this.configured) {
            parser.update(this);
        } else {
            this.configured = true;
            parser.parse(this);
        }
    }

    @Override
    public void setAttributesParsed(boolean attributesParsed) {
        this.attributesParsed = attributesParsed;
    }

    @Override
    public boolean areAttributesParsed() {
        return this.attributesParsed;
    }
}

