/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.AntTransactionErrorHandler;
import ch.e2e.ant.gui.configuration.ConfigurationTools;
import ch.e2e.resource.Properties;
import ch.e2e.transaction.TransactionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.input.InputHandler;

public class AntTransaction
implements TransactionHandler {
    public static final String ANT_FILE = "ant.file";
    private Project project;
    private String targetName;
    private boolean autoproceed;
    private String antfile;
    private ArrayList errorHandler = new ArrayList();

    public AntTransaction(String antfile, String targetName, Properties properties, boolean autoproceed, File basedir) throws IOException, TransformerException {
        this.autoproceed = autoproceed;
        if (ConfigurationTools.antProjectFactory == null) {
            this.doErrorHandling("The AntProjectFactory is not defined.");
        } else {
            this.antfile = antfile;
            this.project = ConfigurationTools.antProjectFactory.getProject(antfile, properties, basedir);
            this.targetName = targetName == null ? this.project.getDefaultTarget() : targetName;
        }
    }

    public void addErrorHandler(AntTransactionErrorHandler errorHandler) {
        this.errorHandler.add(errorHandler);
    }

    public void removeErrorHandler(AntTransactionErrorHandler errorHandler) {
        this.errorHandler.remove(errorHandler);
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.project.setInputHandler(inputHandler);
    }

    public int getTaskCount() {
        int taskCount = 0;
        for (Target target : this.project.getTargets().values()) {
            if (!target.getName().equals(this.targetName)) continue;
            taskCount = this.getTaskCount(target);
            break;
        }
        return taskCount;
    }

    public Object doTransaction(Object transactionData) throws Throwable {
        this.project.executeTarget(this.targetName);
        return this.autoproceed ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Project getProject() {
        return this.project;
    }

    private int getTaskCount(Target target) {
        int taskCount = 0;
        Task[] tasks = target.getTasks();
        for (int i = 0; i < tasks.length; ++i) {
            Task task = tasks[i];
            taskCount += this.getTaskCount(task);
        }
        return taskCount;
    }

    private int getTaskCount(Task task) {
        int taskCount = 0;
        if (task.getTaskName().equalsIgnoreCase("antcall")) {
            String targetStr = (String)task.getRuntimeConfigurableWrapper().getAttributeMap().get("target");
            taskCount = this.getAntcallTaskCount(targetStr);
        } else {
            Class taskClass = (Class)this.project.getTaskDefinitions().get(task.getTaskName());
            if (taskClass != null && TaskContainer.class.isAssignableFrom(taskClass)) {
                RuntimeConfigurable wrapper = task.getRuntimeConfigurableWrapper();
                Enumeration children = wrapper.getChildren();
                int internalTasks = 0;
                while (children.hasMoreElements()) {
                    RuntimeConfigurable next = (RuntimeConfigurable)children.nextElement();
                    String name = next.getElementTag();
                    if (name.equalsIgnoreCase("antcall")) {
                        String targetStr = (String)next.getAttributeMap().get("target");
                        internalTasks += this.getAntcallTaskCount(targetStr);
                        continue;
                    }
                    if (this.project.getTaskDefinitions().get(name) == null) continue;
                    ++internalTasks;
                }
                taskCount += internalTasks;
            }
        }
        return ++taskCount;
    }

    private int getAntcallTaskCount(String target) {
        int taskCount = 0;
        Target nextTarget = (Target)this.project.getTargets().get(target);
        if (nextTarget == null) {
            this.doErrorHandling("The target '" + target + "' could not be found in file '" + this.antfile + "'.");
        }
        return taskCount += this.getTaskCount(nextTarget);
    }

    private void doErrorHandling(String message) {
        int length = this.errorHandler.size();
        for (int i = 0; i < length; ++i) {
            AntTransactionErrorHandler errorHandler = (AntTransactionErrorHandler)this.errorHandler.get(i);
            errorHandler.error(message);
        }
    }
}

