/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.PropertyFile;

public class E2EPropertyFile
extends PropertyFile {
    private File propertyfile;
    private ArrayList<RegexEntry> regexEntries = new ArrayList();
    private ArrayList<StringArrayEntry> stringArrays = new ArrayList();
    private ArrayList<EntryRemover> removers = new ArrayList();

    public void execute() throws BuildException {
        if (this.propertyfile == null) {
            throw new BuildException("file token must not be null.", this.getLocation());
        }
        Properties properties = this.readFile();
        this.findMatchingEntries(properties);
        boolean changed = false;
        if (this.stringArrays.size() > 0) {
            changed = true;
            this.findStringArrays(properties);
        }
        if (this.removers.size() > 0) {
            changed = true;
            this.removeEntries(properties);
        }
        if (changed) {
            try {
                properties.store(new FileOutputStream(this.propertyfile), "");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.execute();
    }

    public void setFile(File file) {
        this.propertyfile = file;
        super.setFile(file);
    }

    public RegexEntry createRegexEntry() {
        RegexEntry entry = new RegexEntry();
        this.regexEntries.add(entry);
        return entry;
    }

    public StringArrayEntry createStringArrayEntry() {
        StringArrayEntry entry = new StringArrayEntry();
        this.stringArrays.add(entry);
        return entry;
    }

    public EntryRemover createEntryRemover() {
        EntryRemover entryRemover = new EntryRemover();
        this.removers.add(entryRemover);
        return entryRemover;
    }

    private void findMatchingEntries(Properties properties) {
        for (RegexEntry regexEntry : this.regexEntries) {
            for (Object o : properties.keySet()) {
                String key = (String)o;
                if (!Pattern.matches(regexEntry.getKey(), key)) continue;
                this.createEntry(key, regexEntry);
            }
        }
    }

    private void createEntry(String key, RegexEntry regexEntry) {
        PropertyFile.Entry entry = this.createEntry();
        entry.setKey(key);
        entry.setValue(regexEntry.getValue());
        if (regexEntry.operation != null) {
            PropertyFile.Entry.Operation operation = new PropertyFile.Entry.Operation();
            operation.setValue(regexEntry.operation);
            entry.setOperation(operation);
        }
        entry.setDefault(regexEntry.defaultValue);
        entry.setPattern(regexEntry.pattern);
        if (regexEntry.type != null) {
            PropertyFile.Entry.Type type = new PropertyFile.Entry.Type();
            type.setValue(regexEntry.type);
            entry.setType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readFile() throws BuildException {
        Properties properties;
        block9: {
            properties = new Properties();
            try {
                if (!this.propertyfile.exists()) break block9;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(this.propertyfile);
                    properties.load(fis);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString());
            }
        }
        return properties;
    }

    private void removeEntries(Properties properties) {
        for (EntryRemover remover : this.removers) {
            for (SimpleEntry entry : remover.entries) {
                if (entry instanceof StringArrayEntry) {
                    this.removeStringArrayEntry((StringArrayEntry)entry, properties);
                    continue;
                }
                if (entry instanceof RegexEntry) {
                    this.removeRegexEntry((RegexEntry)entry, properties);
                    continue;
                }
                properties.remove(entry.getKey());
            }
        }
    }

    private void removeRegexEntry(RegexEntry regexEntry, Properties properties) {
        for (Object o : properties.keySet()) {
            String key = (String)o;
            if (!Pattern.matches(regexEntry.getKey(), key)) continue;
            properties.remove(key);
        }
    }

    private void findStringArrays(Properties properties) {
        for (StringArrayEntry stringArray : this.stringArrays) {
            Object value = properties.get(stringArray.getKey());
            String[] values = stringArray.getValues();
            if (value == null) {
                properties.put(stringArray.getKey(), StringTools.createArrayString((String[])values));
                continue;
            }
            if (stringArray.operation.equalsIgnoreCase("overwrite")) {
                properties.put(stringArray.getKey(), StringTools.createArrayString((String[])values));
                continue;
            }
            String[] oldValue = null;
            if (value instanceof String) {
                try {
                    oldValue = StringTools.createStringArray((String)((String)value));
                }
                catch (ParseException e) {
                    oldValue = new String[]{(String)value};
                }
            } else if (value instanceof String[]) {
                oldValue = (String[])value;
            }
            if (oldValue == null) {
                properties.put(stringArray.getKey(), StringTools.createArrayString((String[])values));
                continue;
            }
            String[] newValue = new String[oldValue.length + values.length];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            System.arraycopy(values, 0, newValue, oldValue.length, values.length);
            if (stringArray.removeDuplicates) {
                ArrayList<String> strings = new ArrayList<String>();
                for (String s : newValue) {
                    if (strings.contains(s)) continue;
                    strings.add(s);
                }
                newValue = new String[strings.size()];
                strings.toArray(newValue);
            }
            properties.put(stringArray.getKey(), StringTools.createArrayString((String[])newValue));
        }
    }

    private void removeStringArrayEntry(StringArrayEntry entry, Properties properties) {
        String value = properties.getProperty(entry.getKey());
        if (value != null) {
            try {
                String[] values = StringTools.createStringArray((String)value);
                ArrayList<String> existingValues = new ArrayList<String>(Arrays.asList(values));
                for (String s : entry.getValues()) {
                    existingValues.remove(s);
                }
                if (existingValues.size() == 0) {
                    properties.remove(entry.getKey());
                } else {
                    String[] newValues = new String[existingValues.size()];
                    existingValues.toArray(newValues);
                    properties.put(entry.getKey(), StringTools.createArrayString((String[])newValues));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public class EntryRemover {
        private ArrayList<SimpleEntry> entries = new ArrayList();

        public RegexEntry createRegexEntry() {
            RegexEntry entry = new RegexEntry();
            this.entries.add(entry);
            return entry;
        }

        public StringArrayEntry createStringArrayEntry() {
            StringArrayEntry entry = new StringArrayEntry();
            this.entries.add(entry);
            return entry;
        }

        public SimpleEntry createEntry() {
            SimpleEntry entry = new SimpleEntry();
            this.entries.add(entry);
            return entry;
        }
    }

    public class SimpleEntry {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringValue {
        private String value;

        public StringValue() {
        }

        public StringValue(String value) {
            this.value = value;
        }

        public void addText(String msg) {
            this.value = E2EPropertyFile.this.getProject().replaceProperties(msg);
        }
    }

    public class StringArrayEntry
    extends SimpleEntry {
        private static final String APPEND = "append";
        private static final String OVERWRITE = "overwrite";
        private String operation = "append";
        ArrayList<StringValue> values = new ArrayList();
        private boolean removeDuplicates = false;

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setRemoveDuplicates(boolean removeDuplicates) {
            this.removeDuplicates = removeDuplicates;
        }

        public StringValue createValue() {
            StringValue value = new StringValue();
            this.values.add(value);
            return value;
        }

        @Override
        public void setValue(String value) {
            String[] values;
            for (String s : values = value.split(",")) {
                this.values.add(new StringValue(s));
            }
        }

        public String[] getValues() {
            String[] result = new String[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                result[i] = this.values.get(i).value;
            }
            return result;
        }
    }

    public class RegexEntry
    extends SimpleEntry {
        private String type;
        private String operation;
        private String defaultValue;
        private String pattern;

        public void setDefault(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

