/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.regtest.event.LibraryChangedEvent;
import ch.e2e.builder.regtest.event.LibraryChangedListener;
import ch.e2e.builder.regtest.event.LibraryObserver;
import ch.e2e.builder.regtest.event.TestSuiteTreeChangedEvent;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.JUnitTest;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.LibraryUtilities;
import ch.e2e.builder.regtest.testsuite.TestSuiteOptions;
import ch.e2e.builder.regtest.testsuite.TestSuiteRoot;
import ch.e2e.builder.regtest.testsuite.TestSuiteUtilities;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tools.TraceTools;
import ch.e2e.builder.traceviewer.execute.RunTestcaseTest;
import ch.e2e.builder.traceviewer.execute.test.TestcaseCompare;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.E2ETest;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.E2ETestSuite;
import ch.e2e.test.E2ETestSuiteTemplate;
import ch.e2e.test.E2ETestSuiteTemplateFactory;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ErrorElement;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.TestErrorEvent;
import ch.e2e.test.TestLogfile;
import ch.e2e.test.TestProperties;
import ch.e2e.test.TestType;
import ch.e2e.test.Testable;
import ch.e2e.test.TypeFactory;
import ch.e2e.test.Utilities;
import ch.e2e.test.junit.TestUnit;
import ch.e2e.test.junit.TestcaseLoadErrorTest;
import ch.e2e.test.options.Option;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Test;
import junit.framework.TestResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TreeTestSuite
extends E2ETestSuite
implements TreePathElement,
LibraryChangedListener {
    public static final int TESTSUITE = 1;
    public static final int TESTSUITE_IN_LIBRARY = 2;
    public static final int LIBRARY = 5;
    private String path;
    private File logFolder;
    private TestSuiteOptions testSuiteOptions;
    private Object treeParent;
    private Integer type;
    private boolean running = false;

    public TreeTestSuite(E2ETestSuiteTemplate template, E2ETestSuite parent, boolean inLibrary) throws Exception {
        super(template, parent, inLibrary);
        this.testSuiteOptions = new TestSuiteOptions(this, this.getOptions());
        this.readErrorList();
        this.checkOutputFolder();
    }

    public TreeTestSuite(File testcaseFile, E2ETestSuite parent, boolean inLibrary) throws Exception {
        super(testcaseFile, parent, inLibrary);
        this.testSuiteOptions = new TestSuiteOptions(this, this.getOptions());
        this.readErrorList();
        this.checkOutputFolder();
    }

    public TreeTestSuite(Document document, File testcaseFile) throws Exception {
        this(document, testcaseFile, null, false);
    }

    public TreeTestSuite(Document document, File testSuiteFile, E2ETestSuite parent, boolean inLibrary) throws Exception {
        super(document, testSuiteFile, parent, inLibrary);
        this.testSuiteOptions = new TestSuiteOptions(this, this.getOptions());
        this.readErrorList();
        this.checkOutputFolder();
    }

    protected TreeTestSuite(ImportTestcaseContainer testcaseContainer, File testSuiteFile, TreeTestSuite parent) throws Exception {
        this.setName(testcaseContainer.getName());
        this.setTestSuiteFile(testSuiteFile);
        this.setParent(parent);
        this.testSuiteOptions = new TestSuiteOptions(this, this.getOptions());
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.appendChildren(testcaseContainer, testSuiteDocument);
        this.serializeTestSuiteDocument(testSuiteDocument, testSuiteFile);
    }

    TreeTestSuite(String name, boolean library) {
        super(name, library);
        this.testSuiteOptions = new TestSuiteOptions(this, this.getOptions());
    }

    public TreeTestSuite(File testcaseFile) throws Exception {
        this(testcaseFile, null, false);
    }

    public TreeTestSuite(String name) throws Exception {
        super(name, false);
    }

    public boolean isLogfileSet() {
        return this.getLogfile() != null && this.getLogfile().getLogfile().equals(this.getLogfileDefault());
    }

    public File getLogfileDefault() {
        return new File(this.getLogFolder(), this.getName() + ".log");
    }

    public File getLogFolder() {
        if (this.logFolder == null) {
            File projectHome = new File(E2EBuilderProject.getProjectFolderName());
            this.logFolder = new File(projectHome, "regressiontest/log/" + this.getPath()).getParentFile();
        }
        return this.logFolder;
    }

    public void addLogfile() {
        TestLogfile logfile = new TestLogfile(this.getLogfileDefault(), false);
        this.setLogfile(logfile);
        try {
            Document testSuiteDocument = DomUtilities.parse((File)this.getTestSuiteFile(), (boolean)false, (boolean)false, (boolean)false);
            DomUtilities.removeAllNotElementEmptyNodes((Element)testSuiteDocument.getDocumentElement());
            Element logfileElement = testSuiteDocument.createElement("logfile");
            logfileElement.setAttribute("name", logfile.getLogfile().getAbsolutePath());
            testSuiteDocument.getDocumentElement().insertBefore(logfileElement, testSuiteDocument.getDocumentElement().getFirstChild());
            this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeLogfile() {
        if (this.isLogfileSet()) {
            if (this.getLogfile().exists()) {
                this.getLogfile().delete();
            }
            if (this.getParent() != null) {
                this.setLogfile(this.getParent().getLogfile());
            }
            try {
                Document testSuiteDocument = DomUtilities.parse((File)this.getTestSuiteFile(), (boolean)false, (boolean)false, (boolean)false);
                DomUtilities.removeAllNotElementEmptyNodes((Element)testSuiteDocument.getDocumentElement());
                Element logfileElement = (Element)DomUtilities.selectNode((Node)testSuiteDocument.getDocumentElement(), (String)"/testcases/logfile");
                if (logfileElement != null) {
                    logfileElement.getParentNode().removeChild(logfileElement);
                }
                this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TestSuiteOptions getTestSuiteOptions() {
        return this.testSuiteOptions;
    }

    public void run() {
        try {
            JUnitTest test = new JUnitTest();
            TestUnit testUnit = new TestUnit();
            testUnit.addTestSuite((E2ETestSuite)this);
            this.deleteLogfile();
            test.doTest(testUnit);
        }
        catch (Throwable e) {
            this.doLoadError(e);
        }
    }

    public TreeTestSuite createNewTestsuite(String name, int index) throws Exception {
        String id = this.createTestSuiteId(name);
        File newTestSuiteFolder = new File(this.getTestSuiteFile().getParentFile(), id);
        File newTestSuiteFile = new File(newTestSuiteFolder, "testsuite.xml");
        TreeTestSuite newTestSuite = this.createNewTestSuite(name);
        newTestSuite.setTestSuiteFile(newTestSuiteFile);
        newTestSuite.setInLibrary(this.isLibrary() || this.isInLibrary());
        Document newTestSuiteDocument = newTestSuite.createTestSuiteDocument(name);
        newTestSuiteFolder.mkdirs();
        this.serializeTestSuiteDocument(newTestSuiteDocument, newTestSuiteFile);
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.addInclude(FileUtilities.getRelativePath((File)newTestSuiteFile, (File)this.getTestSuiteFile().getParentFile()), testSuiteDocument, index);
        this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        this.addTestSuite(newTestSuite, index);
        return newTestSuite;
    }

    protected TreeTestSuite createNewTestSuite(String name) {
        return new TreeTestSuite(name, false);
    }

    public void importTestcase(TraceTestcase traceTestcase, int index, boolean overrideReferenceData) throws Exception {
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.insertTestcase(traceTestcase, testSuiteDocument, index, overrideReferenceData);
        this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
    }

    public void insertTestcase(Testcase testcase, int index) throws Exception {
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.insertTestcase(testcase, index, testSuiteDocument);
        this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
    }

    public void deleteTestSuite(TreeTestSuite test) {
        File errors;
        this.removeTest((Testable)test);
        for (Testable testable : test.getTestcases()) {
            if (testable instanceof TreeTestSuite) {
                this.deleteTestSuite((TreeTestSuite)testable);
                continue;
            }
            if (!(testable instanceof Testcase)) continue;
            this.deleteTestcaseInternal((Testcase)testable);
        }
        if (test.isLibrary()) {
            LibraryObserver.getInstance().unregisterForLibrary((LibraryChangedListener)test.getParent(), test);
        }
        if ((errors = test.getErrorsFile()) != null && errors.exists() && errors.delete() && !test.getTestSuiteFile().getParentFile().equals(errors.getParentFile())) {
            Utilities.deleteEmptyParents((File)errors);
        }
        if ((!test.isLibrary() && !test.isInLibrary() || LibrariesRoot.isInLibraryTree(test)) && test.getTestSuiteFile().delete()) {
            Utilities.deleteEmptyParents((File)test.getTestSuiteFile());
        }
    }

    public void removeTestSuite(TreeTestSuite test) {
        this.removeTest((Testable)test);
        E2ETestSuiteTemplateFactory.getInstance().removeTemplate(test.getTestSuiteFile());
        boolean inLibraryTree = LibrariesRoot.isInLibraryTree(test);
        if (!test.isLibrary() || inLibraryTree) {
            for (Testable testable : test.getTestcases()) {
                if (testable instanceof TreeTestSuite) {
                    if (((TreeTestSuite)testable).isLibrary() && !inLibraryTree) {
                        LibraryObserver.getInstance().unregisterForLibrary(test, (TreeTestSuite)testable);
                        continue;
                    }
                    this.removeTestSuite((TreeTestSuite)testable);
                    continue;
                }
                if (!(testable instanceof Testcase)) continue;
                this.removeTestcase((Testcase)testable);
            }
            if (!test.getTestSuiteFile().delete()) {
                System.err.println("Failed to delete '" + test.getTestSuiteFile().getPath() + "'.");
            }
            if (test.getErrorsFile() != null && test.getErrorsFile().exists() && !test.getErrorsFile().delete()) {
                System.err.println("Failed to delete '" + test.getErrorsFile().getPath() + "'.");
            }
            Utilities.deleteEmptyParents((File)test.getTestSuiteFile());
        }
    }

    public void deleteTestcase(Testcase test) {
        this.deleteTestcaseInternal(test);
    }

    private void deleteTestcaseInternal(Testcase test) {
        test.removeData();
        this.removeTestcaseInternal(test);
    }

    public void removeTestcase(Testcase test) {
        this.removeTestcaseInternal(test);
    }

    private void removeTestcaseInternal(Testcase test) {
        this.removeTest((Testable)test);
        test.getTest().clear();
        this.removeFromErrorList(test);
    }

    private void removeTest(Testable test) {
        try {
            Document testSuiteDocument = this.remove(test);
            this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TreeTestSuite importTestSuite(ImportTestcaseContainer testcaseContainer, int index, boolean overrideReferenceData) throws Exception {
        TreeTestSuite result = this.findTestSuite(testcaseContainer.getName());
        if (result == null) {
            Document testSuiteDocument = this.getTestSuiteDocument();
            result = this.importTestSuite(testcaseContainer, testSuiteDocument, index);
            this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        } else {
            for (TestcaseObject testcaseObject : testcaseContainer.getChildCollection()) {
                if (testcaseObject instanceof TraceTestcase) {
                    result.importTestcase((TraceTestcase)testcaseObject, this.getTestcases().size(), overrideReferenceData);
                    continue;
                }
                if (!(testcaseObject instanceof ImportTestcaseContainer) || !((ImportTestcaseContainer)testcaseObject).hasExecutedTestcases()) continue;
                result.importTestSuite((ImportTestcaseContainer)testcaseObject, this.getTestcases().size(), overrideReferenceData);
            }
        }
        return result;
    }

    public void insertTestSuite(TreeTestSuite testSuite, int index) throws Exception {
        testSuite.setParent(this);
        this.moveTestSuite(testSuite);
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.addInclude(FileUtilities.getRelativePath((File)testSuite.getTestSuiteFile(), (File)this.getTestSuiteFile().getParentFile()), testSuiteDocument, index);
        this.addTestSuite(testSuite, index);
        this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        this.reload();
    }

    private void moveTestSuite(TreeTestSuite testSuite) throws TransformerException, IOException, XPathExpressionException {
        this.moveTestSuite(testSuite, true);
    }

    private void moveTestSuite(TreeTestSuite testSuite, boolean topLevel) throws TransformerException, IOException, XPathExpressionException {
        if (!testSuite.isLibrary() || LibrariesRoot.isInLibraryTree(testSuite)) {
            String name = topLevel ? this.createTestSuiteId(testSuite.getName()) : testSuite.getTestSuiteFile().getParentFile().getName();
            File newTestSuiteFolder = new File(this.getTestSuiteFile().getParentFile(), name);
            testSuite.setTestSuiteFile(new File(newTestSuiteFolder, testSuite.getTestSuiteFile().getName()));
            Map<String, String> props = testSuite.createFolderProperties();
            for (Testable testable : testSuite.getTestcases()) {
                if (testable instanceof TreeTestSuite) {
                    testSuite.moveTestSuite((TreeTestSuite)testable, false);
                    continue;
                }
                if (!(testable instanceof Testcase)) continue;
                Utilities.insertProperties((E2ETestcase)((Testcase)testable), props);
            }
            testSuite.persist();
        }
    }

    public void importLibrary(TreeTestSuite library, int index) throws Exception {
        Document testSuiteDocument = this.getTestSuiteDocument();
        this.addLibrary(library, index, testSuiteDocument);
        this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
    }

    private void addLibrary(TreeTestSuite library, int index, Document testSuiteDocument) throws Exception {
        this.addInclude(FileUtilities.getRelativePath((File)library.getTestSuiteFile(), (File)this.getTestSuiteFile().getParentFile()), testSuiteDocument, index);
        TreeTestSuite testSuite = this.createTestSuite(library.getTemplate(), true);
        this.addTestSuite(testSuite, index);
    }

    public TreeTestSuite replaceWithLibrary(TreeTestSuite testSuite, String newLibrary, LibrariesRoot libraries) throws Exception {
        Library library = null;
        try {
            int index = this.getTestcases().indexOf(testSuite);
            Document testSuiteDocument = this.remove((Testable)testSuite);
            testSuite.getTestSuiteFile().delete();
            Utilities.deleteEmptyParents((File)testSuite.getTestSuiteFile());
            library = LibraryUtilities.getInstance().replaceWithLibrary(testSuite, newLibrary, libraries);
            this.addLibrary(library, index, testSuiteDocument);
            this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return library;
    }

    public void moveTestcaseData(Testcase testcase, TreeTestSuite oldTestSuite) throws TransformerException, IOException, XPathExpressionException {
        File projectHome = new File(System.getProperty("ch.e2e.builder.base.home"));
        File oldReferenceFolder = new File(projectHome, "regressiontest/reference/" + oldTestSuite.getPath());
        File newReferenceFolder = new File(projectHome, "regressiontest/reference/" + this.getPath());
        File oldSourceFolder = new File(projectHome, "regressiontest/source/" + oldTestSuite.getPath());
        File newSourceFolder = new File(projectHome, "regressiontest/source/" + this.getPath());
        TestSuiteUtilities.getInstance().moveTestcaseData(testcase, oldReferenceFolder, newReferenceFolder, oldSourceFolder, newSourceFolder);
    }

    public void moveTestcaseData(TreeTestSuite testSuite) throws TransformerException, IOException, XPathExpressionException {
        this.moveTestcaseData(testSuite, this.getPath());
    }

    public void persist(Testcase testcase, String oldName) {
        try {
            Document testSuiteDocument = this.getTestSuiteDocument();
            Element testcaseElement = this.findTestcaseElement(oldName, testSuiteDocument);
            if (testcaseElement == null) {
                testSuiteDocument.getDocumentElement().appendChild(testcase.toXml(testSuiteDocument));
            } else {
                testcaseElement.getParentNode().replaceChild(testcase.toXml(testSuiteDocument), testcaseElement);
            }
            this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean containsTestable(Testable testable) {
        boolean result = false;
        int length = this.getTestcases().size();
        for (int i = 0; i < length && !result; ++i) {
            Testable test = (Testable)this.getTestcases().get(i);
            result = testable instanceof TreeTestSuite && test instanceof TreeTestSuite ? testable.equals(test) : (test instanceof TreeTestSuite ? ((TreeTestSuite)test).containsTestable(testable) : testable.equals(test));
        }
        return result;
    }

    private void moveTestcaseData(TreeTestSuite testSuite, String parentPath) throws TransformerException, IOException, XPathExpressionException {
        String newPath = "/" + parentPath + "/" + testSuite.getTestSuiteFile().getParentFile().getName();
        if ((testSuite.isLibrary() || testSuite.isInLibrary()) && !LibrariesRoot.isInLibraryTree(testSuite)) {
            for (Testable testable : testSuite.getTestcases()) {
                if (testable instanceof Testcase) {
                    this.clearTestcase((Testcase)testable);
                    continue;
                }
                if (!(testable instanceof TreeTestSuite)) continue;
                this.moveTestcaseData((TreeTestSuite)testable, newPath);
            }
        } else {
            File projectHome = new File(System.getProperty("ch.e2e.builder.base.home"));
            File oldReferenceFolder = new File(projectHome, "regressiontest/reference/" + testSuite.getPath());
            File newReferenceFolder = new File(projectHome, "regressiontest/reference" + newPath);
            File oldSourceFolder = new File(projectHome, "regressiontest/source/" + testSuite.getPath());
            File newSourceFolder = new File(projectHome, "regressiontest/source" + newPath);
            File oldOutputFolder = new File(projectHome, "regressiontest/.$output/" + testSuite.getPath());
            File newOutputFolder = new File(projectHome, "regressiontest/.$output" + newPath);
            for (Testable testable : testSuite.getTestcases()) {
                if (testable instanceof Testcase) {
                    Testcase testcase = (Testcase)testable;
                    TestSuiteUtilities.getInstance().moveTestcaseData(testcase, oldReferenceFolder, newReferenceFolder, oldSourceFolder, newSourceFolder);
                    this.clearTestcase(testcase);
                    testcase.getTest().changeOutputFolder(oldOutputFolder, newOutputFolder);
                    continue;
                }
                if (!(testable instanceof TreeTestSuite)) continue;
                this.moveTestcaseData((TreeTestSuite)testable, newPath);
            }
            testSuite.path = null;
        }
    }

    private void clearTestcase(Testcase testcase) {
        testcase.getTest().clear();
        testcase.getTest().removeOutput();
        testcase.setRun(false);
        this.removeFromErrorList(testcase);
    }

    public void move(Testable test, int index) {
        try {
            Document testSuiteDocument = this.getTestSuiteDocument();
            Element testElement = this.findTestElement(test, testSuiteDocument);
            if (testElement != null) {
                testSuiteDocument.getDocumentElement().removeChild(testElement);
                if (index == this.getTestcases().size()) {
                    testSuiteDocument.getDocumentElement().appendChild(testElement);
                } else {
                    Element next = this.findTestElement((Testable)this.getTestcases().get(index), testSuiteDocument);
                    testSuiteDocument.getDocumentElement().insertBefore(testElement, next);
                }
                this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
                int oldIndex = this.getIndexOfTest(test);
                if (oldIndex != -1 && oldIndex < index) {
                    --index;
                }
                this.moveInternal(test, index);
                test.setParent((E2ETestSuite)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sortByName() {
        super.sortByName();
        List testcases = this.getTestcases();
        for (int i = 0; i < testcases.size(); ++i) {
            this.move((Testable)testcases.get(i), i);
        }
    }

    public void findExistingTestPaths(Collection<String> existingTestPaths, String startPath) {
        startPath = startPath == null ? "" : startPath + this.getName() + '/';
        for (Testable testable : this.getTestcases()) {
            if (testable instanceof Testcase) {
                existingTestPaths.add(startPath + testable.getName());
                continue;
            }
            if (!(testable instanceof TreeTestSuite)) continue;
            ((TreeTestSuite)testable).findExistingTestPaths(existingTestPaths, startPath);
        }
    }

    public void findExistingTestNames(Collection<String> existingTestNames) {
        for (Testable testable : this.getTestcases()) {
            if (!(testable instanceof Testcase)) continue;
            existingTestNames.add(testable.getName());
        }
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.createPath();
        }
        return this.path;
    }

    protected String createPath() {
        StringBuilder pathBuff = new StringBuilder(this.getTestSuiteFile().getParentFile().getName());
        TreeTestSuite parent = this;
        while (parent.getParent() != null && !(parent.getParent() instanceof TestSuiteRoot)) {
            parent = parent.getParent();
            pathBuff.insert(0, parent.getTestSuiteFile().getParentFile().getName() + '/');
        }
        return pathBuff.toString();
    }

    public void persistOptions(OptionContainer options) throws Exception {
        TestType type = options.getType();
        Document document = this.getTestSuiteDocument();
        Element optionsElement = (Element)DomUtilities.selectNode((Node)document.getDocumentElement(), (String)("/(testcases|library)/options[@type='" + type.getName() + "']"));
        this.insertProperties(options);
        Element newOptions = options.optionsToXml(true, document);
        if (optionsElement == null) {
            Element testElement = this.findTestElement((Testable)this.getTestcases().get(0), document);
            Node parent = testElement.getParentNode();
            parent.insertBefore(newOptions, testElement);
        } else {
            optionsElement.getParentNode().replaceChild(newOptions, optionsElement);
        }
        this.serializeTestSuiteDocument(document, this.getTestSuiteFile());
    }

    private void insertProperties(OptionContainer options) {
        this.insertProperties(options.getOptions(), (Map<String, String>)this.getProperties());
        this.insertProperties(options.getAdvancedOptions(), (Map<String, String>)this.getProperties());
    }

    protected void insertProperties(Map<String, Option> options, Map<String, String> properties) {
        String key = "project.folder";
        properties.put(key, System.getProperties().getProperty(key));
        Utilities.insertProperties(options, properties);
    }

    public void removeOptions(OptionContainer options) throws Exception {
        this.testSuiteOptions.remove(options);
        TestType type = options.getType();
        Document document = this.getTestSuiteDocument();
        Element optionsElement = (Element)DomUtilities.selectNode((Node)document.getDocumentElement(), (String)("/" + document.getDocumentElement().getNodeName() + "/options[@type='" + type.getName() + "']"));
        if (optionsElement != null) {
            optionsElement.getParentNode().removeChild(optionsElement);
        }
        this.serializeTestSuiteDocument(document, this.getTestSuiteFile());
    }

    public void setParent(E2ETestSuite parent) {
        if (!(parent == null || this.getParent() != null && this.getParent().equals(parent) && this.treeParent != null && this.treeParent.equals(parent))) {
            super.setParent(parent);
            this.setTreeParent(parent);
            this.path = null;
        }
    }

    @Override
    public Object getTreeParent() {
        return this.treeParent;
    }

    public void setTreeParent(Object treeParent) {
        this.treeParent = treeParent;
    }

    @Override
    public boolean isDescendant(TreePathElement element) {
        if (element != null) {
            Object parent = element.getTreeParent();
            while (parent instanceof TreePathElement) {
                if (this.equals(parent)) {
                    return true;
                }
                parent = ((TreePathElement)parent).getTreeParent();
            }
        }
        return false;
    }

    public void run(TestResult result) {
        try {
            this.running = true;
            super.run(result);
            this.writeErrors();
            this.running = false;
        }
        finally {
            System.gc();
        }
    }

    public void addToErrorList(Testcase testcase) {
        try {
            Document errorsDocument = this.getErrorsDocument();
            Element testcaseElement = (Element)DomUtilities.selectNode((Node)errorsDocument.getDocumentElement(), (String)("/Errorlist/Testcase[@name='" + StringTools.escapeXpath((String)testcase.getName()) + "']"));
            if (testcaseElement == null) {
                errorsDocument.getDocumentElement().appendChild(testcase.getErrorsElement(errorsDocument));
            } else {
                testcaseElement.getParentNode().replaceChild(testcase.getErrorsElement(errorsDocument), testcaseElement);
            }
            File errorsFile = this.getErrorsFile();
            errorsFile.getParentFile().mkdirs();
            DomUtilities.serialize((File)errorsFile, (Document)errorsDocument, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getErrorsFile() {
        File errorFile = null;
        if (this.isLibrary() || this.isInLibrary()) {
            TreeTestSuite parent;
            StringBuilder path = new StringBuilder("testsuite.errors");
            for (parent = this; parent != null && (parent.isLibrary() || parent.isInLibrary()); parent = (TreeTestSuite)parent.getParent()) {
                path.insert(0, parent.getTestSuiteFile().getParentFile().getName() + "/");
            }
            if (parent != null) {
                errorFile = new File(parent.getTestSuiteFile().getParentFile(), path.toString());
            }
        } else {
            errorFile = new File(this.getTestSuiteFile().getParentFile(), "testsuite.errors");
        }
        return errorFile;
    }

    public void removeFromErrorList(Testcase testcase) {
        this.removeFromErrorList(testcase.getName());
    }

    public void renameErrorListEntry(String newName, String oldName) {
        try {
            Document errorsDocument = this.getErrorsDocument();
            Element testcaseElement = (Element)DomUtilities.selectNode((Node)errorsDocument.getDocumentElement(), (String)("/Errorlist/Testcase[@name='" + StringTools.escapeXpath((String)oldName) + "']"));
            if (testcaseElement != null) {
                testcaseElement.setAttribute("name", newName);
                File errorsFile = this.getErrorsFile();
                errorsFile.getParentFile().mkdirs();
                DomUtilities.serialize((File)errorsFile, (Document)errorsDocument, (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void addTypeProperties(Properties typeProperties) {
        TypeFactory.getInstance().addTypes(typeProperties, Boolean.getBoolean("ch.e2e.builder.regtest.ignoreCreateFlag"), Boolean.getBoolean("ch.e2e.builder.regtest.ignoreOptionsFlag"));
    }

    private void addTestSuite(TreeTestSuite testSuite, int index) {
        this.addTest((Test)testSuite, index);
    }

    public TreeTestSuite createTestSuite(E2ETestSuiteTemplate template, boolean inLibrary) throws Exception {
        TreeTestSuite result = new TreeTestSuite(template, (E2ETestSuite)this, inLibrary);
        if (template.isLibrary()) {
            LibraryObserver.getInstance().registerForLibrary(this, result);
        }
        return result;
    }

    public Testable createTestcase(Element testcaseElement, File parentFile) throws Exception {
        return new Testcase(testcaseElement, parentFile, this);
    }

    protected Document createTestSuiteDocument(String name) throws XPathExpressionException {
        Document testSuiteDocument = this.isLibrary() ? DomUtilities.newDocument((String)"library") : DomUtilities.newDocument((String)"testcases");
        testSuiteDocument.getDocumentElement().setAttribute("name", name);
        this.checkFolderProperties(testSuiteDocument);
        return testSuiteDocument;
    }

    protected void addInclude(String includeName, Document testSuiteDocument, int index) throws XPathExpressionException {
        Element includeElement = this.createIncludeElement(includeName, testSuiteDocument);
        if (index == this.getTestcases().size()) {
            testSuiteDocument.getDocumentElement().appendChild(includeElement);
        } else {
            this.insertElementAt(includeElement, index, testSuiteDocument);
        }
    }

    protected void serializeTestSuiteDocument(Document testSuiteDocument, File testSuiteFile) throws Exception {
        testSuiteFile.getParentFile().mkdirs();
        DomUtilities.serialize((File)testSuiteFile, (Document)testSuiteDocument, (boolean)true);
    }

    private TreeTestSuite importTestSuite(ImportTestcaseContainer testcaseContainer, Document testSuiteDocument, int index) throws Exception {
        File testSuiteFolder = new File(this.getTestSuiteFile().getParentFile(), this.createTestSuiteId(testcaseContainer.getName()));
        File testSuiteFile = new File(testSuiteFolder, "testsuite.xml");
        TreeTestSuite result = this.createTestSuite(testcaseContainer, testSuiteFile);
        this.addTestSuite(result, index);
        this.addInclude(FileUtilities.getRelativePath((File)testSuiteFile, (File)this.getTestSuiteFile().getParentFile()), testSuiteDocument, index + 1);
        return result;
    }

    protected TreeTestSuite createTestSuite(ImportTestcaseContainer testcaseContainer, File testSuiteFile) throws Exception {
        return new TreeTestSuite(testcaseContainer, testSuiteFile, this);
    }

    public Document getTestSuiteDocument() throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document testSuiteDocument;
        if (this.getTestSuiteFile().exists()) {
            testSuiteDocument = DomUtilities.parse((File)this.getTestSuiteFile(), (boolean)false, (boolean)false, (boolean)false);
            DomUtilities.removeAllNotElementEmptyNodes((Element)testSuiteDocument.getDocumentElement());
        } else {
            testSuiteDocument = this.createTestSuiteDocument(this.getName());
        }
        this.checkFolderProperties(testSuiteDocument);
        return testSuiteDocument;
    }

    private void appendChildren(ImportTestcaseContainer testcaseContainer, Document testSuiteDocument) throws Exception {
        for (TestcaseObject testcaseObject : testcaseContainer.getChildCollection()) {
            if (testcaseObject instanceof TraceTestcase) {
                this.insertTestcase((TraceTestcase)testcaseObject, testSuiteDocument, this.getTestcases().size(), true);
                continue;
            }
            if (!(testcaseObject instanceof ImportTestcaseContainer) || !((ImportTestcaseContainer)testcaseObject).hasExecutedTestcases()) continue;
            this.importTestSuite((ImportTestcaseContainer)testcaseObject, testSuiteDocument, this.getTestcases().size());
        }
    }

    private Element findTestElement(Testable test, Document testSuiteDocument) throws XPathExpressionException {
        Element testElement = test instanceof TreeTestSuite ? this.findIncludeEntry(((TreeTestSuite)test).getTestSuiteFile(), testSuiteDocument) : this.findTestcaseElement(test.getName(), testSuiteDocument);
        return testElement;
    }

    private Element findTestcaseElement(String name, Document testSuiteDocument) throws XPathExpressionException {
        Element testElement = (Element)DomUtilities.selectNode((Node)testSuiteDocument.getDocumentElement(), (String)("/" + testSuiteDocument.getDocumentElement().getNodeName() + "/testcase[@name='" + StringTools.escapeXpath((String)name) + "']"));
        return testElement;
    }

    protected Element findIncludeEntry(File testSuiteFile, Document testSuiteDocument) throws XPathExpressionException {
        String relativePath = FileUtilities.getRelativePath((File)testSuiteFile, (File)this.getTestSuiteFile().getParentFile());
        NodeList includes = testSuiteDocument.getDocumentElement().getElementsByTagName("include");
        int length = includes.getLength();
        for (int i = 0; i < length; ++i) {
            Element item = (Element)includes.item(i);
            if (!item.getAttribute("file").replace('\\', '/').equals(relativePath)) continue;
            return item;
        }
        return null;
    }

    private Testcase insertTestcase(TraceTestcase traceTestcase, Document testSuiteDocument, int index, boolean overrideReferenceData) throws Exception {
        Testcase testcase = null;
        if (traceTestcase.isRun()) {
            testcase = this.createTestcase(traceTestcase);
            String name = testcase.getName();
            Testcase oldTestcase = this.findTestcase(name);
            if (oldTestcase == null) {
                if (index == this.getTestcases().size()) {
                    this.addTest((Test)testcase);
                    Utilities.insertProperties((E2ETestcase)testcase);
                    testSuiteDocument.getDocumentElement().appendChild(testcase.toXml(testSuiteDocument));
                } else {
                    this.insertTestcase(testcase, index, testSuiteDocument);
                }
            } else {
                this.replaceTestcase(oldTestcase, testcase);
                this.copyOptions(oldTestcase, testcase);
                Element testElement = this.findTestElement((Testable)testcase, testSuiteDocument);
                Node parentNode = testElement.getParentNode();
                Utilities.insertProperties((E2ETestcase)testcase);
                parentNode.replaceChild(testcase.toXml(testSuiteDocument), testElement);
            }
            this.copyFiles(traceTestcase, this.getPath(), overrideReferenceData);
        }
        return testcase;
    }

    private void insertTestcase(Testcase testcase, int index, Document testSuiteDocument) throws XPathExpressionException {
        testcase.setParent(this);
        Utilities.insertProperties((E2ETestcase)testcase);
        Element testableElement = testcase.toXml(testSuiteDocument);
        this.insertElementAt(testableElement, index, testSuiteDocument);
        this.addTest((Test)testcase, index);
    }

    private void insertElementAt(Element testableElement, int index, Document testSuiteDocument) throws XPathExpressionException {
        Element testElement = null;
        if (index < this.getTestcases().size()) {
            testElement = this.findTestElement((Testable)this.getTestcases().get(index), testSuiteDocument);
        }
        if (testElement == null) {
            testSuiteDocument.getDocumentElement().appendChild(testableElement);
        } else {
            testSuiteDocument.getDocumentElement().insertBefore(testableElement, testElement);
        }
    }

    public Testcase findTestcase(String name) {
        Testable test = this.getTest(name);
        Testcase testcase = null;
        if (test instanceof Testcase) {
            testcase = (Testcase)test;
        }
        return testcase;
    }

    public TreeTestSuite findTestSuite(String path) {
        String[] parts = path.split("/");
        TreeTestSuite testSuite = this;
        for (int i = 0; i < parts.length && testSuite != null; ++i) {
            Testable testable = testSuite.getTest(parts[i]);
            testSuite = testable instanceof TreeTestSuite ? (TreeTestSuite)testable : null;
        }
        return testSuite;
    }

    public List<TreeTestSuite> findTestSuites(TreeTestSuite root, String name) {
        ArrayList<TreeTestSuite> testSuites = new ArrayList<TreeTestSuite>();
        this.findTestSuites(root, testSuites, name);
        return testSuites;
    }

    private void findTestSuites(TreeTestSuite root, List<TreeTestSuite> testSuites, String name) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            Object object = root.getChild(i);
            if (!(object instanceof TreeTestSuite)) continue;
            TreeTestSuite testSuite = (TreeTestSuite)object;
            if (testSuite.getName().equals(name)) {
                testSuites.add(testSuite);
            }
            this.findTestSuites(testSuite, testSuites, name);
        }
    }

    private void copyFiles(TraceTestcase testcase, String path, boolean overrideReferenceData) throws IOException, SAXException, ParserConfigurationException, TransformerException, XPathExpressionException {
        this.copySourceFiles(testcase, path);
        if (overrideReferenceData) {
            this.copyReferenceFiles(testcase, path);
        }
    }

    private void copyReferenceFiles(TraceTestcase testcase, String path) throws IOException {
        testcase.copyReferenceData(path);
    }

    private void copySourceFiles(TraceTestcase testcase, String path) throws IOException, SAXException, ParserConfigurationException, TransformerException, XPathExpressionException {
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        File sourceHome = new File(projectHome, "regressiontest/source");
        File sourceFolder = new File(sourceHome, path + '/' + testcase.getTemplate().getFullQualifiedName());
        FileUtilities.copyFile((File)testcase.getTemplate().getTemplateFile(), (File)new File(sourceFolder, testcase.getTemplate().getTemplateFile().getName()));
        File sourceRequest = new File(sourceFolder, testcase.getTestName() + ".request");
        FileUtilities.copyFile((File)testcase.getRequest().getRequestFile(), (File)sourceRequest);
        testcase.saveProperties(sourceFolder, testcase.getTestName() + ".testcase");
        File httpHeader = new File(sourceFolder, testcase.getTestName() + ".httpheader");
        if (testcase.getHttpHeadersFile().exists()) {
            FileUtilities.copyFile((File)testcase.getHttpHeadersFile(), (File)httpHeader);
        }
        this.copyMockups(testcase, sourceFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyMockups(TraceTestcase testcase, File sourceFolder) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        Document mockupsDocument;
        NodeList mockupElements;
        File mockupFile = testcase.getAdapterOutputsFile();
        if (mockupFile.exists() && (mockupElements = (mockupsDocument = DomUtilities.parse((File)mockupFile, (boolean)false, (boolean)false, (boolean)false)).getElementsByTagName("Adapter")).getLength() > 0) {
            FileUtilities.copyFile((File)mockupFile, (File)new File(sourceFolder, testcase.getTestName() + ".adapters"));
            File adapterInfos = new File(testcase.getHome().getParentFile(), "adapter.template.ids");
            Document adapterInfosDocument = DomUtilities.parse((File)adapterInfos, (boolean)false, (boolean)false, (boolean)false);
            Document testAdapterInfosDocument = DomUtilities.newDocument((String)adapterInfosDocument.getDocumentElement().getNodeName());
            File adapterTemplatesFile = new File(testcase.getHome().getParentFile(), "adapter.templates.zip");
            File testAdapterTemplatesFile = new File(sourceFolder, "adapter.templates.zip");
            try (ZipOutputStream adapterTemplates = null;){
                adapterTemplates = new ZipOutputStream(new FileOutputStream(testAdapterTemplatesFile));
                int length = mockupElements.getLength();
                for (int i = 0; i < length; ++i) {
                    Element mockup = (Element)mockupElements.item(i);
                    String id = mockup.getAttribute("id");
                    Element adapterInfo = (Element)DomUtilities.selectNode((Node)adapterInfosDocument.getDocumentElement(), (String)("/UniqueIds/UniqueId[@original='" + id + "']"));
                    if (adapterInfo == null) continue;
                    testAdapterInfosDocument.getDocumentElement().appendChild(testAdapterInfosDocument.adoptNode(adapterInfo));
                    Document templateDoc = ZipUtilities.getZippedDocumentFromFile((File)adapterTemplatesFile, (String)adapterInfo.getAttribute("id"), (boolean)false, (boolean)false);
                    if (templateDoc == null) continue;
                    ZipEntry newEntry = new ZipEntry(adapterInfo.getAttribute("id"));
                    adapterTemplates.putNextEntry(newEntry);
                    DomUtilities.serialize((OutputStream)adapterTemplates, (Document)templateDoc, (boolean)true, (boolean)false);
                    adapterTemplates.closeEntry();
                }
                DomUtilities.serialize((File)new File(sourceFolder, "adapter.template.ids"), (Document)testAdapterInfosDocument, (boolean)true);
            }
        }
    }

    private Testcase createTestcase(TraceTestcase traceTestcase) throws Exception {
        RunTestcaseTest test = (RunTestcaseTest)Utilities.createTest((TestType)TypeFactory.getInstance().getType("TestcaseTest"));
        Utilities.mergeOptions((OptionContainer)this.getInheritedOptions(test.getType(), true), (OptionContainer)test);
        String testcaseName = traceTestcase.getTestName();
        test.setOption("key.option.test.name", testcaseName);
        test.setOption("run.testcase.test.operation", traceTestcase.getTemplate().getFullQualifiedName());
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        File sourceRoot = new File(projectHome, "regressiontest/source");
        File sourceFolder = new File(sourceRoot, this.getPath());
        test.setOption("run.testcase.test.testcase.home", sourceFolder.getAbsolutePath());
        File referenceRoot = new File(projectHome, "regressiontest/reference");
        File referenceFolder = new File(referenceRoot, this.getPath());
        referenceFolder = new File(referenceFolder, traceTestcase.getTemplate().getFullQualifiedName());
        referenceFolder = new File(referenceFolder, testcaseName);
        String outputFolder = LibrariesRoot.isInLibraryTree(this) ? "${library.output.folder}/" + traceTestcase.getTemplate().getFullQualifiedName() + '/' + testcaseName : "${output.folder}/" + traceTestcase.getTemplate().getFullQualifiedName() + '/' + testcaseName;
        test.setOption("run.testcase.test.output.folder", outputFolder);
        Testcase resultTestcase = new Testcase(testcaseName, (E2ETest)test, this);
        E2ETestResult result = new E2ETestResult();
        TestcaseCompare compareFunction = new TestcaseCompare();
        Utilities.mergeOptions((OptionContainer)this.getInheritedOptions(compareFunction.getType(), true), (OptionContainer)compareFunction);
        ((Option)compareFunction.getOptions().get("xml.compare.test.file")).setValueWithoutNotification((Object)new File(outputFolder));
        ((Option)compareFunction.getOptions().get("xml.compare.reference.file")).setValueWithoutNotification((Object)referenceFolder);
        compareFunction.setName("Compare run of " + testcaseName);
        compareFunction.setOwner((Testable)resultTestcase);
        ArrayList<TestcaseCompare> compares = new ArrayList<TestcaseCompare>();
        compares.add(compareFunction);
        result.setResultCompares(compares, (Testable)resultTestcase);
        test.setResult(result);
        test.prepareCompareType((ResultCompare)compareFunction);
        test.setOption("run.testcase.test.testcase", testcaseName);
        URL url = new URL(traceTestcase.getLocation());
        test.setOption("run.testcase.test.host", url.getPort() == -1 ? url.getHost() : url.getHost() + ':' + url.getPort());
        return resultTestcase;
    }

    private void doLoadError(Throwable e) {
        String name = "Could not load testcases. ";
        TestcaseLoadErrorTest test = new TestcaseLoadErrorTest(name);
        EventController.fire((EventObject)new TestErrorEvent((Object)this, (Test)test, e));
        e.printStackTrace();
    }

    private Document remove(Testable test) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document testSuiteDocument = this.getTestSuiteDocument();
        Element testElement = this.findTestElement(test, testSuiteDocument);
        if (testElement != null) {
            Node parent = testElement.getParentNode();
            parent.removeChild(testElement);
            this.removeInternal(test);
        }
        return testSuiteDocument;
    }

    public Object getChild(int index) {
        int increment;
        int n = increment = this.isLogfileSet() ? 1 : 0;
        Object result = this.isLogfileSet() && index == 0 ? this.getLogfile() : (index == increment ? this.getProperties() : ((index -= increment + 1) == 0 ? this.testSuiteOptions : this.getTestcases().get(--index)));
        return result;
    }

    public int getChildCount() {
        return this.getTestcases().size() + (this.isLogfileSet() ? 1 : 0) + 2;
    }

    public int getIndexOfChild(Object child) {
        int result;
        if (this.isLogfileSet() && child.equals(this.getLogfile())) {
            result = 0;
        } else {
            int increment;
            int n = increment = this.isLogfileSet() ? 1 : 0;
            result = child instanceof TestProperties ? increment : (child instanceof TestSuiteOptions ? increment + 1 : this.getTestcases().indexOf(child) + (increment += 2));
        }
        return result;
    }

    public int getIndexOfTest(Testable child) {
        return this.getTestcases().indexOf(child);
    }

    public boolean isLeaf() {
        return this.testSuiteOptions.size() == 0 && this.getTestcases().size() == 0 && !this.isLogfileSet();
    }

    public int getType() {
        return this.type == null ? this.createType() : this.type;
    }

    private Integer createType() {
        this.type = this.isLibrary() ? 5 : (this.isInLibrary() && !LibrariesRoot.isInLibraryTree(this) ? 2 : 1);
        return this.type;
    }

    private void copyOptions(Testcase oldTestcase, Testcase newTestcase) {
        E2ETest oldTest = oldTestcase.getTest();
        E2ETest newTest = newTestcase.getTest();
        newTest.setOptions(oldTest.getOptions());
        newTest.setAdvancedOptions(oldTest.getAdvancedOptions());
        for (ResultCompare compare : newTest.getResult().getResultCompares()) {
            for (ResultCompare oldCompare : oldTest.getResult().getResultCompares()) {
                if (!compare.getClass().equals(oldCompare.getClass())) continue;
                compare.setOptions(oldCompare.getOptions());
                compare.setAdvancedOptions(oldCompare.getAdvancedOptions());
            }
        }
    }

    private void readErrorList() throws ParserConfigurationException, SAXException, IOException {
        Document errorsDocument = this.getErrorsDocument();
        NodeList testcases = errorsDocument.getElementsByTagName("Testcase");
        int length = testcases.getLength();
        for (int i = 0; i < length; ++i) {
            Element testcaseElement = (Element)testcases.item(i);
            String testcaseName = testcaseElement.getAttribute("name");
            Testcase testcase = this.findTestcase(testcaseName);
            if (testcase == null) {
                this.removeFromErrorList(testcaseName);
                continue;
            }
            testcase.setRun(true);
            NodeList errors = testcaseElement.getElementsByTagName("Error");
            int errorsLength = errors.getLength();
            for (int j = 0; j < errorsLength; ++j) {
                Element errorElement = (Element)errors.item(j);
                testcase.getTest().addError(new ErrorElement(errorElement));
            }
        }
    }

    private void removeFromErrorList(String testcaseName) {
        try {
            Document errorsDocument = this.getErrorsDocument();
            Element testcaseElement = (Element)DomUtilities.selectNode((Node)errorsDocument.getDocumentElement(), (String)("/Errorlist/Testcase[@name='" + StringTools.escapeXpath((String)testcaseName) + "']"));
            if (testcaseElement != null) {
                testcaseElement.getParentNode().removeChild(testcaseElement);
                File errorsFile = this.getErrorsFile();
                errorsFile.getParentFile().mkdirs();
                DomUtilities.serialize((File)errorsFile, (Document)errorsDocument, (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeErrors() {
        File errors = this.getErrorsFile();
        if (errors.exists()) {
            errors.delete();
        }
        Document errorsDocument = DomUtilities.newDocument((String)"Errorlist");
        for (Testable testable : this.getTestcases()) {
            if (!(testable instanceof Testcase)) continue;
            errorsDocument.getDocumentElement().appendChild(((Testcase)testable).getErrorsElement(errorsDocument));
        }
        try {
            File errorsFile = this.getErrorsFile();
            errorsFile.getParentFile().mkdirs();
            DomUtilities.serialize((File)errors, (Document)errorsDocument, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document getErrorsDocument() throws IOException, SAXException, ParserConfigurationException {
        File errorsFile = this.getErrorsFile();
        Document errorsDocument = errorsFile != null && errorsFile.exists() ? DomUtilities.parse((File)errorsFile, (boolean)false, (boolean)false, (boolean)false) : DomUtilities.newDocument((String)"Errorlist");
        return errorsDocument;
    }

    public boolean rename(String newName) {
        File newTestSuiteFolder;
        File oldTestSuiteFile = this.getTestSuiteFile();
        File testSuiteFolder = oldTestSuiteFile.getParentFile();
        boolean result = testSuiteFolder.renameTo(newTestSuiteFolder = new File(testSuiteFolder.getParentFile(), this.createTestSuiteId(newName)));
        if (result) {
            File oldReferenceFolder = new File(StringTools.replaceProperty((String)this.getProperties().get("reference.folder"), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            File oldSourceFolder = new File(StringTools.replaceProperty((String)this.getProperties().get("source.folder"), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            File oldOutputFolder = new File(StringTools.replaceProperty((String)this.getProperties().get(this.getOutputFolderKey()), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            this.setName(newName);
            this.path = null;
            File newTestSuiteFile = new File(newTestSuiteFolder, this.getTestSuiteFile().getName());
            this.setTestSuiteFile(newTestSuiteFile);
            try {
                Document testSuiteDocument = this.getTestSuiteDocument();
                testSuiteDocument.getDocumentElement().setAttribute("name", newName);
                DomUtilities.serialize((File)this.getTestSuiteFile(), (Document)testSuiteDocument, (boolean)true);
                if (this.getParent() != null) {
                    ((TreeTestSuite)this.getParent()).replaceIncludeEntry(newTestSuiteFile, oldTestSuiteFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File referenceFolder = new File(StringTools.replaceProperty((String)this.getProperties().get("reference.folder"), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            oldReferenceFolder.renameTo(referenceFolder);
            File sourceFolder = new File(StringTools.replaceProperty((String)this.getProperties().get("source.folder"), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            oldSourceFolder.renameTo(sourceFolder);
            File outputFolder = new File(StringTools.replaceProperty((String)this.getProperties().get(this.getOutputFolderKey()), (String)"project.folder", (String)E2EBuilderProject.getProjectFolderName()));
            oldOutputFolder.renameTo(outputFolder);
            try {
                this.reload();
                this.propagateRenaming();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void propagateRenaming() throws XPathExpressionException, IOException, SAXException, ParserConfigurationException, TransformerException {
        for (Testable testable : this.getTestcases()) {
            if (!(testable instanceof TreeTestSuite)) continue;
            TreeTestSuite testSuite = (TreeTestSuite)testable;
            DomUtilities.serialize((File)testSuite.getTestSuiteFile(), (Document)testSuite.getTestSuiteDocument(), (boolean)true);
            testSuite.propagateRenaming();
        }
    }

    protected String getOutputFolderKey() {
        String result = LibrariesRoot.isInLibraryTree(this) ? "library.output.folder" : "output.folder";
        return result;
    }

    public void persist() throws TransformerException, IOException, XPathExpressionException {
        Document document = this.createTestSuiteDocument(this.getName());
        for (String key : this.getProperties().keySet()) {
            Element property = document.createElement("property");
            property.setAttribute("name", key);
            property.setAttribute("value", this.getProperties().get(key));
        }
        for (TestType testType : this.testSuiteOptions.getKeys()) {
            document.getDocumentElement().appendChild(this.testSuiteOptions.get(testType).optionsToXml(true, document));
        }
        for (Testable testable : this.getTestcases()) {
            if (testable instanceof Testcase) {
                document.getDocumentElement().appendChild(((Testcase)testable).toXml(document));
                continue;
            }
            document.getDocumentElement().appendChild(this.createIncludeElement(FileUtilities.getRelativePath((File)((TreeTestSuite)testable).getTestSuiteFile(), (File)this.getTestSuiteFile().getParentFile()), document));
        }
        DomUtilities.serialize((File)this.getTestSuiteFile(), (Document)document, (boolean)true);
    }

    private Element createIncludeElement(String includeName, Document testSuiteDocument) {
        Element includeElement = testSuiteDocument.createElement("include");
        includeElement.setAttribute("file", includeName);
        return includeElement;
    }

    private Map<String, String> createFolderProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        if (LibrariesRoot.isInLibraryTree(this)) {
            this.createLibraryOutputProperty(props);
        } else {
            this.createFolderProperty("output.folder", "regressiontest/.$output", projectHome, props);
        }
        this.createFolderProperty("reference.folder", "regressiontest/reference", projectHome, props);
        this.createFolderProperty("source.folder", "regressiontest/source", projectHome, props);
        return props;
    }

    private void createLibraryOutputProperty(Map<String, String> props) {
        String path = this.createLibraryOutputPath();
        props.put("library.output.folder", path);
    }

    private void createFolderProperty(String name, String dataFolder, File projectHome, Map<String, String> props) {
        File root = new File(projectHome, dataFolder);
        File folder = new File(root, this.getPath());
        props.put(name, folder.getAbsolutePath());
    }

    private void checkFolderProperties(Document document) throws XPathExpressionException {
        File projectHome = new File(E2EBuilderProject.getProjectFolderName());
        if (LibrariesRoot.isInLibraryTree(this)) {
            this.setLibraryOutputProperty(document);
        } else {
            this.checkFolderProperty("output.folder", "regressiontest/.$output", projectHome, document);
        }
        this.checkFolderProperty("reference.folder", "regressiontest/reference", projectHome, document);
        this.checkFolderProperty("source.folder", "regressiontest/source", projectHome, document);
    }

    private void setLibraryOutputProperty(Document document) throws XPathExpressionException {
        Element property = this.findProperty("library.output.folder", document);
        String path = this.createLibraryOutputPath();
        property.setAttribute("value", path);
        this.getProperties().put("library.output.folder", path);
    }

    protected String createLibraryOutputPath() {
        String path = this.getPath();
        if (path.contains("libraries/")) {
            path = path.substring("libraries/".length());
        }
        path = path.replace(File.separatorChar, '/');
        path = "${output.folder}/" + path;
        return path;
    }

    private void checkFolderProperty(String name, String dataFolder, File projectHome, Document document) throws XPathExpressionException {
        File root = new File(projectHome, dataFolder);
        File folder = new File(root, this.getPath());
        Element property = this.findProperty(name, document);
        property.setAttribute("value", "${project.folder}/" + FileUtilities.getRelativePath((File)folder, (File)projectHome));
        this.getProperties().put(name, folder.getAbsolutePath());
    }

    private Element findProperty(String name, Document document) throws XPathExpressionException {
        Element projectFolder;
        Element property = (Element)DomUtilities.selectNode((Node)document.getDocumentElement(), (String)("/" + document.getDocumentElement().getNodeName() + "/property[@name='" + name + "']"));
        if (property == null) {
            property = document.createElement("property");
            property.setAttribute("name", name);
        }
        if ((projectFolder = (Element)DomUtilities.selectNode((Node)document.getDocumentElement(), (String)("/" + document.getDocumentElement().getNodeName() + "/property[@name='" + "project.folder" + "']"))) == null) {
            document.getDocumentElement().insertBefore(property, document.getDocumentElement().getFirstChild());
        } else {
            document.getDocumentElement().insertBefore(property, projectFolder.getNextSibling());
        }
        return property;
    }

    @Override
    public void libraryChanged(LibraryChangedEvent event) {
        TreeTestSuite testSuite = this.findTestSuite(event.getTestPath());
        if (testSuite != null) {
            if (testSuite.getTestSuiteFile().exists()) {
                this.reloadTestSuite(testSuite);
                EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)testSuite));
            } else {
                this.deleteTestSuite(testSuite);
                EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this));
            }
        }
    }

    @Override
    public void nameChanged(LibraryChangedEvent event) {
        File parentDir = this.getTestSuiteFile().getParentFile();
        if (event.getOldId() == null) {
            File oldTestSuiteDir = new File(parentDir, event.getTestPath());
            String newTestSuiteDirName = ((TreeTestSuite)event.getSource()).getTestSuiteFile().getParentFile().getName();
            File newTestSuiteDir = new File(oldTestSuiteDir.getParentFile(), newTestSuiteDirName);
            if (!oldTestSuiteDir.renameTo(newTestSuiteDir)) {
                System.err.println("Renaming '" + oldTestSuiteDir + "' to '" + newTestSuiteDir + "' failed.");
            }
            TreeTestSuite testSuite = this.findTestSuite(event.getTestPath());
            testSuite.idChanged(oldTestSuiteDir.getName());
            try {
                testSuite.reload();
                EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)testSuite));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String newTestSuiteDirName;
            File newTestSuiteDir;
            File oldTestSuiteDir = new File(parentDir, event.getOldId());
            if (!oldTestSuiteDir.renameTo(newTestSuiteDir = new File(parentDir, newTestSuiteDirName = event.getLibrary().getTestSuiteFile().getParentFile().getName()))) {
                System.err.println("Renaming '" + oldTestSuiteDir + "' to '" + newTestSuiteDir + "' failed.");
            }
            TreeTestSuite testSuite = this.findTestSuite(event.getOldId());
            File libraryFile = testSuite.getTestSuiteFile();
            File libraryDir = libraryFile.getParentFile();
            File oldLibraryDir = new File(libraryDir.getParentFile(), event.getOldId());
            File oldLibraryFile = new File(oldLibraryDir, libraryFile.getName());
            try {
                this.replaceIncludeEntry(libraryFile, oldLibraryFile);
                testSuite.setName(event.getLibrary().getName());
                testSuite.idChanged(event.getOldId());
                testSuite.reload();
                EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void testRemoved(LibraryChangedEvent event) {
        Testcase testcase;
        TreeTestSuite testSuite;
        String testPath = event.getTestPath();
        int idx = testPath.lastIndexOf(47);
        TreeTestSuite treeTestSuite = testSuite = idx == -1 ? this : this.findTestSuite(testPath.substring(0, idx));
        if (testSuite != null && (testcase = testSuite.findTestcase(testPath.substring(idx + 1))) != null) {
            testcase.getTest().removeOutput();
            this.reloadTestSuite(testSuite);
        }
    }

    protected void replaceIncludeEntry(File newTestSuite, File oldTestSuite) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException, TransformerException {
        Document testSuiteDocument = this.getTestSuiteDocument();
        Element includeEntry = this.findIncludeEntry(oldTestSuite, testSuiteDocument);
        Element includeElement = this.createIncludeElement(FileUtilities.getRelativePath((File)newTestSuite, (File)this.getTestSuiteFile().getParentFile()), testSuiteDocument);
        if (includeEntry == null) {
            testSuiteDocument.getDocumentElement().appendChild(includeElement);
        } else {
            testSuiteDocument.getDocumentElement().replaceChild(includeElement, includeEntry);
        }
        DomUtilities.serialize((File)this.getTestSuiteFile(), (Document)testSuiteDocument, (boolean)true);
    }

    private String createTestSuiteId(String name) {
        HashMap<String, String> existingTestSuites = new HashMap<String, String>();
        for (Testable testable : this.getTestcases()) {
            if (!(testable instanceof TreeTestSuite)) continue;
            existingTestSuites.put(testable.getName(), ((TreeTestSuite)testable).getTestSuiteFile().getParentFile().getName());
        }
        String prefix = TraceTools.createPrefix((String)name);
        return UniqueIdService.createUniqueId((String)name, (String)prefix, existingTestSuites);
    }

    private void reloadTestSuite(TreeTestSuite testSuite) {
        try {
            testSuite.reload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkOutputFolder() {
        String outputFolder = this.getProperties().get("output.folder");
        if (outputFolder != null && !outputFolder.contains("regressiontest/.$output")) {
            try {
                Document testSuiteDocument = this.getTestSuiteDocument();
                this.serializeTestSuiteDocument(testSuiteDocument, this.getTestSuiteFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

