/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractTestcaseFolder;
import ch.e2e.builder.trace.testcase.SynchronousTestcaseTemplate;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.tree.TreePath;

public class OperationFolder
extends AbstractTestcaseFolder
implements TestImportTreeNode,
ImportTestcaseContainer {
    public static final int OPERATION_SELECTABLE = 4000;
    public static final int OPERATION_NOT_SELECTABLE = 4001;
    private boolean testSuiteSelectionMode;
    private int nameConflictOffset;
    private Collection<TestcaseObject> testcases;

    public OperationFolder(SynchronousTestcaseTemplate template, File home) {
        super(template, home);
    }

    public AbstractSynchronousTestcase createNewTestcase(String testcaseName) {
        TraceTestcase testcase = new TraceTestcase(testcaseName, this.getTemplate(), this.getHome());
        this.getChildCollection().add((TestcaseObject)testcase);
        return testcase;
    }

    @Override
    public Collection<TestcaseObject> getChildCollection() {
        if (this.testcases == null) {
            this.testcases = new ArrayList<TestcaseObject>();
        }
        return this.testcases;
    }

    public int getType() {
        return this.isSelectable() ? 4000 + this.nameConflictOffset : 4001;
    }

    @Override
    public boolean isSelectable() {
        return this.testSuiteSelectionMode && this.hasExecutedTestcases();
    }

    @Override
    public void setTestSuitSelectionMode(boolean testSuiteSelectionMode) {
        this.testSuiteSelectionMode = testSuiteSelectionMode;
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            if (!(testcaseObject instanceof TestImportTreeNode)) continue;
            ((TestImportTreeNode)testcaseObject).setTestSuitSelectionMode(testSuiteSelectionMode);
        }
    }

    public ArrayList<TreePath> getSelectablePaths() {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (this.testSuiteSelectionMode) {
            if (this.hasExecutedTestcases()) {
                TreePath path = new TreePath(this);
                result.add(path);
            }
        } else {
            ArrayList<TreePath> selectablePaths = new ArrayList<TreePath>();
            for (TestcaseObject testcaseObject : this.getChildren().values()) {
                selectablePaths.addAll(((TestImportTreeNode)testcaseObject).getSelectablePaths());
            }
            for (TreePath path : selectablePaths) {
                Object[] pathElements = new Object[path.getPath().length + 1];
                pathElements[0] = this;
                System.arraycopy(path.getPath(), 0, pathElements, 1, path.getPath().length);
                result.add(new TreePath(pathElements));
            }
        }
        return result;
    }

    @Override
    public void setExistingNames(Collection<String> existingNames) {
        this.nameConflictOffset = this.isSelectable() && existingNames.contains(this.getName()) ? 150 : 0;
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingNames(existingNames);
        }
    }

    @Override
    public void setExistingPaths(Collection<String> existingPaths, String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).setExistingPaths(existingPaths, rootPath);
        }
    }

    @Override
    public boolean hasNameConflict() {
        return this.nameConflictOffset != 0;
    }

    @Override
    public void checkNames(String rootPath) {
        rootPath = rootPath + this.getName() + '/';
        for (TestcaseObject testcaseObject : this.getChildren().values()) {
            ((TestImportTreeNode)testcaseObject).checkNames(rootPath);
        }
    }

    @Override
    public Collection<TraceTestcase> findNameConflicts() {
        ArrayList<TraceTestcase> result = new ArrayList<TraceTestcase>();
        for (TestcaseObject testcase : this.getChildren().values()) {
            result.addAll(((TestImportTreeNode)testcase).findNameConflicts());
        }
        return result;
    }
}

