/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.model;

import ch.e2e.builder.base.application.E2EBuilderTransaction;
import ch.e2e.builder.base.application.abstracts.DoTransactionEvent;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.CreateTestSuiteEvent;
import ch.e2e.builder.regtest.event.CreateTestcaseEvent;
import ch.e2e.builder.regtest.event.DeleteTestcaseEvent;
import ch.e2e.builder.regtest.event.EditTestPreferencesEvent;
import ch.e2e.builder.regtest.event.ImportLibraryEvent;
import ch.e2e.builder.regtest.event.ImportTestSuiteEvent;
import ch.e2e.builder.regtest.event.ImportTestcaseEvent;
import ch.e2e.builder.regtest.event.RenameTestcaseEvent;
import ch.e2e.builder.regtest.event.TestSuiteTreeChangedEvent;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TestcaseRunTransaction;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import ch.e2e.test.Testable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TestPopupMenu
extends JPopupMenu {
    private Testcase test;
    private JMenuItem addLogfileItem;
    private JMenuItem removeLogfileItem;
    private E2EBuilderModule module;
    private JMenuItem runItem;
    private JMenuItem importLibraryItem;
    private JMenuItem renameItem;
    private JMenuItem removeItem;
    private JMenuItem createTestSuiteItem;
    private JMenuItem importTestSuiteItem;
    private JMenuItem importTestcaseItem;
    private JMenuItem createTestcaseItem;
    private JMenuItem preferencesItem;

    public TestPopupMenu(E2EBuilderModule module) {
        this.module = module;
        this.addItems(module);
    }

    public void setTest(Testcase test) {
        this.test = test;
        boolean canWrite = test.getParent().canWrite();
        boolean notInLibraryTree = !LibrariesRoot.isInLibraryTree(test);
        this.runItem.setEnabled(notInLibraryTree);
        this.importLibraryItem.setEnabled(canWrite && notInLibraryTree);
        boolean logFileSet = test.isLogfileSet();
        this.addLogfileItem.setEnabled(canWrite && !logFileSet);
        this.removeLogfileItem.setEnabled(canWrite && logFileSet);
        this.renameItem.setEnabled(canWrite);
        this.removeItem.setEnabled(canWrite);
        this.createTestSuiteItem.setEnabled(canWrite);
        this.importTestSuiteItem.setEnabled(canWrite);
        this.importTestcaseItem.setEnabled(canWrite);
        this.createTestcaseItem.setEnabled(canWrite);
        this.preferencesItem.setEnabled(canWrite);
    }

    private void addItems(E2EBuilderModule module) {
        this.runItem = ComponentFactory.createMenuItem((String)"popup.menu.item.test.run", (E2EBuilderModule)module);
        this.runItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/run.testcase.icon.gif", (boolean)true));
        this.runItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.runTest();
            }
        });
        this.add(this.runItem);
        this.addSeparator();
        this.renameItem = ComponentFactory.createMenuItem((String)"popup.menu.item.rename.testcase", (E2EBuilderModule)module);
        this.renameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.renameTest();
            }
        });
        this.add(this.renameItem);
        this.removeItem = ComponentFactory.createMenuItem((String)"popup.menu.item.remove.testcase", (E2EBuilderModule)module);
        this.removeItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/remove.testcase.icon.gif", (boolean)true));
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.removeTest();
            }
        });
        this.add(this.removeItem);
        this.addSeparator();
        this.addLogfileItem = ComponentFactory.createMenuItem((String)"popup.menu.item.add.logfile", (E2EBuilderModule)module);
        this.addLogfileItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/logfile.add.icon.gif", (boolean)true));
        this.addLogfileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.addLogfile();
            }
        });
        this.add(this.addLogfileItem);
        this.removeLogfileItem = ComponentFactory.createMenuItem((String)"popup.menu.item.remove.logfile", (E2EBuilderModule)module);
        this.removeLogfileItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/logfile.remove.icon.gif", (boolean)true));
        this.removeLogfileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.removeLogfile();
            }
        });
        this.add(this.removeLogfileItem);
        this.addSeparator();
        this.importTestSuiteItem = ComponentFactory.createMenuItem((String)"popup.menu.item.import.testsuite", (E2EBuilderModule)module);
        this.importTestSuiteItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/import.testsuite.icon.gif", (boolean)true));
        this.importTestSuiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.importTestSuite();
            }
        });
        this.add(this.importTestSuiteItem);
        this.createTestSuiteItem = ComponentFactory.createMenuItem((String)"popup.menu.item.create.testsuite", (E2EBuilderModule)module);
        this.createTestSuiteItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/create.testsuite.icon.gif", (boolean)true));
        this.createTestSuiteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.createTestSuite();
            }
        });
        this.add(this.createTestSuiteItem);
        this.addSeparator();
        this.importTestcaseItem = ComponentFactory.createMenuItem((String)"popup.menu.item.import.testcases", (E2EBuilderModule)module);
        this.importTestcaseItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/import.testcase.icon.gif", (boolean)true));
        this.importTestcaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.importTestcase();
            }
        });
        this.add(this.importTestcaseItem);
        this.addSeparator();
        this.createTestcaseItem = ComponentFactory.createMenuItem((String)"popup.menu.item.create.testcase", (E2EBuilderModule)module);
        this.createTestcaseItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/create.testcase.icon.gif", (boolean)true));
        this.createTestcaseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.createTestcase();
            }
        });
        this.add(this.createTestcaseItem);
        this.addSeparator();
        this.importLibraryItem = ComponentFactory.createMenuItem((String)"popup.menu.item.library.import", (E2EBuilderModule)module);
        this.importLibraryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.importLibrary();
            }
        });
        this.add(this.importLibraryItem);
        this.addSeparator();
        this.preferencesItem = ComponentFactory.createMenuItem((String)"popup.menu.item.preferences", (E2EBuilderModule)module);
        this.preferencesItem.setIcon(ImageLoader.loadIcon((String)"ch/e2e/builder/regtest/images/testcasePreferences.icon.gif", (boolean)true));
        this.preferencesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestPopupMenu.this.editPreferences();
            }
        });
        this.add(this.preferencesItem);
    }

    private void renameTest() {
        EventController.fire((EventObject)new RenameTestcaseEvent(this, this.test));
    }

    private void editPreferences() {
        EventController.fire((EventObject)new EditTestPreferencesEvent(this, this.test));
    }

    private void runTest() {
        EventController.fire((EventObject)new DoTransactionEvent((Object)this, (E2EBuilderTransaction)new TestcaseRunTransaction(), (Object)this.test));
    }

    private void addLogfile() {
        this.test.addLogfile();
        EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this.test));
    }

    private void removeTest() {
        EventController.fire((EventObject)new DeleteTestcaseEvent(this, this.test));
    }

    private void removeLogfile() {
        this.test.removeLogfile();
        EventController.fire((EventObject)new TestSuiteTreeChangedEvent(this, (Testable)this.test));
    }

    private void importTestcase() {
        TreeTestSuite parent = (TreeTestSuite)this.test.getParent();
        int index = parent.getTestcases().indexOf(this.test);
        EventController.fire((EventObject)new ImportTestcaseEvent(this, parent, index + 1));
    }

    private void createTestcase() {
        TreeTestSuite parent = (TreeTestSuite)this.test.getParent();
        int index = parent.getTestcases().indexOf(this.test);
        EventController.fire((EventObject)new CreateTestcaseEvent(this, parent, index + 1));
    }

    private void importTestSuite() {
        TreeTestSuite parent = (TreeTestSuite)this.test.getParent();
        int index = parent.getTestcases().indexOf(this.test);
        EventController.fire((EventObject)new ImportTestSuiteEvent(this, parent, index + 1));
    }

    private void createTestSuite() {
        TreeTestSuite parent = (TreeTestSuite)this.test.getParent();
        int index = parent.getTestcases().indexOf(this.test);
        EventController.fire((EventObject)new CreateTestSuiteEvent(this, parent, index + 1));
    }

    private void importLibrary() {
        TreeTestSuite parent = (TreeTestSuite)this.test.getParent();
        int index = parent.getTestcases().indexOf(this.test);
        EventController.fire((EventObject)new ImportLibraryEvent(this, parent, index));
    }
}

