/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.builder.regtest.gui.swing.FileOptionPane;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.swing.model.SortedComboBoxModel;
import ch.e2e.test.TestDocumentPreprocessor;
import ch.e2e.test.options.PreprocessorOption;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class PreprocessorOptionPane
extends AbstractOptionPanel<TestDocumentPreprocessor, PreprocessorOption> {
    private JCheckBox enabledCheckBox;
    private JCheckBox indentCheckBox;
    private FileOptionPane scriptFilePane;
    private ScriptNameComponent scriptNamePane;
    private PreprocessorOption option;

    public PreprocessorOptionPane() {
        super(new BorderLayout());
        this.createGui();
    }

    @Override
    public TestDocumentPreprocessor getValue() {
        TestDocumentPreprocessor preprocessor = new TestDocumentPreprocessor(this.scriptNamePane.getSelectedScript(), this.indentCheckBox.isSelected());
        preprocessor.setEnabled(this.enabledCheckBox.isSelected());
        if (!this.scriptFilePane.isEmpty()) {
            preprocessor.setScriptFile(this.scriptFilePane.getValue());
        }
        return preprocessor;
    }

    @Override
    public void setValue(TestDocumentPreprocessor value) {
        if (value == null) {
            this.enabledCheckBox.setSelected(false);
            this.indentCheckBox.setSelected(true);
            this.scriptNamePane.setSelectedScript(null);
            this.scriptFilePane.setValue(null);
        } else {
            this.enabledCheckBox.setSelected(value.isEnabled());
            this.indentCheckBox.setSelected(value.isIndent());
            this.scriptNamePane.setSelectedScript(value.getScriptName());
            this.scriptFilePane.setValue(value.getScriptFile());
        }
    }

    @Override
    public PreprocessorOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(PreprocessorOption option) {
        this.option = option;
        this.scriptFilePane.setOption(option.getScriptFile());
    }

    @Override
    public boolean isEmpty() {
        return !this.enabledCheckBox.isSelected() && this.scriptFilePane.isEmpty() && this.scriptNamePane.getSelectedScript().equals("DefaultSortScript");
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.enabledCheckBox.setEnabled(!readOnly);
        this.indentCheckBox.setEnabled(!readOnly);
        this.scriptNamePane.scriptNameComboBox.setEnabled(!readOnly);
        this.scriptFilePane.setReadOnly(readOnly);
    }

    @Override
    public void setChanged(boolean changed) {
        super.setChanged(changed);
        this.scriptFilePane.setChanged(changed);
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(3, 0, 2, 0);
        this.enabledCheckBox = new JCheckBox("Enable Preprocessor");
        this.add((Component)this.enabledCheckBox, c);
        this.enabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessorOptionPane.this.inputChanged();
            }
        });
        JLabel scriptNameLabel = new JLabel("Predefined Script");
        this.add((Component)scriptNameLabel, c);
        this.scriptNamePane = new ScriptNameComponent();
        this.add((Component)this.scriptNamePane.getComponent(), c);
        c.insets = new Insets(8, 0, 2, 0);
        this.scriptFilePane = new FileOptionPane();
        this.add((Component)this.scriptFilePane, c);
        this.scriptFilePane.addOptionChangedListener(new OptionInputChangedListener(){

            @Override
            public void optionChanged(OptionInputChangedEvent event) {
                PreprocessorOptionPane.this.inputChanged();
            }
        });
        c.insets = new Insets(3, 0, 2, 0);
        c.weighty = 1.0;
        this.indentCheckBox = new JCheckBox("Indent XML");
        this.add((Component)this.indentCheckBox, c);
        this.indentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreprocessorOptionPane.this.inputChanged();
            }
        });
    }

    private void inputChanged() {
        this.fireOptionInputChanged();
        this.setChanged(true);
    }

    private class ScriptNameComponent {
        private SortedComboBoxModel<String> scriptNameModel;
        private JComboBox scriptNameComboBox;

        private ScriptNameComponent() {
            this.scriptNameModel = new SortedComboBoxModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            this.scriptNameModel.addAll((Collection)TestDocumentPreprocessor.EXISTING_SCRIPTS);
            this.scriptNameModel.setSelectedItem((Object)"DefaultSortScript");
            this.scriptNameComboBox = new JComboBox<String>((ComboBoxModel<String>)this.scriptNameModel);
        }

        public JComboBox getComponent() {
            return this.scriptNameComboBox;
        }

        public String getSelectedScript() {
            return (String)this.scriptNameModel.getSelectedItem();
        }

        public void setSelectedScript(String script) {
            if (script == null) {
                this.scriptNameModel.setSelectedItem((Object)"DefaultSortScript");
            } else {
                this.scriptNameModel.setSelectedItem((Object)script);
            }
        }
    }
}

