/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.test.options.KeyValueListOption;
import ch.e2e.test.options.StringOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class KeyValueListOptionPane
extends AbstractOptionPanel<SortedMap<String, StringOption>, KeyValueListOption> {
    private JLabel name;
    private KeyValueListOption option;
    private JButton removeButton;
    private JTable table;
    private JButton addButton;
    private KVTableModel optionModel = new KVTableModel();

    public KeyValueListOptionPane() {
        this.createGui();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public SortedMap<String, StringOption> getValue() {
        return (SortedMap)this.option.getValue();
    }

    @Override
    public void setValue(SortedMap<String, StringOption> value) {
    }

    @Override
    public KeyValueListOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(KeyValueListOption option) {
        this.option = option;
        this.table.clearSelection();
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.name.setText(option.getName());
        this.optionModel.setSource((SortedMap)option.getValue());
        this.table.revalidate();
    }

    @Override
    public void persist(boolean forced) {
        TreeMap<String, StringOption> newValue = new TreeMap<String, StringOption>();
        newValue.putAll(this.optionModel.getSource());
        this.option.setValue(newValue);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.table.setEnabled(!readOnly);
        this.addButton.setEnabled(!readOnly);
        if (readOnly) {
            this.removeButton.setEnabled(false);
        }
    }

    @Override
    public int getWeightY() {
        return 1;
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.name = new JLabel();
        this.add((Component)this.name, c);
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        this.addButton = new JButton("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyValueListOptionPane.this.addEntry();
                KeyValueListOptionPane.this.setChanged(true);
            }
        });
        this.add((Component)this.addButton, c);
        this.removeButton = new JButton("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyValueListOptionPane.this.removeEntry();
                KeyValueListOptionPane.this.setChanged(true);
            }
        });
        c.gridwidth = 0;
        this.add((Component)this.removeButton, c);
        c.weightx = 1.0;
        this.table = new JTable(this.optionModel);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(0);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                KeyValueListOptionPane.this.removeButton.setEnabled(KeyValueListOptionPane.this.optionModel.getValueAt(KeyValueListOptionPane.this.table.getSelectedRow(), KeyValueListOptionPane.this.table.getSelectedColumn()) != null);
            }
        });
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(this.table, 20, 30), c);
    }

    private void addEntry() {
        this.optionModel.newEntry();
    }

    private void removeEntry() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        this.optionModel.removeSelectedEntry();
        this.table.clearSelection();
        if (this.table.getRowCount() == 0) {
            this.removeButton.setEnabled(false);
        } else {
            if (row > this.table.getRowCount() - 1) {
                row = this.table.getRowCount() - 1;
            }
            this.table.changeSelection(row, col, false, false);
        }
    }

    private class KVTableModel
    extends AbstractTableModel {
        private SortedMap<String, StringOption> source = new TreeMap<String, StringOption>();

        public void setSource(SortedMap<String, StringOption> source) {
            this.source.clear();
            if (source != null) {
                for (Map.Entry<String, StringOption> entry : source.entrySet()) {
                    this.source.put(entry.getKey(), (StringOption)entry.getValue().createCopy());
                }
            }
        }

        public SortedMap<String, StringOption> getSource() {
            return this.source;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.source.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Key";
            }
            return "Value";
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.getKey(rowIndex);
            }
            String key = this.getKey(rowIndex);
            StringOption value = (StringOption)this.source.get(key);
            if (value != null) {
                return value.getValue();
            }
            return null;
        }

        private String getKey(int a_index) {
            String retval = "";
            Set<String> e = this.source.keySet();
            Iterator<String> it = e.iterator();
            while (a_index-- >= 0 && it.hasNext()) {
                retval = it.next();
            }
            return retval;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String oldKey = this.getKey(rowIndex);
                StringOption value = (StringOption)this.source.remove(oldKey);
                this.source.put((String)aValue, value);
            } else {
                String oldKey = this.getKey(rowIndex);
                StringOption value = (StringOption)this.source.get(oldKey);
                value.setValue((Object)((String)aValue));
            }
            KeyValueListOptionPane.this.setChanged(true);
        }

        public void newEntry() {
            StringOption value = new StringOption("<NEW_KEY>", 0);
            value.setValue((Object)"<NEW_VALUE>");
            this.source.put("<NEW_KEY>", value);
            KeyValueListOptionPane.this.table.revalidate();
            KeyValueListOptionPane.this.setChanged(true);
        }

        public void removeSelectedEntry() {
            String key = this.getKey(KeyValueListOptionPane.this.table.getSelectedRow());
            this.source.remove(key);
            KeyValueListOptionPane.this.table.revalidate();
        }
    }
}

