/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.AbstractOptionPanel;
import ch.e2e.test.options.BooleanOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class BooleanOptionPane
extends AbstractOptionPanel<Boolean, BooleanOption> {
    private JRadioButton trueButton;
    private BooleanOption option;
    private JRadioButton falseButton;

    public BooleanOptionPane() {
        this.createGui();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Boolean getValue() {
        return this.trueButton.isSelected();
    }

    @Override
    public void setValue(Boolean value) {
        if (value == null) {
            this.trueButton.setSelected(false);
            this.falseButton.setSelected(false);
        } else {
            this.trueButton.setSelected(value);
            this.falseButton.setSelected(value == false);
        }
    }

    @Override
    public BooleanOption getOption() {
        return this.option;
    }

    @Override
    public void setOption(BooleanOption option) {
        this.option = option;
        this.trueButton.setText(option.getTrueName());
        this.falseButton.setText(option.getFalseName());
        boolean trueValue = option.getValue() == null ? ((Boolean)option.getDefaultValue()).booleanValue() : ((Boolean)option.getValue()).booleanValue();
        this.trueButton.setSelected(trueValue);
        this.falseButton.setSelected(!trueValue);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.trueButton.setEnabled(!readOnly);
        this.falseButton.setEnabled(!readOnly);
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 10);
        c.weightx = 0.0;
        c.anchor = 17;
        ButtonGroup bg = new ButtonGroup();
        this.trueButton = new JRadioButton();
        this.trueButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BooleanOptionPane.this.setChanged(true);
            }
        });
        this.falseButton = new JRadioButton();
        this.falseButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BooleanOptionPane.this.setChanged(true);
            }
        });
        bg.add(this.trueButton);
        bg.add(this.falseButton);
        this.add((Component)this.trueButton, c);
        c.weightx = 1.0;
        this.add((Component)this.falseButton, c);
    }
}

