/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui.swing;

import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionPanel;
import ch.e2e.swing.ModalDialog;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.OptionGroup;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class AdvancedOptionsDialog
extends ModalDialog {
    private JComponent contentPane;
    private List<OptionPanel> optionPanels;
    private Icon icon;

    public AdvancedOptionsDialog(Dialog parent, Icon icon) {
        super(parent, translator.getTranslation("advanced.options.title"), translator.getTranslation("advanced.options.internaltitle"), translator.getTranslation("advanced.options.subtitle"), icon, 3);
        this.icon = icon;
        this.createGui();
    }

    public AdvancedOptionsDialog(Frame parent, Icon icon) {
        super(parent, translator.getTranslation("advanced.options.title"), translator.getTranslation("advanced.options.internaltitle"), translator.getTranslation("advanced.options.subtitle"), icon, 3);
        this.createGui();
    }

    public HashMap<String, OptionComponent> setOptions(Collection<Option> advancedOptions, boolean readOnly, boolean setDefaultValue) {
        HashMap<String, OptionComponent> result = new HashMap<String, OptionComponent>();
        this.removeAll();
        this.optionPanels = new ArrayList<OptionPanel>();
        TreeMap<OptionGroup, Collection<Option>> optionGroups = this.createOptionGroups(advancedOptions);
        if (optionGroups.size() == 1) {
            this.contentPane = new OptionPanel((Dialog)((Object)this), this.icon, translator);
            result.putAll(((OptionPanel)this.contentPane).setOptions(advancedOptions, readOnly, setDefaultValue));
            this.optionPanels.add((OptionPanel)this.contentPane);
        } else {
            this.contentPane = new JTabbedPane();
            for (OptionGroup group : optionGroups.keySet()) {
                OptionPanel optionPanel = new OptionPanel((Dialog)((Object)this), this.icon, translator);
                ((JTabbedPane)this.contentPane).addTab(group.getName(), optionPanel);
                result.putAll(optionPanel.setOptions(optionGroups.get(group), readOnly, setDefaultValue));
                this.optionPanels.add(optionPanel);
            }
        }
        this.add(this.contentPane, "Center");
        Object obj = result.get("Ignored Elements");
        if (obj != null) {
            ((OptionComponent)obj).setReadOnly(readOnly);
        }
        return result;
    }

    public boolean editAdvancedOptions() {
        return this.showDialog() == 1;
    }

    public void persist(boolean forced) {
        for (OptionPanel optionPanel : this.optionPanels) {
            optionPanel.persist(forced);
        }
    }

    public int getMinimumWidth() {
        return 300;
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
    }

    private TreeMap<OptionGroup, Collection<Option>> createOptionGroups(Collection<Option> options) {
        TreeMap<OptionGroup, Collection<Option>> result = new TreeMap<OptionGroup, Collection<Option>>();
        for (Option option : options) {
            Collection<Option> groupOptions;
            OptionGroup group = option.getGroup();
            if (group == null) {
                group = new OptionGroup();
            }
            if ((groupOptions = result.get(group)) == null) {
                groupOptions = new ArrayList<Option>();
                result.put(group, groupOptions);
            }
            groupOptions.add(option);
        }
        return result;
    }

    static {
        translator.addMap("ch.e2e.test.translations");
    }
}

