/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.gui.TestSelectionDialog;
import ch.e2e.builder.regtest.gui.TestcaseReplaceSelectionDialog;
import ch.e2e.builder.regtest.model.SelectionTreeModel;
import ch.e2e.builder.regtest.model.TestImportTreeNode;
import ch.e2e.builder.regtest.testsuite.ImportTestcaseContainer;
import ch.e2e.builder.regtest.testsuite.TraceTestcase;
import ch.e2e.builder.regtest.testsuite.TraceTestcaseRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.builder.trace.testcase.TestcaseContainer;
import ch.e2e.resource.MultiMapProperties;
import ch.e2e.resource.Properties;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;

public class TestSuiteSelectionDialog
extends TestSelectionDialog {
    private static TestSuiteSelectionDialog dialog;
    private SelectionTreeModel treeModel;

    private TestSuiteSelectionDialog(E2EBuilderModule module) {
        super(module.getTranslation("testsuite.selection.dialog.title"), module.getTranslation("testsuite.selection.dialog.internaltitle"), module.getTranslation("testsuite.selection.dialog.subtitle"), true, module);
        this.setErrorNoSelection(module.getTranslation("testsuite.selection.error.no.selection"));
    }

    public static TestSuiteSelectionDialog getInstance(E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new TestSuiteSelectionDialog(module);
        }
        return dialog;
    }

    public TestSelectionDialog.TestcaseContainerSelection selectTestSuite(TreeTestSuite parent, boolean showTestSuiteSelection) {
        this.getChoicePanel().setTestSuite(parent, showTestSuiteSelection);
        this.fillProjectBox();
        TestSelectionDialog.TestcaseContainerSelection result = null;
        Object selectedItem = this.getProjectBox().getSelectedItem();
        if (selectedItem instanceof File) {
            this.getTreeView().setProjectHome((File)selectedItem);
            this.setNewTestSuiteSelection();
        }
        this.getTreeView().setMultiSelection(false);
        this.getTreeView().clearSelection();
        this.getTreeView().expandAll();
        this.setNoSelection();
        if (this.showDialog() == 1) {
            result = new TestSelectionDialog.TestcaseContainerSelection(this.getChoicePanel().getSelectedTestSuite(), this.getChoicePanel().getSelectionIndex());
            ImportTestcaseContainer selectedComponent = (ImportTestcaseContainer)this.getTreeView().getSelectedComponent();
            result.setTestcaseContainer(selectedComponent);
            Collection<TraceTestcase> nameConflicts = selectedComponent.findNameConflicts();
            if (nameConflicts.size() > 0) {
                TestcaseReplaceSelectionDialog.NameConflicRoot root = new TestcaseReplaceSelectionDialog.NameConflicRoot((TestcaseContainer)selectedComponent);
                for (TestcaseContainer testcaseContainer : nameConflicts) {
                    root.addNameConflict(testcaseContainer);
                }
                List<TraceTestcase> objectsToOverride = TestcaseReplaceSelectionDialog.getInstance(this.getModule()).selectTestcasesToOverride(root);
                if (objectsToOverride == null) {
                    result = null;
                } else {
                    nameConflicts.removeAll(objectsToOverride);
                    for (TraceTestcase testcase : nameConflicts) {
                        ((ImportTestcaseContainer)testcase.getParent()).getChildCollection().remove(testcase);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        TreePath selectionPath = (TreePath)e.getItem();
        TestImportTreeNode container = (TestImportTreeNode)selectionPath.getLastPathComponent();
        container.checkNames("");
        this.reloadPath(selectionPath);
    }

    @Override
    protected void addSelectButtons() {
    }

    private void reloadPath(TreePath selectionPath) {
        if (selectionPath != null) {
            this.treeModel.fireTreeStructureChanged(selectionPath);
            this.getTreeView().expandAll(selectionPath);
        }
    }

    @Override
    protected void setNewTestSuiteSelection() {
        this.getTreeView().setExistingPaths(this.getChoicePanel().getSelectedTestSuite());
        this.reloadPath(this.getTreeView().getSelectionPath());
    }

    @Override
    protected SelectionTreeModel getSelectionTreeModel(E2EBuilderModule module) {
        TraceTestcaseRoot root = new TraceTestcaseRoot(module.getProjectPool().getProjectHome());
        root.setTestSuitSelectionMode(true);
        MultiMapProperties properties = new MultiMapProperties("ch.e2e.builder.regtest.properties.importTestSuiteSelectionTree", "tree.properties.maps");
        this.treeModel = new SelectionTreeModel(root, (Properties)properties, module);
        return this.treeModel;
    }
}

