/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.models;

import ch.e2e.builder.ActivateSaxon;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.util.ArgumentParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class E2EBridgeModelGenerator {
    public static void main(String[] args) throws Exception {
        Serializer out;
        Xslt30Transformer xslt30transformer;
        XsltExecutable stylesheet;
        XsltCompiler compiler;
        Processor processor;
        ActivateSaxon.activate();
        ArgumentParser argsParser = new ArgumentParser(args);
        String extender = "generic";
        if (argsParser.isSet("extender") && argsParser.getArgumentValue("extender").equals("MD-18.0")) {
            extender = "MD-18.0";
        }
        File modelsFile = new File(E2EBridgeModelGenerator.class.getResource("models.xml").toURI());
        File dest = modelsFile.getParentFile();
        if (argsParser.isSet("dest")) {
            dest = new File(argsParser.getArgumentValue("dest"));
        }
        dest.mkdirs();
        Document modelsDoc = E2EBridgeModelGenerator.collectModels();
        File source = new File(modelsFile.getParent(), "models-final.xml");
        source.delete();
        DomUtilities.serialize((File)source, (Document)modelsDoc, (boolean)true);
        TransformerLoader transformerLoader = new TransformerLoader(new File("src/main/xslt"), E2EBridgeModelGenerator.class.getClassLoader());
        String profileTransformerPath = "ch/e2e/builder/compiler/models/xslt/ebm2profile/ebm2profile-" + extender;
        Templates profileTemplates = transformerLoader.getTemplates(profileTransformerPath);
        Transformer transformer = profileTemplates.newTransformer();
        DOMResult result = new DOMResult();
        transformer.transform(new StreamSource(source), result);
        String profileName = "E2E Bridge Profile.xml";
        DomUtilities.serialize((File)new File(dest, profileName), (Node)result.getNode(), (boolean)true);
        if (argsParser.isSet("zip")) {
            profileName = profileName + ".zip";
            File tmpDest = new File(modelsFile.getParentFile(), "E2E Bridge Profile.xml.zip");
            DomUtilities.serializeToZip((File)tmpDest, (Document)((Document)result.getNode()), (boolean)true);
            FileUtilities.copyFile((File)tmpDest, (File)new File(dest, profileName));
        }
        String baseTransformerPath = "ch/e2e/builder/compiler/models/xslt/ebm2base/ebm2base-" + extender;
        Templates baseTemplates = transformerLoader.getTemplates(baseTransformerPath);
        Transformer baseTransformer = baseTemplates.newTransformer();
        DOMResult baseResult = new DOMResult();
        baseTransformer.transform(new StreamSource(source), baseResult);
        String baseName = "E2E Bridge Base.xml";
        DomUtilities.serialize((File)new File(dest, baseName), (Node)baseResult.getNode(), (boolean)true);
        if (argsParser.isSet("zip")) {
            baseName = baseName + ".zip";
            File tmpDest = new File(modelsFile.getParentFile(), "E2E Bridge Base.xml.zip");
            DomUtilities.serializeToZip((File)tmpDest, (Document)((Document)baseResult.getNode()), (boolean)true);
            FileUtilities.copyFile((File)tmpDest, (File)new File(dest, baseName));
        }
        if (extender.equals("generic")) {
            String jsonbaseTransformerPath = "ch/e2e/builder/compiler/models/xslt/ebm2jsonbase/ebm2jsonbase-" + extender;
            String jsonbaseName = "Bridge Base.json";
            processor = new Processor(false);
            compiler = processor.newXsltCompiler();
            stylesheet = compiler.compile((Source)new StreamSource("src/main/xslt/" + jsonbaseTransformerPath + ".xsl"));
            xslt30transformer = stylesheet.load30();
            out = processor.newSerializer(new File(dest, jsonbaseName));
            xslt30transformer.transform((Source)new StreamSource(source), (Destination)out);
        }
        if (extender.equals("generic")) {
            String stereotypesTransformerPath = "ch/e2e/builder/compiler/models/xslt/ebm2stereotype/stereotype.root-" + extender;
            String stereotypesName = "stereotypes.json";
            processor = new Processor(false);
            compiler = processor.newXsltCompiler();
            stylesheet = compiler.compile((Source)new StreamSource("src/main/xslt/" + stereotypesTransformerPath + ".xsl"));
            xslt30transformer = stylesheet.load30();
            out = processor.newSerializer(new File(dest, stereotypesName));
            xslt30transformer.transform((Source)new StreamSource(source), (Destination)out);
        }
    }

    static Document collectModels() throws ParserConfigurationException, SAXException, IOException, URISyntaxException {
        InputStream inputStream = E2EBridgeModelGenerator.class.getResourceAsStream("models-final.xml");
        if (inputStream != null) {
            return DomUtilities.parse((InputStream)inputStream, (boolean)false, (boolean)false, (boolean)true);
        }
        File modelsFile = new File(E2EBridgeModelGenerator.class.getResource("models.xml").toURI());
        Document modelsDoc = DomUtilities.parse((File)modelsFile, (boolean)false, (boolean)false, (boolean)true);
        File profileRoot = new File(modelsFile.getParent(), "profile");
        File baseRoot = new File(modelsFile.getParent(), "base");
        for (File file : profileRoot.listFiles()) {
            if (!file.exists() || !file.isDirectory()) continue;
            E2EBridgeModelGenerator.addFolder(modelsDoc.getDocumentElement(), file);
        }
        for (File file : baseRoot.listFiles()) {
            if (!file.exists() || !file.isDirectory()) continue;
            E2EBridgeModelGenerator.addFolder(modelsDoc.getDocumentElement(), file);
        }
        return modelsDoc;
    }

    private static void addFolder(Node parent, File folder) throws IOException, SAXException, ParserConfigurationException {
        File profileFile = new File(folder, folder.getName() + ".profile.xml");
        File packageFile = new File(folder, folder.getName() + ".package.xml");
        if (profileFile.exists() || packageFile.exists()) {
            File folderFile = profileFile.exists() ? profileFile : packageFile;
            Document doc = DomUtilities.parse((File)folderFile, (boolean)false, (boolean)false, (boolean)true);
            Element elt = doc.getDocumentElement();
            Node importElement = parent.getOwnerDocument().importNode(elt, true);
            parent.appendChild(importElement);
            for (File file : folder.listFiles()) {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    E2EBridgeModelGenerator.addFolder(importElement, file);
                }
                if (!file.getName().endsWith(".xml") || file.getName().endsWith(".profile.xml") || file.getName().endsWith(".package.xml")) continue;
                E2EBridgeModelGenerator.addFile(importElement, file);
            }
        }
    }

    private static void addFile(Node parent, File file) throws IOException, SAXException, ParserConfigurationException {
        if (file.exists()) {
            Document doc = DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)true);
            Element elt = doc.getDocumentElement();
            Node importElement = parent.getOwnerDocument().importNode(elt, true);
            parent.appendChild(importElement);
        }
    }
}

