/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tree.menu;

import ch.e2e.builder.base.gui.E2EBuilderQuestionDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.event.ClearAsyncTestcaseFolderEvent;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;

public class ClearAsyncTestcaseFolderExecuter
implements EventExecuter {
    private E2EBuilderModule module;

    public ClearAsyncTestcaseFolderExecuter(E2EBuilderModule module) {
        this.module = module;
    }

    public void execute(EventObject event) throws EventExecutionVetoException {
        String subtitle;
        AbstractAsyncTestcaseFolder folder = (AbstractAsyncTestcaseFolder)((ClearAsyncTestcaseFolderEvent)event).getTestcaseObject();
        String name = folder.getName();
        String question = this.module.getTranslation("async.testcase.folder.clear.question.message");
        question = StringTools.replaceProperty((String)question, (String)"class", (String)name);
        String title = this.module.getTranslation("async.testcase.folder.clear.question.title");
        if (E2EBuilderQuestionDialog.doYesNoQuestion((String)(title = StringTools.replaceProperty((String)title, (String)"class", (String)name)), (String)(subtitle = this.module.getTranslation("async.testcase.folder.clear.question.subtitle")), (String)question)) {
            ArrayList<AbstractAsynchronousTestcase> testcases = new ArrayList<AbstractAsynchronousTestcase>();
            for (int i = 0; i < folder.getChildCount(); ++i) {
                testcases.add((AbstractAsynchronousTestcase)folder.getChild(i));
            }
            for (AbstractAsynchronousTestcase testcase : testcases) {
                try {
                    folder.delete((TestcaseObject)testcase);
                }
                catch (FilesNotDeletedException e) {
                    for (File file : e.getFiles()) {
                        String msg = this.module.getTranslation("could.not.delete." + (file.isDirectory() ? "directory" : "file"));
                        this.module.showError(StringTools.replaceProperty((String)msg, (String)"file", (String)file.getPath()));
                    }
                }
            }
            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)folder));
        }
    }
}

