/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.tools;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.gui.NewPropertyDialog;
import ch.e2e.builder.base.gui.Property;
import ch.e2e.builder.base.gui.ResourceTableModel;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.tools.AuthorizationPropertyDialog;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.tools.StringConstants;
import ch.e2e.resource.Properties;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class HttpHeaderEditor
extends E2EBuilderDialog
implements StringConstants {
    private JTable resourceTable;
    private ResourceTableModel resourceTableModel;
    private JButton remove;

    public HttpHeaderEditor(JDialog parent, TraceViewer traceViewer) {
        super((Dialog)parent, traceViewer.getTranslation("resource.editor.title"), traceViewer.getTranslation("resource.editor.internaltitle"), traceViewer.getTranslation("resource.editor.subtitle"), 3);
        this.createGui(traceViewer);
    }

    public void editResources(File resourceFile, String title, String internalTitle, String subtitle) throws IOException {
        this.setTitles(title, internalTitle, subtitle);
        Properties properties = new Properties(resourceFile);
        if (this.editProperties(properties)) {
            this.saveProperties(properties);
        }
    }

    private void setTitles(String title, String internalTitle, String subtitle) {
        this.setTitle(title);
        this.setInternalTitle(internalTitle);
        this.setSubtitle(subtitle);
    }

    private boolean editProperties(Properties properties) {
        this.resourceTableModel.setProperties((Map)properties);
        return this.showDialog() == 1;
    }

    private void saveProperties(Properties properties) throws IOException {
        int i;
        List propertyList = this.resourceTableModel.getProperties();
        ArrayList names = new ArrayList();
        for (Object o : properties.keySet()) {
            names.add(o);
        }
        int length = propertyList.size();
        for (i = 0; i < length; ++i) {
            Property property = (Property)propertyList.get(i);
            names.remove(property.getKey());
            properties.setProperty(property.getKey(), property.getValue());
        }
        length = names.size();
        for (i = 0; i < length; ++i) {
            String key = (String)names.get(i);
            properties.removeProperty(key);
        }
        properties.write(false);
    }

    public int getMinimumHeight() {
        return 400;
    }

    public int getMinimumWidth() {
        return 500;
    }

    private void createGui(final TraceViewer traceViewer) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.initializeTable();
        this.resourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HttpHeaderEditor.this.checkRemoveButton();
            }
        });
        this.add(new JScrollPane(this.resourceTable), "Center");
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 0, 0);
        c.fill = 2;
        c.anchor = 11;
        c.gridwidth = 0;
        c.weighty = 0.0;
        JButton add = ComponentFactory.createButton((String)"resource.editor.button.add", (E2EBuilderModule)traceViewer);
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpHeaderEditor.this.addProperty();
            }
        });
        buttonPanel.add((Component)add, c);
        this.remove = ComponentFactory.createButton((String)"resource.editor.button.remove", (E2EBuilderModule)traceViewer);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpHeaderEditor.this.removeProperty();
            }
        });
        c.weighty = 1.0;
        buttonPanel.add((Component)this.remove, c);
        JButton modifyAuthorization = ComponentFactory.createButton((String)"http.header.editor.button.authorization", (E2EBuilderModule)traceViewer);
        modifyAuthorization.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HttpHeaderEditor.this.modifyAuthorizationProperty(traceViewer);
            }
        });
        c.weighty = 2.0;
        buttonPanel.add((Component)modifyAuthorization, c);
        this.add(buttonPanel, "East");
    }

    private void initializeTable() {
        this.resourceTableModel = new ResourceTableModel();
        this.resourceTable = new JTable((TableModel)this.resourceTableModel);
    }

    private void checkRemoveButton() {
        int[] selectedRows = this.resourceTable.getSelectedRows();
        boolean enabled = selectedRows.length > 0;
        this.remove.setEnabled(enabled);
    }

    private void removeProperty() {
        int[] selectedRows;
        for (int selectedRow : selectedRows = this.resourceTable.getSelectedRows()) {
            this.resourceTableModel.removeRow(selectedRow);
        }
    }

    private void addProperty() {
        Property property = NewPropertyDialog.createNewProperty();
        if (property != null) {
            this.resourceTableModel.addProperty(property);
        }
    }

    private void modifyAuthorizationProperty(TraceViewer traceViewer) {
        Property property = AuthorizationPropertyDialog.edit((List)this.resourceTableModel.getProperties(), (E2EBuilderModule)traceViewer);
        if (property != null) {
            int index = AuthorizationPropertyDialog.findAuthorizationProperty((List)this.resourceTableModel.getProperties());
            if (index != -1) {
                this.resourceTableModel.removeRow(index);
            }
            this.resourceTableModel.addProperty(property);
        }
    }
}

