/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.swing;

import ch.e2e.builder.base.project.event.ProjectEvent;
import ch.e2e.builder.base.project.event.ProjectListener;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.testcase.MainPanelView;
import ch.e2e.builder.trace.gui.testcase.TestcaseView;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.uml.TraceError;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.traceviewer.TraceViewer;
import ch.e2e.builder.traceviewer.swing.AsynchronousFolderView;
import ch.e2e.builder.traceviewer.swing.WSDLTreePanel;
import ch.e2e.builder.traceviewer.swing.testcase.AsynchronousTestcaseView;
import ch.e2e.builder.traceviewer.swing.testcase.AsynchronousTracePanel;
import ch.e2e.builder.traceviewer.swing.testcase.SynchronousTestcaseView;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.testcase.AsynchronousFolder;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.event.EventExecutionVetoException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class MainPanel
extends JPanel
implements ProjectListener {
    private Map<Class, MainPanelView> views = new HashMap<Class, MainPanelView>();
    private WSDLTreePanel overview;
    private TestcaseView testcaseView;
    private AsynchronousTestcaseView asynchronousView;
    private AsynchronousTracePanel asynchronousTracePanel;
    private MainPanelView actualView;
    private AsynchronousFolderView asynchronousFolderView;
    private TraceViewer module;

    public MainPanel(TraceViewer traceViewer) {
        super(new BorderLayout());
        this.module = traceViewer;
        this.createGui(traceViewer);
        traceViewer.addProjectListener(this);
    }

    public Object getRoot() {
        return this.actualView == null ? null : this.actualView.getRoot();
    }

    public MainPanelView getActualView() {
        return this.actualView;
    }

    public void pathChanged(TreePath newPath) {
        if (newPath != null) {
            Class<?> viewClass;
            Object object = newPath.getLastPathComponent();
            if (object instanceof LogFile) {
                viewClass = ((LogFile)object).getParent().getClass();
            } else if (object instanceof UmlObject) {
                viewClass = this.findTestcase(newPath).getClass();
                object = newPath;
            } else {
                viewClass = object.getClass();
            }
            MainPanelView nextView = this.findView(viewClass);
            if (nextView != null) {
                this.setPanel(nextView, object);
            }
        } else {
            this.setPanel(null, newPath);
        }
    }

    private Testcase findTestcase(TreePath treePath) {
        Testcase testcase = null;
        Object[] pathObjects = treePath.getPath();
        for (int i = 0; testcase == null && i < pathObjects.length; ++i) {
            if (!(pathObjects[i] instanceof Testcase)) continue;
            testcase = (Testcase)pathObjects[i];
        }
        return testcase;
    }

    private void setPanel(MainPanelView panel, Object root) {
        if (panel == null) {
            if (this.actualView != null) {
                this.actualView.setRoot(null);
            }
            this.actualView = null;
            this.module.setPrintEnabled(false);
            this.removeAll();
            SwingUtilities.updateComponentTreeUI(this);
        } else if (!panel.equals(this.actualView)) {
            if (panel instanceof AsynchronousTestcaseView) {
                EventController.registerSavely((EventExecuter)this.asynchronousView.getUmlView(), OpenLinkEvent.class);
                EventController.unregisterSavely((EventExecuter)this.testcaseView.getUmlView(), OpenLinkEvent.class);
            } else if (panel instanceof SynchronousTestcaseView) {
                EventController.unregisterSavely((EventExecuter)this.asynchronousView.getUmlView(), OpenLinkEvent.class);
                EventController.registerSavely((EventExecuter)this.testcaseView.getUmlView(), OpenLinkEvent.class);
            }
            this.removeAll();
            if (this.actualView != null) {
                this.actualView.setRoot(null);
            }
            this.actualView = panel;
            this.add((Component)this.actualView, "Center");
            this.revalidate();
            this.repaint();
        }
        if (this.actualView != null) {
            this.actualView.setRoot(root);
            this.module.setPrintEnabled(this.actualView.getPrintableObject() != null);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.overview != null) {
            this.overview.setEnabled(enabled);
        }
        if (this.testcaseView != null) {
            this.testcaseView.setEnabled(enabled);
        }
        if (this.asynchronousView != null) {
            this.asynchronousView.setEnabled(enabled);
        }
        if (this.asynchronousTracePanel != null) {
            this.asynchronousTracePanel.setEnabled(enabled);
        }
    }

    public void refresh() {
        if (this.actualView != null) {
            this.actualView.refresh();
        }
    }

    public Object getPrintableObject() {
        Object result = null;
        if (this.actualView != null) {
            result = this.actualView.getPrintableObject();
        }
        return result;
    }

    private void createGui(TraceViewer traceViewer) {
        this.overview = new WSDLTreePanel();
        this.asynchronousTracePanel = new AsynchronousTracePanel(traceViewer);
        this.testcaseView = new SynchronousTestcaseView(traceViewer);
        this.asynchronousView = new AsynchronousTestcaseView(traceViewer);
        this.asynchronousFolderView = new AsynchronousFolderView(traceViewer);
        this.views.put(AbstractSynchronousTestcase.class, (MainPanelView)this.testcaseView);
        this.views.put(TraceError.class, (MainPanelView)this.testcaseView);
        this.views.put(AbstractAsynchronousTestcase.class, (MainPanelView)this.asynchronousView);
        this.views.put(AbstractAsyncTestcaseFolder.class, this.asynchronousTracePanel);
        this.views.put(AsynchronousFolder.class, this.asynchronousFolderView);
        this.views.put(TestcaseObject.class, this.overview);
    }

    public void doBeforeChanging(ProjectEvent event) throws EventExecutionVetoException {
    }

    public void projectSettingsChange(ProjectEvent event) {
    }

    public void doBeforeProjectOpen(ProjectEvent event) {
        this.clearSelection();
    }

    public void clearSelection() {
        this.removeAll();
        this.testcaseView.setRoot(null);
        this.asynchronousView.setRoot(null);
        this.overview.setRoot(null);
        this.asynchronousTracePanel.setRoot(null);
        this.asynchronousFolderView.setRoot(null);
        this.actualView = null;
    }

    public void doAfterProjectOpen(ProjectEvent event) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    public void projectOpened(ProjectEvent event) {
    }

    private MainPanelView findView(Class clazz) {
        MainPanelView result = this.views.get(clazz);
        while (result == null && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            result = this.views.get(clazz);
        }
        return result;
    }
}

