/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.soap;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.TraceSettings;
import ch.e2e.builder.traceviewer.execute.soap.AsynchronousRequest;
import ch.e2e.builder.traceviewer.execute.soap.AsynchronousTransaction;
import ch.e2e.builder.traceviewer.execute.soap.Logging;
import ch.e2e.builder.traceviewer.testcase.AbstractAsyncTestcaseFolder;
import ch.e2e.builder.traceviewer.tree.menu.RefreshConfigurationEvent;
import ch.e2e.event.EventController;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.xpath.XPathEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetConfigurationTransaction
extends AsynchronousTransaction {
    private static final String XPATH_TRACE_LEVEL = "Trace/Configuration/TraceLevel";
    private static final String XPATH_MAX_SIZE = "Trace/Configuration/MaxSize";
    private static final String XPATH_ACTIVITY = "Trace/Configuration/InspectionList/Activity";
    private static final String XPATH_INSPECTION_IDS = "data(Trace/Configuration/InspectionList/Activity)";
    private static XPathExpression traceLevelExpression;
    private static XPathExpression maxSizeExpression;
    private static XPathExpression activityExpression;
    private static XPathExpression inspectionIdsExpression;

    public GetConfigurationTransaction(E2EBuilderModule traceViewer) {
        super(traceViewer);
    }

    public void setTransactionResult(Object result) {
        super.setTransactionResult(result);
        AsynchronousRequest request = (AsynchronousRequest)result;
        AbstractAsyncTestcaseFolder testcaseFolder = (AbstractAsyncTestcaseFolder)request.getSource();
        Document response = request.getResponse();
        if (response != null) {
            try {
                String traceLevel = traceLevelExpression.evaluate(response);
                String maxSize = maxSizeExpression.evaluate(response);
                int activityCount = ((NodeList)activityExpression.evaluate(response, XPathConstants.NODESET)).getLength();
                testcaseFolder.setConfiguration(new AbstractAsyncTestcaseFolder.Configuration(traceLevel.isEmpty() ? TraceSettings.TraceLevel.None : TraceSettings.TraceLevel.valueOf((String)traceLevel), maxSize.isEmpty() ? -1 : Integer.parseInt(maxSize), activityCount == 0 ? Collections.emptyList() : (Collection)inspectionIdsExpression.evaluate(response, XPathConstants.NODESET)));
            }
            catch (Exception e) {
                testcaseFolder.setConfiguration(null);
            }
            EventController.fire((EventObject)((Object)new RefreshConfigurationEvent((Object)this, testcaseFolder)));
        }
    }

    static {
        try {
            XPathEvaluator xpath = new XPathEvaluator();
            traceLevelExpression = xpath.compile(XPATH_TRACE_LEVEL);
            maxSizeExpression = xpath.compile(XPATH_MAX_SIZE);
            activityExpression = xpath.compile(XPATH_ACTIVITY);
            inspectionIdsExpression = xpath.compile(XPATH_INSPECTION_IDS);
        }
        catch (XPathException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logging.logger.throwing(GetConfigurationTransaction.class.getName(), "", e);
        }
    }
}

