/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.UmlObjectFactory;
import ch.e2e.builder.trace.testcase.uml.UmlTree;
import ch.e2e.builder.trace.tools.SkipXmlPrologReader;
import ch.e2e.builder.trace.tree.RefreshAsynchronousTreeEvent;
import ch.e2e.builder.traceviewer.execute.rest.AsyncRequest;
import ch.e2e.builder.traceviewer.execute.rest.GetTraceRequest;
import ch.e2e.builder.traceviewer.execute.rest.RequestTransaction;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EventObject;
import javax.swing.JFileChooser;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class GetTraceTransaction
extends RequestTransaction<Document> {
    private static final boolean DEBUG = Boolean.getBoolean("ch.e2e.builder.traceviewer.asyncResponse.log.choose.file");
    private static File traceFile;

    public GetTraceTransaction(E2EBuilderModule traceViewer) {
        super(traceViewer);
    }

    @Override
    protected Document performRequest(AsyncRequest<Document> request) throws Exception {
        return DEBUG ? GetTraceTransaction.getDebugResponse() : super.performRequest(request);
    }

    private static Document getDebugResponse() throws ParserConfigurationException, IOException, SAXException {
        traceFile = GetTraceTransaction.chooseTraceFile();
        try (SkipXmlPrologReader reader = new SkipXmlPrologReader((Reader)new FileReader(traceFile));){
            Document document = DomUtilities.parse((Reader)reader, (boolean)false, (boolean)false, (boolean)true);
            return document;
        }
    }

    private static File chooseTraceFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(traceFile);
        fileChooser.showOpenDialog(null);
        return fileChooser.getSelectedFile();
    }

    public void setTransactionResult(Object result) {
        GetTraceRequest request = (GetTraceRequest)result;
        ch.e2e.builder.traceviewer.testcase.AbstractAsynchronousTestcase testcase = request.getSource();
        Document response = (Document)request.getResponse();
        if (response != null) {
            testcase.setResponse(response);
            this.handleCompositeStates((AbstractAsynchronousTestcase)testcase);
            EventController.fire((EventObject)new RefreshAsynchronousTreeEvent((Object)this, (TestcaseObject)testcase));
        }
    }

    private void handleCompositeStates(AbstractAsynchronousTestcase testcase) {
        UmlTree umlTree = testcase.getUmlTree();
        if (umlTree != null) {
            umlTree.getStates().forEach(state -> {
                File stateDiagramFile = new File(testcase.getTraceFolder(), state.getFilename() + ".xml");
                if (stateDiagramFile.exists()) {
                    UmlObject stateDiagram = UmlObjectFactory.createUmlObject((File)stateDiagramFile);
                    for (int i = 0; i < stateDiagram.getChildCount(); ++i) {
                        UmlObject child = (UmlObject)stateDiagram.getChild(i);
                        state.addChild(child);
                    }
                }
            });
        }
    }

    static {
        String filename = System.getProperty("ch.e2e.builder.traceviewer.response.log");
        if (filename != null) {
            traceFile = new File(filename);
        }
    }
}

