/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.utils;

import ch.e2e.xuml.utils.ClassFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFinder {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char RESOURCE_SEPARATOR = '/';
    private static final char FILE_SEPARATOR = File.separatorChar;
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final ClassFilter ACCEPT_ALL_CLASSES = new AcceptAllClassFilter();
    private final String packageName;
    private final ClassFilter classFilter;
    private final Class<?>[] classes;

    public ClassFinder(String packageName) {
        this(packageName, ACCEPT_ALL_CLASSES);
    }

    public ClassFinder(String packageName, ClassFilter classFilter) {
        this.packageName = packageName;
        this.classFilter = classFilter;
        this.classes = this.findClasses();
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    private Class<?>[] findClasses() {
        String resourceName = this.getResourceName(this.packageName);
        Enumeration<URL> resources = this.getResources(resourceName);
        return this.findClasses(resources);
    }

    private Class<?>[] findClasses(Enumeration<URL> resources) {
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            List<Class<?>> classesOfResource = this.findClasses(resource);
            classes.addAll(classesOfResource);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected Enumeration<URL> getResources(String resourceName) {
        EmptyURLEnumeration resources;
        try {
            resources = this.getClass().getClassLoader().getResources(resourceName);
        }
        catch (IOException e) {
            resources = new EmptyURLEnumeration();
        }
        return resources;
    }

    private String getResourceName(String packageName) {
        return packageName.replace('.', '/');
    }

    private List<Class<?>> findClasses(URL resource) {
        List<Class<?>> classes = Collections.emptyList();
        String protocol = resource.getProtocol();
        if (protocol.equals("file")) {
            File classFolder = new File(resource.getFile());
            classes = this.findClasses(classFolder);
        } else if (protocol.equals("jar")) {
            try {
                JarURLConnection urlConnection = (JarURLConnection)resource.openConnection();
                classes = this.findClasses(urlConnection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return classes;
    }

    private List<Class<?>> findClasses(File classFolder) {
        String[] classFileNames = classFolder.list(new AcceptClassFileFilter());
        return this.findClasses(classFileNames);
    }

    private List<Class<?>> findClasses(String[] classFileNames) {
        ArrayList classes = new ArrayList();
        for (String classFileName : classFileNames) {
            try {
                Class<?> clazz = this.loadClass(classFileName);
                classes.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassNotAcceptedException classNotAcceptedException) {
                // empty catch block
            }
        }
        return classes;
    }

    private Class<?> loadClass(String classFileName) throws ClassNotFoundException, ClassNotAcceptedException {
        String className = this.constructClassName(classFileName);
        Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
        if (this.classFilter.accept(clazz)) {
            return clazz;
        }
        throw new ClassNotAcceptedException(className);
    }

    private List<Class<?>> findClasses(JarURLConnection connection) {
        try {
            JarFile jarFile = connection.getJarFile();
            return this.findClasses(jarFile);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private List<Class<?>> findClasses(JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        ArrayList classes = new ArrayList();
        while (entries.hasMoreElements()) {
            try {
                Class<?> clazz = this.loadClass(entries.nextElement());
                classes.add(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassNotAcceptedException classNotAcceptedException) {}
        }
        return classes;
    }

    private Class<?> loadClass(JarEntry entry) throws ClassNotFoundException, ClassNotAcceptedException {
        File file = new File(entry.getName());
        if (this.acceptPackageAndClassFile(file)) {
            return this.loadClass(file.getName());
        }
        throw new ClassNotAcceptedException(file.getName());
    }

    private boolean acceptPackageAndClassFile(File file) {
        AcceptPackageAndClassFileFilter acceptPackageAndClassFile = new AcceptPackageAndClassFileFilter(this.packageName);
        return acceptPackageAndClassFile.accept(file);
    }

    private String constructClassName(String classFileName) {
        return this.packageName + '.' + classFileName.substring(0, classFileName.length() - CLASS_FILE_SUFFIX.length());
    }

    private class ClassNotAcceptedException
    extends Exception {
        ClassNotAcceptedException(String className) {
            super(className);
        }
    }

    private static class EmptyURLEnumeration
    implements Enumeration<URL> {
        private EmptyURLEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    }

    private class AcceptPackageAndClassFileFilter
    implements FileFilter {
        private final String packageName;

        AcceptPackageAndClassFileFilter(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public boolean accept(File pathname) {
            String dir = pathname.getParent();
            if (dir != null) {
                dir = dir.replace(FILE_SEPARATOR, '.');
                String fileName = pathname.getName();
                return dir.equals(this.packageName) && fileName.endsWith(ClassFinder.CLASS_FILE_SUFFIX);
            }
            return false;
        }
    }

    private static class AcceptClassFileFilter
    implements FilenameFilter {
        private AcceptClassFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(ClassFinder.CLASS_FILE_SUFFIX);
        }
    }

    private static class AcceptAllClassFilter
    implements ClassFilter {
        private AcceptAllClassFilter() {
        }

        @Override
        public boolean accept(Class<?> aClass) {
            return true;
        }
    }
}

