/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateProcessingException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrSubstitutor;

public class TemplateProcessor {
    private final Template template;
    private final Map<String, String> substitutions = new HashMap<String, String>();
    private final Properties variables;

    public TemplateProcessor(Template template, Properties variables) {
        this.template = template;
        this.variables = variables;
    }

    public TemplateProcessor(Template template, Iterable<? extends Setting> settings, Properties variables) {
        this(template, variables);
        this.addSubstitutions(settings);
    }

    public TemplateProcessor(Template template, Properties substitutions, Properties variables) {
        this(template, variables);
        this.addSubstitutions(substitutions);
    }

    public void addSubstitutions(Iterable<? extends Setting> settings) {
        for (Setting setting : settings) {
            this.addSubstitution(setting);
        }
    }

    public void addSubstitution(Setting setting) {
        if (!setting.hasDependents() || setting.isUsedInTemplate(this.template.getName())) {
            String placeholder = this.getPlaceholder(setting);
            this.addSubstitution(placeholder, setting.getReplacedValue());
        }
    }

    public void addSubstitutions(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.addSubstitution(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    String getPlaceholder(Setting setting) {
        return setting.getPlaceholderForTemplate(this.template.getName());
    }

    public void addSubstitution(String key, String value) {
        value = this.substituteConsoleProperties(value);
        this.substitutions.put(key, value);
    }

    private String substituteConsoleProperties(String value) {
        return StrSubstitutor.replace((Object)value, (Properties)this.getVariables());
    }

    private Properties getVariables() {
        return this.variables;
    }

    public String processToString() throws TemplateProcessingException {
        Reader reader = null;
        StringWriter writer = null;
        try {
            reader = this.template.getReader();
            writer = new StringWriter();
            this.process(reader, writer);
            String string = writer.toString();
            this.close(reader, writer);
            return string;
        }
        catch (PlaceholderSubstitutorException e) {
            try {
                throw new TemplateProcessingException(e);
            }
            catch (Throwable throwable) {
                this.close(reader, writer);
                throw throwable;
            }
        }
    }

    public void processAndWrite() throws TemplateProcessingException {
        Reader reader = null;
        Writer writer = null;
        try {
            reader = this.template.getReader();
            writer = this.template.getWriter();
            this.process(reader, writer);
            this.close(reader, writer);
        }
        catch (PlaceholderSubstitutorException e) {
            try {
                throw new TemplateProcessingException(e);
            }
            catch (Throwable throwable) {
                this.close(reader, writer);
                throw throwable;
            }
        }
    }

    private void process(Reader reader, Writer writer) throws PlaceholderSubstitutorException {
        PlaceholderSubstitutor substitutor = this.template.getPlaceholderSubstitutor();
        substitutor.applySubstitutions(reader, writer, this.substitutions);
    }

    private void close(Reader reader, Writer writer) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

