/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.substitutor;

import ch.e2e.dom.DomUtilities;
import ch.e2e.util.StringTools;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlPlaceholderSubstitutor
implements PlaceholderSubstitutor {
    private static final String TAB_SUFFIX = ".tab";
    private final boolean namespaceAware;

    public XmlPlaceholderSubstitutor() {
        this(false);
    }

    public XmlPlaceholderSubstitutor(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public boolean canProcess(String filePath) {
        return filePath.endsWith(TAB_SUFFIX);
    }

    @Override
    public void applySubstitutions(Reader reader, Writer writer, Map<String, String> substitutions) throws PlaceholderSubstitutorException {
        try {
            Document document = DomUtilities.parse((Reader)reader, (boolean)false, (boolean)false, (boolean)this.namespaceAware);
            this.applySubstitutions(document.getDocumentElement(), substitutions);
            DomUtilities.serialize((Writer)writer, (Document)document, (boolean)false);
        }
        catch (ParserConfigurationException e) {
            throw new PlaceholderSubstitutorException(e);
        }
        catch (SAXException e) {
            throw new PlaceholderSubstitutorException(e);
        }
        catch (IOException e) {
            throw new PlaceholderSubstitutorException(e);
        }
        catch (TransformerException e) {
            throw new PlaceholderSubstitutorException(e);
        }
    }

    private void applySubstitutions(Node node, Map<String, String> substitutions) {
        if (XmlPlaceholderSubstitutor.isTextNode(node)) {
            this.applySubstitutionsToNodeValue(node, substitutions);
        } else {
            this.applySubstitutions(node.getAttributes(), substitutions);
            this.applySubstitutions(node.getChildNodes(), substitutions);
        }
    }

    private static boolean isTextNode(Node node) {
        return node instanceof Text;
    }

    private void applySubstitutionsToNodeValue(Node node, Map<String, String> substitutions) {
        if (!node.getNodeValue().trim().isEmpty()) {
            String newValue = this.applySubstitutions(node.getNodeValue(), substitutions);
            node.setNodeValue(newValue);
        }
    }

    private String applySubstitutions(String value, Map<String, String> substitutions) {
        return StringTools.replaceProperties((String)value, substitutions);
    }

    private void applySubstitutions(NamedNodeMap nodes, Map<String, String> substitutions) {
        int nNodes = nodes.getLength();
        for (int i = 0; i < nNodes; ++i) {
            this.applySubstitutionsToNodeValue(nodes.item(i), substitutions);
        }
    }

    private void applySubstitutions(NodeList nodes, Map<String, String> substitutions) {
        int nNodes = nodes.getLength();
        for (int i = 0; i < nNodes; ++i) {
            this.applySubstitutions(nodes.item(i), substitutions);
        }
    }
}

