/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.view;

import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.view.Container;
import ch.e2e.xuml.settings.view.Section;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Category
extends Container<Section> {
    private static final String GLOBAL_SETTINGS = "global";

    public Category(Element element, Map<String, ? extends Setting> settings) {
        super(element);
        NodeList elements = element.getElementsByTagName("Section");
        int nSections = elements.getLength();
        for (int i = 0; i < nSections; ++i) {
            Section section = new Section((Element)elements.item(i), settings);
            this.addChild(section);
        }
    }

    public Collection<Section> getSections() {
        return Collections.unmodifiableCollection(this.getChildren().values());
    }

    public Section getSection(String sectionName) {
        return (Section)this.getChildren().get(sectionName);
    }

    public boolean isGlobalSetting() {
        return this.getLabel().toLowerCase().startsWith(GLOBAL_SETTINGS);
    }
}

