/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.model;

import ch.e2e.xuml.settings.utils.GlobalVariables;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SettingChange {
    private static final String TAG_NAME = "default";
    static final String ATTR_ID = "id";
    static final String ATTR_VALUE = "value";
    private final String id;
    private final String value;
    private final String replacedValue;

    public SettingChange(Element element) {
        this(element.getAttribute(ATTR_ID), element.getAttribute(ATTR_VALUE));
    }

    public SettingChange(String id, String value) {
        this(id, value, null);
    }

    public SettingChange(String id, String value, String replacedValue) {
        this.id = id;
        this.value = value == null ? "" : value;
        this.replacedValue = replacedValue;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String getReplacedValue() {
        return this.replacedValue;
    }

    public SettingChange with(Map<String, String> variables) {
        String replacedValue = GlobalVariables.replace(this.value, variables);
        boolean replaced = this.value != replacedValue && !replacedValue.equals(this.getReplacedValue());
        return replaced ? new SettingChange(this.getId(), this.getValue(), replacedValue) : this;
    }

    public Element toXml(Document doc) {
        Element element = doc.createElement(TAG_NAME);
        element.setAttribute(ATTR_ID, this.id);
        element.setAttribute(ATTR_VALUE, this.value);
        return element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingChange change = (SettingChange)o;
        return this.getId().equals(change.getId()) && this.getValue().equals(change.getValue()) && (this.getReplacedValue() == null ? change.getReplacedValue() == null : this.getReplacedValue().equals(change.getReplacedValue()));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "SettingChange{id='" + this.id + '\'' + ", value='" + this.value + '\'' + ", replacedValue='" + this.replacedValue + '\'' + '}';
    }
}

