/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings;

import ch.e2e.dom.DomUtilities;
import ch.e2e.xuml.settings.SettingsException;
import ch.e2e.xuml.settings.model.Model;
import ch.e2e.xuml.settings.model.Reloadable;
import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.model.SettingChange;
import ch.e2e.xuml.settings.model.SettingChangesFactory;
import ch.e2e.xuml.settings.utils.OverrideConverter;
import ch.e2e.xuml.settings.view.Category;
import ch.e2e.xuml.settings.view.Section;
import ch.e2e.xuml.settings.view.SettingRow;
import ch.e2e.xuml.settings.view.View;
import ch.e2e.xuml.template.RepositoryTemplate;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateProcessingException;
import ch.e2e.xuml.template.TemplateProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Settings {
    private static final String FILE_REPOSITORY = "repository.jar";
    private static final String DIRECTORY_REPOSITORY = "repository";
    private final File serviceHomeDir;
    private final File repository;
    private final Map<String, Setting> settings;
    private final Map<String, String> templateToTarget;
    private final Category[] categories;
    private final List<SettingRow> settingRows;

    public static Settings createFromRepository(File repository) throws SettingsException {
        return new Settings(Builder.newBuilderFromRepository(repository));
    }

    public static Settings createFromRepositoryWithChangedSettings(File repository) throws SettingsException {
        return new Settings(Builder.newBuilderFromRepositoryWithChangedSettings(repository));
    }

    public Settings() {
        this(new Builder());
    }

    public Settings(File serviceHomeDir, Map<String, String> globalVariables) throws SettingsException {
        this(Builder.newBuilder(serviceHomeDir, globalVariables));
    }

    Settings(File serviceHomeDir) throws SettingsException {
        this(Builder.newBuilder(serviceHomeDir, Collections.emptyMap()));
    }

    public Settings(File serviceHomeDir, File repository, InputStream settingsStream, InputStream settingChangesStream) throws SettingsException {
        this(Builder.newBuilder(serviceHomeDir, repository, settingsStream, settingChangesStream, Collections.emptyMap()));
    }

    public Settings(InputStream settingsStream, InputStream settingChangesStream) throws SettingsException {
        this(Builder.newBuilder(settingsStream, settingChangesStream, Collections.emptyMap()));
    }

    private Settings(Builder builder) {
        this.serviceHomeDir = builder.serviceHomeDir;
        this.repository = builder.repository;
        this.settings = builder.settings;
        this.templateToTarget = builder.templateToTarget;
        this.categories = builder.categories;
        this.settingRows = builder.settingRows;
    }

    public List<SettingRow> getSettingRows() {
        return this.settingRows;
    }

    public Map<String, Setting> getSettings() {
        return this.settings;
    }

    public Map<String, String> getTemplateToTarget() {
        return this.templateToTarget;
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public Collection<SettingRow> getSettingRowsForSection(String sectionName) {
        for (Category category : this.categories) {
            Section section = category.getSection(sectionName);
            if (section == null) continue;
            return section.getSettingRows();
        }
        return Collections.emptyList();
    }

    public List<Setting> applySettingChanges(Iterable<? extends SettingChange> settingChanges, Map<String, String> variables) {
        ArrayList<Setting> changedSettings = new ArrayList<Setting>();
        for (SettingChange settingChange : settingChanges) {
            boolean changed;
            Setting setting = this.getSetting(settingChange.getId());
            if (setting == null || !(changed = setting.applySettingChange(settingChange, variables))) continue;
            changedSettings.add(setting);
        }
        return changedSettings;
    }

    public List<Setting> substituteGlobalVariables(Map<String, String> variables) {
        ArrayList<Setting> changedSettings = new ArrayList<Setting>();
        for (Setting setting : this.settings.values()) {
            if (!setting.substituteGlobalVariables(variables)) continue;
            changedSettings.add(setting);
        }
        return changedSettings;
    }

    public List<Setting> getModifiedSettings() {
        ArrayList<Setting> changedSettings = new ArrayList<Setting>();
        for (Setting setting : this.settings.values()) {
            if (!setting.isModified()) continue;
            changedSettings.add(setting);
        }
        return changedSettings;
    }

    public void storeChangedSettings(List<Setting> settings) throws SettingsException {
        SettingChangesFactory.serializeChangedSettings(this.serviceHomeDir, settings);
    }

    public Map<String, String> getSubstitutions() {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        for (Setting setting : this.getSettings().values()) {
            substitutions.put(setting.getId(), setting.getReplacedValue());
        }
        return substitutions;
    }

    public Map<String, String> getSubstitutions(String templateName) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        for (Setting setting : this.getSettings().values()) {
            if (!setting.isUsedInTemplate(templateName)) continue;
            substitutions.put(setting.getId(), setting.getReplacedValue());
        }
        return substitutions;
    }

    public String toCsv(char separator) {
        return Settings.toCsv(this.getCategories(), separator);
    }

    static String toCsv(Category[] categories, char separator) {
        StringBuilder sb = new StringBuilder();
        sb.append("Category").append(separator).append("Key").append(separator).append("Value").append(separator).append("Replaced Value").append("\n");
        for (Category category : categories) {
            for (Section section : category.getSections()) {
                String sectionName = Settings.escapeCsv(section.getLabel(), separator);
                for (SettingRow settingRow : section.getSettingRows()) {
                    sb.append(sectionName).append(separator).append(settingRow.toCsv(separator)).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public static String escapeCsv(String value, char separator) {
        boolean doQuoting = false;
        if (value.contains("\"")) {
            doQuoting = true;
            value = value.replace("\"", "\"\"");
        } else if (value.contains(String.valueOf(separator))) {
            doQuoting = true;
        }
        if (doQuoting) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    public static String reloadCommand(Iterable<? extends Reloadable> changes) {
        StringBuilder command = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Reload>\n");
        for (Reloadable reloadable : changes) {
            command.append("\t").append(reloadable.reloadCommand()).append("\n");
        }
        command.append("</Reload>\n");
        return command.toString();
    }

    public boolean isFlagSet(String settingId) {
        Setting setting = this.getSetting(settingId);
        return setting != null && Boolean.parseBoolean(setting.getReplacedValue());
    }

    public Setting getSetting(String settingId) {
        return this.settings.get(settingId);
    }

    public void createTabFilesFromTemplate(Properties bridgeProperties) throws SettingsException {
        Collection<Setting> settings = this.getSettings().values();
        for (Map.Entry<String, String> entry : this.getTemplateToTarget().entrySet()) {
            try {
                this.createTabFileFromTemplate(entry, settings, bridgeProperties);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTabFileFromTemplate(Map.Entry<String, String> templateToTarget, Iterable<? extends Setting> settings, Properties bridgeProperties) throws IOException, TemplateProcessingException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.repository);
            String templateName = templateToTarget.getKey();
            File targetDir = new File(this.serviceHomeDir, DIRECTORY_REPOSITORY);
            String targetName = templateToTarget.getValue();
            File targetFile = new File(targetDir, targetName);
            RepositoryTemplate template = new RepositoryTemplate(zipFile, templateName, targetFile);
            TemplateProcessor processor = new TemplateProcessor((Template)template, settings, bridgeProperties);
            processor.processAndWrite();
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static class Builder {
        private static final String FILE_SUBSTITUTIONS = "substitutions.xml";
        private static final String FILE_CHANGED_SETTINGS = "changedSettings.xml";
        private static final String FILE_OVERRIDE = "override.xml";
        private static final String FILE_OVERRIDES = "overrides.xml";
        private File repository;
        private File serviceHomeDir;
        private Map<String, Setting> settings;
        private Map<String, String> templateToTarget;
        private Category[] categories;
        private List<SettingRow> settingRows;

        private static Builder newBuilder(File serviceHomeDir, Map<String, String> globalVariables) throws SettingsException {
            ZipFile repository = null;
            try {
                File repositoryFile = new File(serviceHomeDir, Settings.FILE_REPOSITORY);
                repository = new ZipFile(repositoryFile);
                Builder builder = new Builder(serviceHomeDir, repositoryFile, Builder.getSubstitutionsStream(repository), SettingChangesFactory.getSettingChanges(serviceHomeDir), globalVariables);
                return builder;
            }
            catch (SettingsException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            finally {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (IOException e) {
                        throw new SettingsException(e);
                    }
                }
            }
        }

        private static Builder newBuilder(File serviceHomeDir, File repository, InputStream settingsStream, InputStream settingChangesStream, Map<String, String> globalVariables) throws SettingsException {
            try {
                return new Builder(serviceHomeDir, repository, settingsStream, settingChangesStream, globalVariables);
            }
            catch (SettingsException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
        }

        private static Builder newBuilderFromRepository(File repositoryFile) throws SettingsException {
            ZipFile repository = null;
            try {
                repository = new ZipFile(repositoryFile);
                Builder builder = new Builder(Builder.getSubstitutionsStream(repository), Collections.<String, SettingChange>emptyMap(), Collections.<String, String>emptyMap());
                return builder;
            }
            catch (SettingsException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            finally {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (IOException e) {
                        throw new SettingsException(e);
                    }
                }
            }
        }

        private static Builder newBuilderFromRepositoryWithChangedSettings(File repositoryFile) throws SettingsException {
            ZipFile repository = null;
            try {
                repository = new ZipFile(repositoryFile);
                Builder builder = new Builder(Builder.getSubstitutionsStream(repository), Builder.getChangedSettingsStream(repository), Collections.<String, String>emptyMap());
                return builder;
            }
            catch (SettingsException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            finally {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (IOException e) {
                        throw new SettingsException(e);
                    }
                }
            }
        }

        private static Builder newBuilder(InputStream settingsStream, InputStream settingChangesStream, Map<String, String> globalVariables) throws SettingsException {
            try {
                return new Builder(settingsStream, settingChangesStream, globalVariables);
            }
            catch (SettingsException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (TemplateProcessingException e) {
                throw new SettingsException(e);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
        }

        private Builder() {
            this.settings = Collections.emptyMap();
            this.templateToTarget = Collections.emptyMap();
            this.categories = new Category[0];
            this.settingRows = Collections.emptyList();
        }

        private Builder(File serviceHomeDir, File repository, InputStream settingsStream, InputStream settingChangesStream, Map<String, String> globalVariables) throws SettingsException, SAXException, ParserConfigurationException, TemplateProcessingException, IOException {
            this(serviceHomeDir, repository, settingsStream, SettingChangesFactory.getSettingChanges(settingChangesStream), globalVariables);
        }

        private Builder(File serviceHomeDir, File repository, InputStream settingsStream, Map<String, SettingChange> settingChanges, Map<String, String> globalVariables) throws SAXException, ParserConfigurationException, TemplateProcessingException, IOException {
            this(settingsStream, settingChanges, globalVariables);
            this.serviceHomeDir = serviceHomeDir;
            this.repository = repository;
        }

        private Builder(InputStream settingsStream, InputStream settingChangesStream, Map<String, String> globalVariables) throws SettingsException, SAXException, ParserConfigurationException, TemplateProcessingException, IOException {
            this(settingsStream, SettingChangesFactory.getSettingChanges(settingChangesStream), globalVariables);
        }

        private Builder(InputStream settingsStream, Map<String, SettingChange> settingChanges, Map<String, String> globalVariables) throws IOException, SAXException, ParserConfigurationException, TemplateProcessingException {
            Document substitutionsDocument = DomUtilities.parse((InputStream)settingsStream, (boolean)false, (boolean)false, (boolean)false);
            Model model = new Model(substitutionsDocument, settingChanges, globalVariables);
            this.settings = model.getSettings();
            this.templateToTarget = model.getTemplateToTarget();
            View view = new View(substitutionsDocument, this.settings);
            this.categories = view.getCategories();
            this.settingRows = view.getSettingRows();
        }

        private static InputStream getSubstitutionsStream(ZipFile repository) throws SettingsException {
            try {
                ZipEntry entry = repository.getEntry(FILE_SUBSTITUTIONS);
                if (entry != null) {
                    return repository.getInputStream(entry);
                }
                entry = repository.getEntry(FILE_OVERRIDE);
                if (entry == null) {
                    throw new IllegalStateException("Neither 'substitutions.xml' nor 'override.xml' found.");
                }
                InputStream in = repository.getInputStream(entry);
                Document overridesDoc = DomUtilities.parse((InputStream)in, (boolean)false, (boolean)false, (boolean)false);
                Document substitutionsDoc = new OverrideConverter().convert(overridesDoc);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DomUtilities.serialize((OutputStream)out, (Document)substitutionsDoc, (boolean)false);
                return new ByteArrayInputStream(out.toByteArray());
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (TransformerException e) {
                throw new SettingsException(e);
            }
        }

        private static InputStream getChangedSettingsStream(ZipFile repository) throws SettingsException {
            try {
                ZipEntry entry = repository.getEntry(FILE_CHANGED_SETTINGS);
                if (entry != null) {
                    return repository.getInputStream(entry);
                }
                return SettingChangesFactory.emptyInputStream();
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
        }
    }
}

