/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.analyzer.model;

import ch.e2e.builder.analyzer.model.Logging;
import ch.e2e.builder.analyzer.model.TransactionLogCall;
import ch.e2e.builder.analyzer.model.TransactionLogEntry;
import ch.e2e.builder.analyzer.model.TransactionLogLifeline;
import ch.e2e.builder.analyzer.model.TransactionLogObject;
import ch.e2e.builder.analyzer.model.TransactionLogRequest;
import ch.e2e.builder.analyzer.model.TransactionLogStatistics;
import ch.e2e.builder.analyzer.model.TransactionLogTransaction;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransactionLog
extends TransactionLogObject {
    private static final String DEFAULT_LOG_FILENAME = "transaction.log.zip";
    private static final String PROPERTY_XML_PATH = "ch.e2e.builder.analyzer.xmlpath";
    private static final String SCRIPT_TO_HTML = "ch/e2e/builder/analyzer/xslt/toHTML/toHTML";
    private static final String xmlPath = System.getProperty("ch.e2e.builder.analyzer.xmlpath");
    private static final TransformerLoader transformerLoader = new TransformerLoader(xmlPath, TransactionLog.class.getClassLoader());
    private File home;
    private File logFile;
    private String fullName;
    private String name;
    private Date start;
    private Date end;
    private Transformer transformer;
    private URL statisticsFileUrl;
    private boolean loaded = false;
    private Map<String, TransactionLogTransaction> transactions = new LinkedHashMap<String, TransactionLogTransaction>();
    private RequestIdCounter requestIdCounter = new RequestIdCounter();
    private Map<String, TransactionLogRequest> requests = new LinkedHashMap<String, TransactionLogRequest>();
    private Map<String, TransactionLogLifeline> lifelines = new LinkedHashMap<String, TransactionLogLifeline>();
    private List<Throwable> errors = new ArrayList<Throwable>();
    private Version version;

    public TransactionLog(File logFile, File home) throws IOException {
        this.logFile = logFile;
        this.home = home;
        this.fullName = home.getName();
        int index = this.fullName.lastIndexOf(" (");
        this.name = index == -1 ? this.fullName : this.fullName.substring(0, index);
    }

    public TransactionLog(File home) throws IOException {
        this.home = home;
        this.fullName = home.getName();
        this.logFile = this.getLogFile();
    }

    public void load() throws IOException, IllegalArgumentException {
        if (!this.isLoaded()) {
            try {
                this.load(new ZipFile(this.logFile));
            }
            catch (ZipException e) {
                this.load(this.logFile);
            }
        }
    }

    private void load(ZipFile zipFile) throws IOException, IllegalArgumentException {
        this.read(zipFile);
        this.computeStatistics();
    }

    private void load(File file) throws IOException, IllegalArgumentException {
        this.read(file);
        this.computeStatistics();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public File getLogFile() {
        return new File(this.getTraceFolder(), DEFAULT_LOG_FILENAME);
    }

    public File getTraceFolder() {
        return new File(this.home, ".$" + this.getFullName() + ".trace");
    }

    public File getGraphFolder() {
        return new File(this.home, ".$" + this.getFullName() + ".graph");
    }

    @Override
    public String getId() {
        return this.getFullName();
    }

    public Collection<TransactionLogTransaction> getTransactions() {
        return this.transactions.values();
    }

    public Collection<TransactionLogRequest> getRequests() {
        return this.requests.values();
    }

    public Collection<TransactionLogLifeline> getLifelines() {
        return this.lifelines.values();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return "LogFile: " + this.getFullName();
    }

    @Override
    public Object getChild(int index) {
        TransactionLogTransaction result = null;
        if (index > -1 && index < this.transactions.size()) {
            Iterator<TransactionLogTransaction> iterator = this.transactions.values().iterator();
            while (index-- > 0) {
                iterator.next();
            }
            result = iterator.next();
        }
        return result;
    }

    @Override
    public int getChildCount() {
        return this.transactions.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        int index = -1;
        Iterator<TransactionLogTransaction> iterator = this.transactions.values().iterator();
        int i = 0;
        while (index == -1 && iterator.hasNext()) {
            if (iterator.next().equals(child)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    @Override
    public boolean isLeaf() {
        return this.loaded && this.getChildCount() == 0;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void delete() {
        this.clear();
        FileUtilities.silentDeleteDirectory((File)this.home);
    }

    private void read(File logFile) throws IOException, IllegalArgumentException {
        this.read(new FileReader(logFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(ZipFile zippedLogFile) throws IOException, IllegalArgumentException {
        ZipEntry zipEntry = zippedLogFile.entries().nextElement();
        try {
            this.read(new InputStreamReader(zippedLogFile.getInputStream(zipEntry)));
        }
        finally {
            try {
                zippedLogFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(Reader reader) throws IOException, IllegalArgumentException {
        LineNumberReader lineReader = new LineNumberReader(reader);
        try {
            this.readAndCheckFirstLine(lineReader);
            TransactionLogEntry firstEntry = this.readLogEntry(lineReader);
            if (firstEntry != null) {
                this.start = this.end = firstEntry.getDate();
                while (this.readLogEntry(lineReader) != null) {
                }
                this.collectTransactions();
            }
        }
        finally {
            this.loaded = true;
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void readAndCheckFirstLine(LineNumberReader reader) throws IOException, IllegalArgumentException {
        this.version = Version.getVersion(reader.readLine());
    }

    private TransactionLogEntry readLogEntry(LineNumberReader reader) throws IOException {
        String line;
        TransactionLogEntry entry = null;
        while ((line = reader.readLine()) != null && line.isEmpty()) {
        }
        if (line != null) {
            try {
                entry = new TransactionLogEntry(this.version, line, reader.getLineNumber());
                TransactionLogRequest request = this.getRequest(entry);
                request.addEntry(entry);
            }
            catch (IllegalArgumentException e) {
                this.errors.add(e);
            }
        }
        return entry;
    }

    private TransactionLogRequest getRequest(TransactionLogEntry entry) {
        String fullRequestId = this.requestIdCounter.getFull(entry.getRequestId());
        TransactionLogRequest request = this.getRequest(fullRequestId);
        if (request == null) {
            request = new TransactionLogRequest(fullRequestId);
            this.addRequest(request);
        } else if (entry.isStartEntry() && request.isFinished()) {
            this.requestIdCounter.increment(entry.getRequestId());
            request = new TransactionLogRequest(this.requestIdCounter.getFull(entry.getRequestId()));
            this.addRequest(request);
        }
        return request;
    }

    private TransactionLogRequest getRequest(String id) {
        return this.requests.get(id);
    }

    private void addRequest(TransactionLogRequest request) {
        this.requests.put(request.getId(), request);
    }

    private void collectTransactions() {
        for (TransactionLogRequest request : this.requests.values()) {
            String transactionId = request.getTransactionId();
            TransactionLogTransaction transaction = this.transactions.get(transactionId);
            if (transaction == null) {
                transaction = new TransactionLogTransaction(transactionId);
                transaction.setParent(this);
                this.transactions.put(transactionId, transaction);
            }
            transaction.addRequest(request);
            this.process(request.getEntries());
        }
        for (TransactionLogTransaction transaction : this.transactions.values()) {
            List<Object> list;
            if (transaction.getRequests().size() > 1) {
                list = new ArrayList();
                for (TransactionLogRequest request : transaction.getRequests()) {
                    list.addAll(request.getEntries());
                }
                Collections.sort(list, new Comparator<TransactionLogEntry>(){

                    @Override
                    public int compare(TransactionLogEntry o1, TransactionLogEntry o2) {
                        return Integer.valueOf(o1.getLineNumber()).compareTo(o2.getLineNumber());
                    }
                });
            } else {
                list = transaction.getRequest(0).getEntries();
            }
            int i = 0;
            for (TransactionLogEntry transactionLogEntry : list) {
                transactionLogEntry.setIndex(i++);
            }
            transaction.setNumberOfLines(++i);
        }
    }

    private void process(List<? extends TransactionLogEntry> entries) {
        TransactionLogCall parent = null;
        for (TransactionLogEntry transactionLogEntry : entries) {
            TransactionLogLifeline lifeline;
            TransactionLogCall call;
            if (transactionLogEntry.isServiceEnter()) {
                call = new TransactionLogCall(transactionLogEntry);
                lifeline = this.getLifelineForCall(call);
                lifeline.addCall(call);
                parent = call;
                continue;
            }
            if (parent != null && transactionLogEntry.isServiceExit()) {
                parent.setReply(transactionLogEntry);
                parent = null;
                continue;
            }
            if (transactionLogEntry.isIOEnter()) {
                if (transactionLogEntry.isBackend()) {
                    call = new TransactionLogCall(transactionLogEntry);
                    if (parent != null) {
                        parent.addChild(call);
                        TransactionLogLifeline parentLifeline = parent.getLifeline();
                        if (parentLifeline != null) {
                            parentLifeline.addBackendCall(call);
                        }
                    }
                    lifeline = this.getLifelineForCall(call);
                    lifeline.addCall(call);
                    parent = call;
                    continue;
                }
                if (!transactionLogEntry.isPState() || !"Create".equalsIgnoreCase(transactionLogEntry.getParam_1())) continue;
                call = new TransactionLogCall(transactionLogEntry);
                if (parent != null) {
                    parent.addChild(call);
                }
                lifeline = this.getLifelineForCall(call);
                lifeline.addCall(call);
                parent = call;
                continue;
            }
            if (parent != null && transactionLogEntry.isIOExit()) {
                if (transactionLogEntry.isBackend()) {
                    parent.setReply(transactionLogEntry);
                    parent = parent.getParent();
                    continue;
                }
                if (!transactionLogEntry.isPState() || !"Create".equalsIgnoreCase(transactionLogEntry.getParam_1())) continue;
                parent.setReply(transactionLogEntry);
                parent = parent.getParent();
                continue;
            }
            if (transactionLogEntry.isTransitionEnter()) {
                call = new TransactionLogCall(transactionLogEntry);
                if (parent != null) {
                    parent.addChild(call);
                }
                if (parent == null) {
                    lifeline = this.getLifelineForCall(call);
                    lifeline.addCall(call);
                }
                parent = call;
                continue;
            }
            if (parent != null && transactionLogEntry.isTransitionExit()) {
                parent.setReply(transactionLogEntry);
                parent = parent.getParent();
                continue;
            }
            if (transactionLogEntry.isDoActionEnter()) {
                call = new TransactionLogCall(transactionLogEntry);
                if (parent != null) {
                    parent.addChild(call);
                }
                if (parent == null) {
                    lifeline = this.getLifelineForCall(call);
                    lifeline.addCall(call);
                }
                parent = call;
                continue;
            }
            if (parent == null || !transactionLogEntry.isDoActionExit()) continue;
            parent.setReply(transactionLogEntry);
            parent = parent.getParent();
        }
    }

    private TransactionLogLifeline getLifelineForCall(TransactionLogCall call) {
        String id = call.getLifelineId();
        TransactionLogLifeline lifeline = this.lifelines.get(id);
        if (lifeline == null) {
            lifeline = new TransactionLogLifeline(id, call.getLifelineName());
            this.lifelines.put(lifeline.getId(), lifeline);
        }
        return lifeline;
    }

    public URL getStatisticsFileUrl() {
        return this.statisticsFileUrl;
    }

    private void computeStatistics() {
        File file = new File(this.getTraceFolder(), "transaction.stats");
        if (!file.exists()) {
            this.getTraceFolder().mkdir();
            TransactionLogStatistics statistics = new TransactionLogStatistics(this);
            try {
                DomUtilities.serialize((File)new File(this.getTraceFolder(), "transaction.xml"), (Document)statistics.getDocument(), (boolean)true);
                DOMSource source = new DOMSource(statistics.getDocument());
                DOMResult result = new DOMResult();
                Transformer transformer = this.getTransformer();
                transformer.setErrorListener(new TransformerErrorListener());
                transformer.transform(source, result);
                DomUtilities.serialize((File)file, (Node)result.getNode(), (boolean)true);
            }
            catch (TransformerLoadException e) {
                logger.severe("Caught a " + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "", e);
            }
            catch (TransformerException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "", e);
            }
            catch (IOException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "", e);
            }
        }
        if (file.exists()) {
            try {
                this.statisticsFileUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                logger.throwing(this.getClass().getName(), "", e);
            }
        }
    }

    private Transformer getTransformer() throws TransformerLoadException {
        Transformer transformer = this.transformer;
        if (transformer == null) {
            transformer = transformerLoader.getTransformer(SCRIPT_TO_HTML);
            transformer.setErrorListener(new TransformerErrorListener());
            if (xmlPath == null) {
                this.transformer = transformer;
            }
        }
        return transformer;
    }

    public static enum Version {
        Version_0(12),
        Version_1(13);

        private static final String FIRST_LINE_2 = "Date\tTime\tTime Zone\tTransaction ID\tRequest ID\tComponent Name\tElapsed Time\tState\tDomain\tLog Type\tParameter 1\tParameter 2\tCorrelation ID";
        private static final String FIRST_LINE_1 = "Date\tTime\tTime Zone\tTransaction ID\tRequest ID\tComponent Name\tElapsed Time\tState\tDomain\tLog Type\tParameter 1\tParameter 2";
        private static final String FIRST_LINE_0 = "Date\tTime\tTimezone\tTransaction ID\tRequest ID\tComponent Name\tElapsed Time\tState\tDomain\tLog Type\tParameter 1\tParameter 2";
        private final int columns;

        private Version(int columns) {
            this.columns = columns;
        }

        public int getColumns() {
            return this.columns;
        }

        private static Version getVersion(String firstLine) {
            if (FIRST_LINE_2.equals(firstLine)) {
                return Version_1;
            }
            if (FIRST_LINE_1.equals(firstLine) || FIRST_LINE_0.equals(firstLine)) {
                return Version_0;
            }
            throw new IllegalStateException("Header line doesn't match. Maybe format of transaction log changed.\nShould be:\nDate\tTime\tTime Zone\tTransaction ID\tRequest ID\tComponent Name\tElapsed Time\tState\tDomain\tLog Type\tParameter 1\tParameter 2\tCorrelation ID");
        }
    }

    private static class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException e) {
            Logging.logger.warning(e.getMessageAndLocation());
            EventController.fire((EventObject)new SendWarningEvent((Object)this, e.getMessageAndLocation()));
        }

        @Override
        public void error(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessageAndLocation());
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getMessageAndLocation()));
        }

        @Override
        public void fatalError(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessageAndLocation());
            EventController.fire((EventObject)new SendFatalErrorEvent((Object)this, e.getMessageAndLocation()));
        }
    }

    private static class RequestIdCounter
    extends HashMap<String, Integer> {
        private RequestIdCounter() {
        }

        public Integer get(String key) {
            Integer counter = (Integer)super.get(key);
            if (counter == null) {
                counter = 1;
                this.put(key, counter);
            }
            return counter;
        }

        public String getFull(String key) {
            return key + "." + this.get(key);
        }

        public void increment(String key) {
            Integer counter = this.get(key) + 1;
            this.put(key, counter);
        }
    }
}

