/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.module;

import com.scheer.pas.module.Export;
import com.scheer.pas.module.Import;
import com.scheer.pas.module.Module;
import com.scheer.pas.module.RegisterContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModuleManager {
    private final Map<String, Object> features = new HashMap<String, Object>();
    private final RegisterContext registerContext = new RegisterContext(this.features);

    public void register(Module module) throws Exception {
        String key;
        Class<?> objectClass = Objects.requireNonNull(module).getClass();
        for (Field field : this.getAllDeclaredFields(objectClass)) {
            if (!field.isAnnotationPresent(Import.class)) continue;
            key = this.getFieldKey(field, field.getAnnotation(Import.class).key());
            field.setAccessible(true);
            if (!this.registerContext.featureExists(key).booleanValue()) continue;
            field.set(module, this.registerContext.getFeature(key));
        }
        module.register(this.registerContext);
        for (Field field : this.getAllDeclaredFields(objectClass)) {
            if (!field.isAnnotationPresent(Export.class)) continue;
            key = this.getFieldKey(field, field.getAnnotation(Export.class).key());
            field.setAccessible(true);
            this.registerContext.putFeature(key, field.get(module));
        }
    }

    public void register(Module[] modules) throws Exception {
        for (Module module : modules) {
            this.register(module);
        }
    }

    private String getFieldKey(Field field, String annotationKey) {
        return annotationKey.equals("") ? field.getName() + "-" + field.getType().getCanonicalName() : annotationKey;
    }

    private List<Field> getAllDeclaredFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(this.getAllDeclaredFields(type.getSuperclass()));
        }
        return fields;
    }
}

