/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.xuml.module.uml;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskSourceSetFactory;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class UmlTaskSourceSetFactory
extends TaskSourceSetFactory {
    @Override
    public Boolean select(String id) {
        return id.endsWith(Extensions._uml_compile);
    }

    @Override
    public Set<String> getBeforeSourceSet(SourceManager sourceManager) {
        HashSet<String> result = new HashSet<String>();
        result.add(Files.project_xml);
        return result;
    }

    @Override
    public Set<String> getSourceSet(SourceManager sourceManager) {
        HashSet<String> result = new HashSet<String>();
        XumlProject projectDocument = ((JsonDocumentSource)sourceManager.getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        result.add(Files.project_xml);
        result.add(Files.uml__PROJECTNAME_configuration_service_xml(projectDocument.getName()));
        result.add(Files.uml__PROJECTNAME_security_xml(projectDocument.getName()));
        result.add(Files.uml__xuml_base_xml);
        result.add(Files.uml__dataModel_xml);
        result.add(Files.uml__aliases_xml);
        result.addAll(LibrariesHelper.getLibrariesNameSet(sourceManager).stream().map(libName -> Folders.uml_imports_ + libName + Extensions._import_xml).collect(Collectors.toSet()));
        try {
            Path projectPath = sourceManager.getProjectFolder().toPath();
            sourceManager.getSourceFilesStream().filter(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR);
                return s.endsWith(Extensions._library_json) || s.endsWith(Extensions._bpmn_json) || s.endsWith(Extensions._module_json) || s.endsWith(Extensions._api_json) || s.endsWith(Extensions._jar);
            }).forEach(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR);
                if (s.endsWith(Extensions._library_json)) {
                    result.add(Folders.uml_imports_ + path.getFileName().toString().replace(Extensions._library_json, Extensions._import_xml));
                } else if (s.endsWith(Extensions._bpmn_json)) {
                    result.add(Folders.uml_imports_ + path.getFileName().toString().replace(Extensions._bpmn_json, Extensions._bpmn_import_xml));
                    result.add(Folders.uml_ + path.getFileName().toString().replace(Extensions._bpmn_json, Extensions._bpmn_implementation_xml));
                    result.add(Folders.uml_ + path.getFileName().toString().replace(Extensions._bpmn_json, Extensions._bpmn_service_xml));
                } else if (s.endsWith(Extensions._module_json) || s.endsWith(Extensions._api_json)) {
                    result.add(Folders.uml_ + path.getFileName().toString().replace(Extensions._json, Extensions._xml));
                } else if (s.endsWith(Extensions._jar)) {
                    result.add(Folders.uml_imports_ + path.getFileName().toString().replace(Extensions._jar, Extensions._import_jar));
                    result.add(Folders.uml_ + path.getFileName().toString() + Extensions._module_xml);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

