/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks.xuml;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.dev.module.tasks.xuml.DevXumlTask;
import java.io.File;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class DevXumlSendRepositoryTask
extends DevXumlTask {
    private static final String ACTION_PATH = "repository";
    private static final String REPOSITORY_BODY_PART_NAME = "repository";
    public static final String TASK_ID = "dev.xuml.send.repository";

    public static Boolean select(String id) {
        return id.equals(TASK_ID);
    }

    public DevXumlSendRepositoryTask(SourceManager sourceManager, String id, Client client) {
        super(sourceManager, id, client);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> sourceSet = super.getSourceSet();
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class);
        sourceSet.add(Files.uml__PROJECTNAME_dev_rep_uml_compile(projectDocument.getName()));
        sourceSet.add("dev.ensure.environment");
        return sourceSet;
    }

    @Override
    protected String getMethod() {
        return "PUT";
    }

    @Override
    protected String getActionPath() {
        return "repository";
    }

    @Override
    protected Entity<?> getEntity() {
        MultiPart multiPart = new FormDataMultiPart().bodyPart((BodyPart)new FileDataBodyPart("repository", this.getRepository()));
        return Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType());
    }

    private File getRepository() {
        String projectName = ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class).getName();
        return this.getSourceManager().getWorkFolder().toPath().resolve(Files.repository_PROJECTNAME_dev__PROJECTNAME_rep(projectName)).toFile();
    }

    @Override
    protected void handleResponse(Response response) {
        if (DevXumlSendRepositoryTask.requestFailed(response)) {
            Response.StatusType statusInfo = response.getStatusInfo();
            Logging.logger.warning(String.format("Sending repository to dev container failed: %d (%s)", statusInfo.getStatusCode(), statusInfo.getReasonPhrase()));
        }
        super.handleResponse(response);
    }

    private static boolean requestFailed(Response response) {
        int statusCode = response.getStatus();
        return statusCode != 200 && statusCode != 201 && statusCode != 204;
    }
}

