/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import com.scheer.pas.compiler.dev.api.DevStartEnvironment;
import com.scheer.pas.compiler.dev.api.artifacts.TestArtifactTypeService;
import com.scheer.pas.compiler.dev.module.tasks.DevStartEnvironmentTask;
import java.util.Set;

public class DevRefreshTestArtifactsTask
extends CacheAbleTask {
    public static final String TASK_ID = "dev.refresh.test.artifacts";
    private final TestArtifactTypeService testArtifactTypeService;

    public DevRefreshTestArtifactsTask(SourceManager sourceManager, String id, TestArtifactTypeService testArtifactTypeService) {
        super(sourceManager, id);
        this.testArtifactTypeService = testArtifactTypeService;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.add("dev.start.environment");
        this.testArtifactTypeService.getTypes().forEach(type -> result.addAll(type.getRefreshTestArtifactsTaskBeforeSourceSet(this.sourceManager)));
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        if (this.isDevStackAvailable()) {
            result.add("dev.xuml.send.repository");
            this.testArtifactTypeService.getTypes().forEach(type -> result.addAll(type.getRefreshTestArtifactsTaskSourceSet(this.sourceManager)));
        }
        return result;
    }

    private boolean isDevStackAvailable() {
        try {
            DevStartEnvironmentTask task = this.sourceManager.getSource("dev.start.environment", DevStartEnvironmentTask.class);
            DevStartEnvironment.Result result = task.getJsonDocument(DevStartEnvironment.Result.class);
            return result.getError() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class Factory
    extends TaskFactory {
        TestArtifactTypeService testArtifactTypeService;

        public Factory(TestArtifactTypeService testArtifactTypeService, Double priority) {
            super(priority);
            this.testArtifactTypeService = testArtifactTypeService;
        }

        @Override
        public Boolean matchId(String id) {
            return id.equals(DevRefreshTestArtifactsTask.TASK_ID);
        }

        @Override
        public CacheAbleTask createTask(String id, SourceManager sourceManager) {
            return new DevRefreshTestArtifactsTask(sourceManager, id, this.testArtifactTypeService);
        }
    }
}

