/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.dev.module.tasks;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.handler.TaskCreator;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SimpleTaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.utils.JaxbUtils;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.serviceRepository.ServiceRepositoryService;
import ch.e2e.builder.compiler.serviceRepository.stack.DevContainerResponse;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public abstract class DevEnvironmentTask
extends CacheAbleTask
implements JsonDocumentSource {
    protected final ServiceRepositoryService repositoryService;
    protected final Client client;
    protected JsonDocument jsonDocument;

    public DevEnvironmentTask(SourceManager sourceManager, String id, ServiceRepositoryService repositoryService, Client client) {
        super(sourceManager, id);
        this.repositoryService = repositoryService;
        this.client = client;
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            try {
                this.jsonDocument = (JsonDocument)JaxbUtils.unmarshalXml(this.getFile(), type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)this.jsonDocument;
    }

    public static class DevEnvironmentTaskFactory
    extends SimpleTaskFactory {
        private final ServiceRepositoryService repositoryService;
        private final Client client;

        public DevEnvironmentTaskFactory(Class<? extends DevEnvironmentTask> taskClass, ServiceRepositoryService repositoryService, Client client, Double priority) {
            super(taskClass, priority);
            this.repositoryService = repositoryService;
            this.client = client;
        }

        @Override
        protected TaskCreator getCreator(Class<? extends CacheAbleTask> taskClass) {
            return (sourceManager, id) -> {
                try {
                    Constructor<? extends CacheAbleTask> constructor = DevEnvironmentTaskFactory.getConstructor(taskClass, SourceManager.class, String.class, ServiceRepositoryService.class, Client.class);
                    return constructor == null ? null : constructor.newInstance(sourceManager, id, this.repositoryService, this.client);
                }
                catch (ReflectiveOperationException e) {
                    Logging.logger.warning(e.getMessage());
                    return null;
                }
            };
        }
    }

    protected static class HealthCheckResult {
        protected final boolean healthy;
        private final String message;

        public HealthCheckResult(DevContainerResponse devContainer, Exception e) {
            this(devContainer, e.getMessage());
        }

        public HealthCheckResult(DevContainerResponse devContainer, String message) {
            this(String.format("Development container '%s' could not be reached (%s)", devContainer.getHostname(), message));
        }

        public HealthCheckResult(Exception e) {
            this(e.getMessage());
        }

        public HealthCheckResult(String message) {
            this.message = message == null ? "" : message;
            this.healthy = this.message.isEmpty();
        }

        public HealthCheckResult() {
            this((String)null);
        }

        public String toString() {
            return this.message;
        }
    }

    protected static class HealthChecker {
        private final DevContainerResponse devContainer;
        private final Future<Response> future;

        public HealthChecker(DevContainerResponse devContainer, Client client) {
            this.devContainer = devContainer;
            this.future = client.target(UriBuilder.fromPath((String)"health").scheme("http").host(devContainer.getHostname()).port(devContainer.getPort())).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get();
        }

        public Response getResponse() throws ExecutionException, InterruptedException {
            return this.future.get();
        }

        public HealthCheckResult newHealthCheckResult(Exception e) {
            return new HealthCheckResult(this.devContainer, e);
        }

        public HealthCheckResult newHealthCheckResult(String message) {
            return new HealthCheckResult(this.devContainer, message);
        }
    }
}

