/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks.project;

import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import com.scheer.pas.compiler.angular.v13.constants.Files;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import com.scheer.pas.compiler.angular.v13.tasks.project.AbstractAngularSourcesTask;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class AngularSourcesTask
extends AbstractAngularSourcesTask {
    public static Boolean select(String id) {
        return id.equals(Files.appSources_file_list);
    }

    public AngularSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        try {
            this.sourceManager.getSourceFilesStream().map(path -> path.getFileName().toString()).filter(path -> path.endsWith(Extensions._bpmn_json)).map(path -> Files.bpmn__PROCESS_bpmn_xml(path.replace(Extensions._bpmn_json, ""))).forEach(result::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        String mainProjectName = this.getAngularProjectName();
        result.add(this.basePath_ + Files.angular__angular_json);
        result.add(this.basePath_ + Files.angular__dockerfile);
        result.add(this.basePath_ + Files.angular__gitignore);
        result.add(this.basePath_ + Files.angular__gitlab_ci_yml);
        result.add(this.basePath_ + Files.angular__npmrc);
        result.add(this.basePath_ + Files.angular__package_json);
        result.add(this.basePath_ + Files.angular__tsconfig_json);
        result.add(this.basePath_ + Files.angular__tslint_json);
        result.add(this.basePath_ + Files.angular__readme_md);
        result.add(this.basePath_ + Files.angular__config_local_json);
        result.add(this.basePath_ + Files.angular__config_default_json);
        String resourcePath = Folders.angular_projects_PROJECT(mainProjectName) + Folders.SEPARATOR;
        result.add(this.basePath_ + resourcePath + "src/app/components/process-list/process-list.component.html");
        result.add(this.basePath_ + resourcePath + "src/app/components/process-list/process-list.component.ts");
        result.add(this.basePath_ + resourcePath + "src/app/components/user/user.component.html");
        result.add(this.basePath_ + resourcePath + "src/app/components/user/user.component.scss");
        result.add(this.basePath_ + resourcePath + "src/app/components/user/user.component.theme.scss");
        result.add(this.basePath_ + resourcePath + "src/app/components/user/user.component.ts");
        result.add(this.basePath_ + resourcePath + "src/app/guards/security.guard.ts");
        result.add(this.basePath_ + resourcePath + "src/app/app.component.html");
        result.add(this.basePath_ + resourcePath + "src/app/app.component.ts");
        result.add(this.basePath_ + resourcePath + "src/app/app.module.ts");
        result.add(this.basePath_ + resourcePath + "src/app/app-config.ts");
        result.add(this.basePath_ + resourcePath + "src/app/material.module.ts");
        result.add(this.basePath_ + resourcePath + "src/assets/config/xuml.json5");
        result.add(this.basePath_ + resourcePath + "src/environments/environment.ts");
        result.add(this.basePath_ + resourcePath + "src/environments/procode.environment.ts");
        result.add(this.basePath_ + resourcePath + "src/environments/dev.environment.ts");
        result.add(this.basePath_ + resourcePath + "src/favicon.ico");
        result.add(this.basePath_ + resourcePath + "src/index.html");
        result.add(this.basePath_ + resourcePath + "src/main.ts");
        result.add(this.basePath_ + resourcePath + "src/polyfills.ts");
        result.add(this.basePath_ + resourcePath + "src/proxy.conf.js");
        result.add(this.basePath_ + resourcePath + "src/style.scss");
        result.add(this.basePath_ + resourcePath + "tsconfig.app.json");
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_forms__forms_module_ts(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app__app_routing_module_ts(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app__css_json(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app__libraries_module_ts(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_services__form_service_ts(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_services__security_service_ts(mainProjectName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_assets_i18n__LANGUAGE_json(mainProjectName, Files.de));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_assets_i18n__LANGUAGE_json(mainProjectName, Files.en));
        try {
            this.sourceManager.getSourceFilesStream().map(path -> path.getFileName().toString()).filter(path -> path.endsWith(Extensions._form_json) || path.endsWith(Extensions._bpmn_json)).forEach(path -> {
                if (path.endsWith(Extensions._form_json)) {
                    result.addAll(this.listFormSources(mainProjectName, path.replace(Extensions._form_json, "")));
                } else if (path.endsWith(Extensions._bpmn_json)) {
                    result.addAll(this.listProcessSources(mainProjectName, path.replace(Extensions._bpmn_json, "")));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Set<String> listFormSources(String projectName, String formName) {
        HashSet<String> result = new HashSet<String>();
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_forms_FORM__form_component_html(projectName, formName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_forms_FORM__form_component_ts(projectName, formName));
        return result;
    }

    private Set<String> listProcessSources(String projectName, String bpmnName) {
        HashSet<String> result = new HashSet<String>();
        JsonDocumentSource source = (JsonDocumentSource)this.getSource(Files.bpmn__PROCESS_bpmn_xml(bpmnName));
        BpmnDefinitions bpmnDefinitions = source.getJsonDocument(BpmnDefinitions.class);
        if (bpmnDefinitions != null && bpmnDefinitions.getProcess() != null) {
            bpmnDefinitions.getProcess().forEach(bpmnProcess -> {
                if (bpmnProcess.getUserTask() != null) {
                    bpmnProcess.getUserTask().forEach(bpmnUserTask -> {
                        if (bpmnUserTask.getExtensionElements() != null && bpmnUserTask.getExtensionElements().getForm() != null && bpmnUserTask.getExtensionElements().getForm().getForm() != null && !bpmnUserTask.getExtensionElements().getForm().getForm().equals("")) {
                            result.addAll(this.listTaskSources(projectName, bpmnName, bpmnUserTask.getName()));
                        }
                    });
                }
            });
        }
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_process_PROCESS__process_routing_module_ts(projectName, bpmnName));
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_services_security__PROCESS_bpmn_authorizations_json(projectName, bpmnName));
        String libPath = Folders.angular_projects_PROJECT_src_app_process_PROCESS(projectName, bpmnName) + Folders.SEPARATOR;
        result.add(this.basePath_ + libPath + "components/default/default.component.html");
        result.add(this.basePath_ + libPath + "components/default/default.component.ts");
        result.add(this.basePath_ + libPath + "components/instance/instance.component.html");
        result.add(this.basePath_ + libPath + "components/instance/instance.component.ts");
        result.add(this.basePath_ + libPath + "components/process/instanceList.ts");
        result.add(this.basePath_ + libPath + "components/process/process.component.html");
        result.add(this.basePath_ + libPath + "components/process/process.component.ts");
        result.add(this.basePath_ + libPath + "components/start/start.component.html");
        result.add(this.basePath_ + libPath + "components/start/start.component.ts");
        result.add(this.basePath_ + libPath + "components/select-task/select-task.component.html");
        result.add(this.basePath_ + libPath + "components/select-task/select-task.component.ts");
        result.add(this.basePath_ + libPath + "guards/instance.guard.ts");
        result.add(this.basePath_ + libPath + "guards/instance-list.guard.ts");
        result.add(this.basePath_ + libPath + "guards/task.guard.ts");
        result.add(this.basePath_ + libPath + "guards/select-task.guard.ts");
        result.add(this.basePath_ + libPath + "process.module.ts");
        return result;
    }

    private Set<String> listTaskSources(String projectName, String bpmnName, String taskName) {
        HashSet<String> result = new HashSet<String>();
        result.add(this.basePath_ + Files.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK__task_component_ts(projectName, bpmnName, taskName));
        String libPath = Folders.angular_projects_PROJECT_src_app_process_PROCESS_tasks_TASK(projectName, bpmnName, taskName) + Folders.SEPARATOR;
        result.add(this.basePath_ + libPath + "task.component.html");
        result.add(this.basePath_ + libPath + "task.module.ts");
        result.add(this.basePath_ + libPath + "task.routing.module.ts");
        return result;
    }
}

