/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks.clean;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.MultipleOutputsCacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.io.FileUtilities;
import com.scheer.pas.compiler.angular.v13.Angular13Helper;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Extensions;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AngularCleanWorkspaceTask
extends MultipleOutputsCacheAbleTask {
    private static final String EXTENSION_REGEX = "(\\..*)*";

    public AngularCleanWorkspaceTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return Extensions._clean;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(ch.e2e.builder.compiler.build.tasks.constants.Files.project_xml);
        return result;
    }

    protected String getProjectName() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(ch.e2e.builder.compiler.build.tasks.constants.Files.project_xml)).getJsonDocument(XumlProject.class).getName();
    }

    protected String getAngularProjectName() {
        if (this.isLib().booleanValue()) {
            return Angular13Helper.getAngularLibName(this.getProjectName());
        }
        return Angular13Helper.getMainProjectName(this.getProjectName());
    }

    protected Boolean isLib() {
        return this.getId().startsWith(AngularVersion.basePath_ + Folders.angularLib);
    }

    protected Set<String> getProjectDirectories() {
        return new HashSet<String>();
    }

    protected Set<String> getUpToDateProjects() throws Exception {
        return new HashSet<String>();
    }

    protected Set<String> getOutdatedFiles() throws Exception {
        return new HashSet<String>();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            Set<String> upToDateAngularProjects = this.getUpToDateProjects();
            for (String path : this.getProjectDirectories()) {
                Path projectDirectory = this.getSourceManager().getWorkFolder().toPath().resolve(path);
                if (!Files.exists(projectDirectory, new LinkOption[0]) || !Files.isDirectory(projectDirectory, new LinkOption[0])) break;
                this.cleanSubFolders(projectDirectory, upToDateAngularProjects);
            }
            this.cleanFiles();
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    private void cleanSubFolders(Path projectDirectory, Set<String> upToDateAngularProjects) throws Exception {
        Path workFolderPath = this.getSourceManager().getWorkFolder().toPath();
        Files.walk(projectDirectory, 1, new FileVisitOption[0]).filter(path -> {
            String id = workFolderPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), Folders.SEPARATOR);
            return !projectDirectory.equals(path) && upToDateAngularProjects.stream().noneMatch(upToDateAngularProjectId -> id.matches(upToDateAngularProjectId + EXTENSION_REGEX));
        }).map(Path::toFile).filter(File::isDirectory).forEach(file -> {
            try {
                FileUtilities.deleteDirectory((File)file);
            }
            catch (Exception e) {
                this.getErrorHandler().error((Throwable)e);
            }
        });
    }

    private void cleanFiles() throws Exception {
        this.getOutdatedFiles().stream().map(id -> new File(this.getSourceManager().getWorkFolder(), (String)id)).filter(file -> file.exists() && file.isFile()).forEach(File::delete);
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    @Override
    protected Set<String> getDestinationFiles() {
        try {
            return this.getUpToDateProjects();
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
            return Collections.emptySet();
        }
    }
}

