/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks;

import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import com.scheer.pas.compiler.angular.core.tasks.AngularZipTask;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Extensions;
import com.scheer.pas.compiler.angular.v13.constants.Files;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;

public class AngularZipSourcesTask
extends AngularZipTask {
    private static final String[] EXTENSIONS_TO_FILTER_OUT = new String[]{Extensions._hash, ".errors", Extensions._sources, Extensions._npm, Extensions._file_list, Extensions._clean, Extensions._ts_xml, Extensions._html_xml, Extensions._json_xml, Extensions._log_txt};

    public static Boolean select(String id) {
        return id.equals(Files.appSources_zip) || id.equals(Files.libSources_zip);
    }

    public AngularZipSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Path[] getInputFolderPaths() {
        if (this.getId().equals(Files.libSources_zip)) {
            return new Path[]{this.getSourceManager().getWorkFolder().toPath().resolve(AngularVersion.basePath_ + Folders.angularLib)};
        }
        return new Path[]{this.getSourceManager().getWorkFolder().toPath().resolve(AngularVersion.basePath_ + Folders.angular)};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        Path basePath = this.getInputFolderPaths()[0];
        if (!super.doFilter(path)) return false;
        if (path.startsWith(basePath.resolve(Folders.node_modules))) return false;
        if (path.startsWith(basePath.resolve(Folders.dot_angular))) return false;
        if (path.startsWith(basePath.resolve(Folders.dist))) return false;
        if (!Stream.of(EXTENSIONS_TO_FILTER_OUT).noneMatch(path.getFileName().toString()::endsWith)) return false;
        return true;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(this.getDestinationFilePathWithoutExtension() + Extensions._file_list);
        return result;
    }
}

