/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.angular.core.AngularHelper;
import com.scheer.pas.compiler.angular.v13.Angular13Helper;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.util.Map;
import java.util.Set;

public abstract class AngularXsltTask
extends XSLTTask {
    public AngularXsltTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(Files.project_xml);
        return result;
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> parameters = super.getTransformParameters();
        parameters.put("angularLib", this.isLib());
        parameters.put("angular_project_name", this.getAngularProjectName());
        parameters.put("angular_project_src_lib_path", this.getSourceLibPath());
        parameters.put("destination_in_angular_project_src_lib_path", this.getDestinationInSourceLibPath());
        parameters.put("angular_base_path", AngularVersion.basePath_);
        return parameters;
    }

    protected Boolean isLib() {
        return this.getId().startsWith(AngularVersion.basePath_ + Folders.angularLib);
    }

    protected String getProjectName() {
        return ((JsonDocumentSource)this.getSourceManager().getSource(Files.project_xml)).getJsonDocument(XumlProject.class).getName();
    }

    protected String getAngularProjectName() {
        if (this.isLib().booleanValue()) {
            return AngularHelper.getAngularLibName(this.getProjectName());
        }
        return Angular13Helper.getMainProjectName(this.getProjectName());
    }

    protected String getSourceLibPath() {
        if (this.isLib().booleanValue()) {
            return Folders.angularLib_projects_PROJECT__src_lib(Angular13Helper.getAngularLibName(this.getProjectName()));
        }
        return Folders.angular_projects_PROJECT_src_app(Angular13Helper.getMainProjectName(this.getProjectName()));
    }

    protected String getDestinationInSourceLibPath() {
        try {
            return this.getDestinationFolder().substring(AngularVersion.basePath_.length() + this.getSourceLibPath().length() + 1);
        }
        catch (Exception e) {
            return "";
        }
    }
}

