/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.v13.tasks;

import ch.e2e.builder.compiler.build.tasks.model.SubstitutionTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnUserTask;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.utils.EnvUtils;
import ch.e2e.builder.compiler.utils.StringUtils;
import com.scheer.pas.compiler.angular.v13.Angular13Helper;
import com.scheer.pas.compiler.angular.v13.AngularVersion;
import com.scheer.pas.compiler.angular.v13.constants.Extensions;
import com.scheer.pas.compiler.angular.v13.constants.Files;
import com.scheer.pas.compiler.angular.v13.constants.Folders;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AngularSubstitutionFromBase
extends SubstitutionTask {
    private static final Boolean XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR", true);
    private static final Boolean XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR", true);
    private static final String XUML_SERVICES_BRIDGE_PATH = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_BRIDGE_PATH", "cust/service");
    private static final String XUML_SERVICES_CONTAINER_PATH = EnvUtils.get("XUML_COMPILER_SERVICE_XUML_SERVICES_CONTAINER_PATH", "xuml");
    private static final String XUML_APP_KEYCLOAK_CLIENT_ID = EnvUtils.get("XUML_COMPILER_XUML_APP_KEYCLOAK_CLIENT_ID", "authenticator-service");
    private static final String NPMRC_EXTRA_OPTIONS = EnvUtils.get("NPMRC_EXTRA_OPTIONS", "").replace(",", "/n");

    public static Boolean select(String id) {
        return id.startsWith(Folders.angular_) && (id.endsWith(Files.ngPackage_json) || id.endsWith(Files.package_json) || id.endsWith(Files.angular_json) || id.endsWith(Files.index_html) || id.endsWith(Extensions._component_ts) || id.endsWith(Files.publicApi_ts) || id.endsWith(Files.proxy_conf_json) || id.endsWith(Files.Dockerfile) || id.endsWith(Files.readme_md) || id.endsWith(Files._npmrc) || id.endsWith(Files.environment_ts)) || id.startsWith(Folders.angularLib_) && (id.endsWith(Files.angular_json) || id.endsWith(Files.ngPackage_json) || id.endsWith(Files.package_json) || id.endsWith(Files.tsconfig_json) || id.endsWith(Files.readme_md) || id.endsWith(Files._npmrc));
    }

    public AngularSubstitutionFromBase(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getSourceId() {
        return Angular13Helper.getBaseResourceId(this.getId());
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.getSourceId());
        set.add(Files.project_xml);
        String moduleName = this.getModuleName();
        String intermediateName = this.getIntermediateName();
        if (!moduleName.equals("") && !intermediateName.equals("")) {
            set.add(Files.bpmn_PROCESS__TASK_userTask_bpmnPart_xml(intermediateName, moduleName));
        }
        return set;
    }

    String getAngularProjectName() {
        return Angular13Helper.extractAngularProjectName(this.getId());
    }

    String getIntermediateName() {
        return Angular13Helper.extractIntermediateName(this.getAngularProjectName());
    }

    String getModuleName() {
        return Angular13Helper.extractModuleName(this.getAngularProjectName());
    }

    String getFormName() {
        JsonDocumentSource source = (JsonDocumentSource)this.getSource(Files.bpmn_PROCESS__TASK_userTask_bpmnPart_xml(this.getIntermediateName(), this.getModuleName()));
        BpmnUserTask userTask = source.getJsonDocument(BpmnUserTask.class);
        if (userTask.getExtensionElements() != null && userTask.getExtensionElements().getForm() != null) {
            String formName = userTask.getExtensionElements().getForm().getForm();
            return StringUtils.substringBetween(formName, Folders.SEPARATOR, Extensions._form_json + "#");
        }
        return "";
    }

    @Override
    protected Map<String, String> getSubstitutions() {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        JsonDocumentSource source = (JsonDocumentSource)this.getSource(Files.project_xml);
        XumlProject projectDocument = source.getJsonDocument(XumlProject.class);
        String projectName = projectDocument.getName();
        String intermediateName = this.getIntermediateName();
        String moduleName = this.getModuleName();
        substitutions.put("placeholder.system.endpoint", EnvUtils.get("SYSTEM_ENDPOINT", "vagrantguest"));
        substitutions.put("placeholder.system.prefix", EnvUtils.get("SYSTEM_PREFIX", "pas"));
        substitutions.put("placeholder.gitlab.access.token", EnvUtils.get("GITLAB_ACCESS_TOKEN", ""));
        substitutions.put("placeholder.project.name", projectName);
        substitutions.put("placeholder.project.designer.project.id", projectDocument.getProjectId());
        substitutions.put("placeholder.project.designer.profile.id", projectDocument.getProfileId());
        substitutions.put("placeholder.project.base.href", projectDocument.getDeploymentType().equals("bridge") && projectDocument.getProxyPort() != null && projectDocument.getProxyPort() != 0 ? "/" + projectName : "");
        substitutions.put("placeholder.project.version", projectDocument.getVersion());
        substitutions.put("placeholder.project.proxyPort", projectDocument.getProxyPort() != null && projectDocument.getProxyPort() != 0 ? projectDocument.getProxyPort().toString() : "");
        substitutions.put("placeholder.project.servicePort", projectDocument.getServicePort() != null && projectDocument.getServicePort() != 0 ? projectDocument.getServicePort().toString() : "");
        substitutions.put("placeholder.project.xuml.service.path", projectDocument.getDeploymentType().equals("bridge") ? XUML_SERVICES_BRIDGE_PATH + "/" + projectName : XUML_SERVICES_CONTAINER_PATH + "/" + projectDocument.getHostname());
        substitutions.put("placeholder.project.xuml.service.dev.path", projectDocument.getDeploymentType().equals("bridge") ? "../../../xuml" : "../../xuml");
        substitutions.put("placeholder.project.xuml.service.is.authenticator", (projectDocument.getDeploymentType().equals("bridge") ? XUML_SERVICES_BRIDGE_IS_AUTHENTICATOR : XUML_SERVICES_CONTAINER_IS_AUTHENTICATOR) != false ? "true" : "false");
        substitutions.put("placeholder.project.app.keycloak.clientId", XUML_APP_KEYCLOAK_CLIENT_ID);
        substitutions.put("placeholder.angular.main.project.name", Angular13Helper.getMainProjectName(projectName));
        substitutions.put("placeholder.angular.library.project.name", Angular13Helper.getLibraryProjectName(projectName));
        if (!moduleName.equals("")) {
            substitutions.put("placeholder.angular.module.name", moduleName);
            substitutions.put("placeholder.angular.form.project.name", Angular13Helper.getFormProjectName(projectName, moduleName));
            if (!intermediateName.equals("")) {
                substitutions.put("placeholder.angular.form-dependency.project.name", Angular13Helper.getFormProjectName(projectName, this.getFormName()));
                substitutions.put("placeholder.angular.process.project.name", Angular13Helper.getProcessProjectName(projectName, intermediateName));
                substitutions.put("placeholder.angular.task.project.name", Angular13Helper.getTaskProjectName(projectName, intermediateName, moduleName));
            } else {
                substitutions.put("placeholder.angular.process.project.name", Angular13Helper.getProcessProjectName(projectName, moduleName));
            }
        }
        if (this.getId().startsWith(AngularVersion.basePath_ + Folders.angularLib_)) {
            substitutions.put("placeholder.angular-lib.project.name", Angular13Helper.getAngularLibName(projectDocument.getName()));
        }
        substitutions.put("placeholder.npmrc.extra.options", NPMRC_EXTRA_OPTIONS);
        return substitutions;
    }
}

