/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.core;

import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import com.scheer.pas.compiler.angular.core.constants.Extensions;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AngularHelper {
    public static final String NAME_DELIMITER = "-";
    public static final String LIBRARY_PROJECT_SUFFIX = "-library";

    public static String getAngularProjecName(String projectName) {
        return projectName.replaceAll("[- ]{1}", "_");
    }

    public static String getLibraryProjectName(String projectName) {
        return AngularHelper.getAngularProjecName(projectName) + LIBRARY_PROJECT_SUFFIX;
    }

    public static String getAngularLibName(String projectName) {
        return AngularHelper.convert2KebabCase(projectName.replaceAll("[ ]{1}", NAME_DELIMITER));
    }

    public static String getAngularLibArchiveName(XumlProject project) {
        return AngularHelper.getAngularLibName(project.getName()) + NAME_DELIMITER + project.getVersion() + Extensions._tgz;
    }

    public static String convert2KebabCase(String input) {
        Matcher matcher = Pattern.compile("[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+").matcher(input);
        ArrayList<String> matched = new ArrayList<String>();
        while (matcher.find()) {
            matched.add(matcher.group(0));
        }
        return matched.stream().map(String::toLowerCase).collect(Collectors.joining(NAME_DELIMITER));
    }

    public static String convert2CamelCase(String s) {
        String[] parts = s.split("\\s|-");
        StringBuilder camelCaseString = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            String firstLetter = part.substring(0, 1).toUpperCase();
            String restLetters = part.substring(1).toLowerCase();
            camelCaseString.append(firstLetter).append(restLetters);
        }
        return camelCaseString.toString();
    }
}

