/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.pas.compiler.angular.base.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.constants.Extensions;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import com.scheer.pas.compiler.angular.base.tasks.AngularCopyVersionTask;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;

public class AngularDistZipTask
extends AngularCopyVersionTask {
    public static Boolean select(String id) {
        return id.equals(com.scheer.pas.compiler.angular.core.constants.Files.angular__appDist_zip);
    }

    public AngularDistZipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected InputStream getDummyMainZipInputStream() throws IOException {
        Source inputStreamSource = this.getSourceManager().getSource(CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + com.scheer.pas.compiler.angular.core.constants.Files.angular__emptyDist_zip);
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }

    protected boolean isExplicitAngularApp() {
        Path projectPath = this.getSourceManager().getProjectFolder().toPath();
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource(com.scheer.pas.compiler.angular.core.constants.Files.project_xml)).getJsonDocument(XumlProject.class);
        try {
            if (projectDocument.getApplication().getGenerateApplication().equalsIgnoreCase("always") || projectDocument.getApplication().getGenerateApplication().equalsIgnoreCase("ifforms") && AngularDistZipTask.containsForms(projectPath)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean containsForms(Path projectPath) throws IOException {
        try (Stream<Path> paths = Files.walk(projectPath, new FileVisitOption[0]);){
            boolean bl = paths.anyMatch(path -> path.toString().endsWith(Extensions._form_json));
            return bl;
        }
    }

    @Override
    protected AbstractErrorHandler executeDependsOnTasks(int dependencyLevel) {
        if (this.isExplicitAngularApp()) {
            return super.executeDependsOnTasks(dependencyLevel);
        }
        this.executeTask(dependencyLevel);
        return this.getErrorHandler();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        if (this.isExplicitAngularApp()) {
            super.executeTask(dependencyLevel);
        } else {
            try (InputStream input = this.getDummyMainZipInputStream();){
                this.writeToDestinationFile(input);
            }
            catch (Exception e) {
                this.getErrorHandler().error((Throwable)e);
            }
        }
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(com.scheer.pas.compiler.angular.core.constants.Files.project_xml);
        return result;
    }
}

