/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeParameterDefinition;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Helpers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class StereotypeFactory {
    public static final String CONSTRAINT_STEREOTYPES = "stereotypes";
    public static final String CONSTRAINT_SCOPE = "scope";
    public static final String STEREOTYPE_FACTORY_KEY = "ch.e2e.builder.compiler.uml.stereotype.factory";
    public static final String CUSTOMIZATON_TARGET = "customizationTarget";
    public static final String DEPLOYMENT_TYPE = "deploymentType";
    public static final String SUPPLIER_TYPE = "supplierType";
    public static final String NODE_TYPE = "nodeType";
    public static final String PACKAGE_BRIDGE_PROFILE_LIBRARY = "E2E Bridge Profile/Basic Structure/Library";
    public static final String PACKAGE_BRIDGE_PROFILE_REST = "E2E Bridge Profile/Add Ons/REST";
    public static final String PACKAGE_BRIDGE_PROFILE_BASIC_STRUCTURE = "E2E Bridge Profile/Basic Structure";
    private HashMap<String, BridgeStereotype> stereotypes = new HashMap();
    private HashMap<String, ArrayList<BridgeStereotype>> stereotypeLists = new HashMap();
    private Helpers helpers;

    protected Helpers getHelpers() {
        return this.helpers;
    }

    protected StereotypeFactory(Helpers helpers) {
        this.helpers = helpers;
    }

    public void reset() {
        this.stereotypes.clear();
        for (List list : this.stereotypeLists.values()) {
            list.clear();
        }
        this.stereotypeLists.clear();
    }

    public BridgeStereotype getStereotype(String key, String generalizationKey) {
        BridgeStereotype generalization = this.getStereotype(generalizationKey);
        Iterator<BridgeStereotype> it = this.getStereotypes(generalization).iterator();
        BridgeStereotype stereotype = null;
        while (stereotype == null && it.hasNext()) {
            BridgeStereotype s = it.next();
            if (!s.getName().equals(key)) continue;
            stereotype = s;
        }
        return stereotype;
    }

    public BridgeStereotype getStereotype(String key) {
        BridgeStereotype stereotype = this.stereotypes.get(key);
        if (stereotype == null && (stereotype = this.createStereotype(key)) != null) {
            this.addStereotype(stereotype);
            this.getHelpers().getPackagesFactory().setStereotypePackage(stereotype);
        }
        return stereotype;
    }

    public final List<BridgeStereotype> getStereotypes(BridgeStereotype generalization) {
        ArrayList<BridgeStereotype> stereotypes = this.stereotypeLists.get(generalization.getName());
        if (stereotypes == null) {
            stereotypes = this.createStereotypeList(generalization);
            for (BridgeStereotype stereotype : stereotypes) {
                this.addStereotype(stereotype);
            }
            this.stereotypeLists.put(generalization.getName(), stereotypes);
        }
        return stereotypes;
    }

    public BridgeStereotype getDependency(String key) {
        BridgeStereotype stereotype = this.stereotypes.get(key);
        if (stereotype == null && (stereotype = this.createDependency(key)) != null) {
            this.addStereotype(stereotype);
        }
        return stereotype;
    }

    public void addStereotype(BridgeStereotype stereotype) {
        this.stereotypes.put(stereotype.getName(), stereotype);
    }

    public boolean isDefined(String key) {
        return this.stereotypes.containsKey(key);
    }

    public abstract BridgeStereotype findClassifierType(BridgeStereotype var1);

    protected abstract BridgeStereotype createStereotype(String var1);

    public abstract BridgeParameterDefinition createParameterDefinition(BridgeAttribute var1);

    protected abstract ArrayList<BridgeStereotype> createStereotypeList(BridgeStereotype var1);

    protected abstract BridgeStereotype createDependency(String var1);

    HashMap<String, BridgeStereotype> getStereotypes() {
        return this.stereotypes;
    }
}

