/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.NullValue;
import java.util.ArrayList;
import java.util.HashMap;

public class PropertyCustomization<T> {
    private HashMap<String, ArrayList<?>> propertyEditables = new HashMap();
    private HashMap<String, HashMap<?, T>> propertyDefaults = new HashMap();
    private HashMap<String, ArrayList<?>> propertyIgnores = new HashMap();
    private ArrayList<String> dependencies = new ArrayList();

    public <U> void addPropertyEditable(String dependency, U dependencyValue) {
        ArrayList<Object> dependencies = this.propertyEditables.get(dependency);
        if (dependencies == null) {
            dependencies = new ArrayList();
            this.propertyEditables.put(dependency, dependencies);
        }
        dependencies.add(dependencyValue);
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public <U> boolean isPropertyEditable(String dependency, U value) {
        ArrayList<?> dependencies = this.propertyEditables.get(dependency);
        return (dependencies == null || dependencies.contains(value)) && !this.isPropertyIgnored(dependency, value);
    }

    public <U> void addPropertyDefault(String dependency, U dependencyValue, T value) {
        HashMap<Object, Object> defaults = this.propertyDefaults.get(dependency);
        if (defaults == null) {
            defaults = new HashMap();
            this.propertyDefaults.put(dependency, defaults);
        }
        defaults.put(dependencyValue, value);
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public <U> T getDefaultValue(String dependency, U dependencyValue) {
        HashMap<?, T> defaults = this.propertyDefaults.get(dependency);
        return defaults == null ? null : (T)defaults.get(dependencyValue);
    }

    public <U> void addPropertyIgnore(String dependency, U dependencyValue) {
        ArrayList<Object> dependencies = this.propertyIgnores.get(dependency);
        if (dependencies == null) {
            dependencies = new ArrayList();
            this.propertyIgnores.put(dependency, dependencies);
        }
        dependencies.add(dependencyValue);
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public void setPropertyIgnoreValues(String dependency, ArrayList<Object> ignoreValues) {
        this.propertyIgnores.put(dependency, ignoreValues);
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public boolean isPropertyIgnored(String dependency, Object dependencyValue) {
        ArrayList<?> dependencies = this.propertyIgnores.get(dependency);
        return dependencies != null && (dependencies.size() == 0 && dependencyValue != null && !(dependencyValue instanceof NullValue) || dependencies.contains(dependencyValue));
    }

    public ArrayList<String> getDependencies() {
        return this.dependencies;
    }
}

