/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeConstraint;
import ch.e2e.builder.compiler.uml.BridgeParameterDefinition;
import ch.e2e.builder.compiler.uml.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OperationDefinition
implements Cloneable {
    private Name name;
    private List<BridgeParameterDefinition> paramDefinitions;
    private BridgeAttribute returnType;
    private BridgeConstraint constraint;

    public OperationDefinition(Name name) {
        this.name = name;
    }

    public OperationDefinition(Name name, List<BridgeParameterDefinition> parameters) {
        this.name = name;
        this.paramDefinitions = parameters;
    }

    public OperationDefinition(Name name, List<BridgeParameterDefinition> parameters, BridgeConstraint constraint) {
        this(name, parameters);
        this.constraint = constraint;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public BridgeAttribute getReturnType() {
        return this.returnType;
    }

    public void setReturnType(BridgeAttribute returnType) {
        this.returnType = returnType;
    }

    public List<BridgeParameterDefinition> getParamDefinitions() {
        return this.paramDefinitions == null ? Collections.emptyList() : this.paramDefinitions;
    }

    public void setParamDefinitions(List<BridgeParameterDefinition> paramDefinitions) {
        this.paramDefinitions = paramDefinitions;
    }

    public List<BridgeParameterDefinition> getInputParamDefinitions() {
        ArrayList<BridgeParameterDefinition> params = new ArrayList<BridgeParameterDefinition>();
        for (BridgeParameterDefinition p : this.paramDefinitions) {
            if (!p.isInputParameter()) continue;
            params.add(p);
        }
        return params;
    }

    public List<BridgeParameterDefinition> getOutputParamDefinitions() {
        ArrayList<BridgeParameterDefinition> params = new ArrayList<BridgeParameterDefinition>();
        for (BridgeParameterDefinition p : this.paramDefinitions) {
            if (!p.isOutputParameter()) continue;
            params.add(p);
        }
        return params;
    }

    public String toString() {
        return this.name.getDefault();
    }

    public Object getConstraint() {
        return this.constraint;
    }

    public void setConstraint(BridgeConstraint constraint) {
        this.constraint = constraint;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

