/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.base.tools.XmiIDFactory;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.ComponentTemplate;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Template;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.uml.UmlProperties;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeploymentTemplate
extends DeploymentElement
implements Template {
    private BridgeStereotype stereotype;

    public DeploymentTemplate(String name, Comment description, BridgeStereotype stereotype, Helpers helpers) {
        super(name, description, stereotype, helpers);
        this.stereotype = stereotype;
        this.addStereotype(this.getTemplateStereotype());
    }

    protected BridgeStereotype getTemplateStereotype() {
        return this.getHelpers().getStereotypeFactory().getStereotype("E2EArtifactTemplate");
    }

    @Override
    public BridgeStereotype getStereotype() {
        return this.stereotype == null ? super.getStereotype() : this.stereotype;
    }

    @Override
    public void setStereotype(BridgeStereotype stereotype) {
        super.setStereotype(this.stereotype == null ? stereotype : this.stereotype);
    }

    @Override
    public void addDependency(BridgeDependency bridgeDependency) {
    }

    public boolean isDeploymentElementTemplate() {
        return this.getClassifier() != null;
    }

    @Override
    public Element toChildXMI(Document ownerDocument, XmiIDFactory xmiIDFactory) {
        Element childXMI;
        if (this.getStereotype().getDefaultBaseclass().equals("Artifact")) {
            childXMI = this.createNestedArtifactChild(ownerDocument, xmiIDFactory);
            this.addClassifierDependency(ownerDocument, childXMI, xmiIDFactory);
        } else {
            childXMI = super.toChildXMI(ownerDocument, xmiIDFactory);
        }
        return childXMI;
    }

    @Override
    public BridgeStereotype getChildBridgeStereotype(String stereotype) {
        BridgeStereotype result = null;
        if (this.getStereotype().getDefaultBaseclass().equals("Artifact")) {
            ArrayList<BridgeStereotype> children = this.getStereotype().getCustomization().getChildren();
            int length = children.size();
            for (int i = 0; i < length && result == null; ++i) {
                BridgeStereotype bridgeStereotype = children.get(i);
                if (bridgeStereotype.getDeploymentType() == null || !bridgeStereotype.getDeploymentType().getName().equals(stereotype)) continue;
                result = bridgeStereotype.getDeploymentType();
            }
        } else {
            result = super.getChildBridgeStereotype(stereotype);
        }
        return result;
    }

    @Override
    public UmlElement toUmlElement() {
        return this.toUmlElement(null);
    }

    public UmlElement toUmlElement(DeploymentElement parent) {
        DeploymentElement result = this.createUmlElement(parent);
        result.setParent(parent);
        for (BridgeStereotype stereotype : this.getStereotypes()) {
            result.setProperties((UmlProperties)this.getProperties(stereotype).clone(), stereotype);
        }
        for (UmlElement child : this.getChildren()) {
            if (child instanceof DeploymentTemplate) {
                result.addChild(((DeploymentTemplate)child).toUmlElement(result));
                continue;
            }
            result.addChild(child.clone());
        }
        result.setTemplate(this);
        return result;
    }

    public UmlElement toInheritedUmlElement() {
        DeploymentElement result = this.createUmlElement(null);
        result.setParent(null);
        for (UmlElement child : this.getChildren()) {
            if (child instanceof DeploymentTemplate) {
                result.addChild(((DeploymentTemplate)child).toInheritedUmlElement());
                continue;
            }
            result.addChild(child.clone());
        }
        result.setTemplate(this);
        result.addGeneral(new Generalization(this, result, this.getHelpers()));
        return result;
    }

    private DeploymentElement createUmlElement(DeploymentElement parent) {
        DeploymentElement result;
        if (this.getStereotype().getName().equals("E2EBridgeServerInstance") || this.getStereotype().getName().equals("BackendServerInstance") || this.getStereotype().getName().equals("E2EProxyServerInstance")) {
            result = new BridgeNodeInstance(this.getName(), this.getDescription(), this.getClassifier(), this.getHelpers());
        } else {
            ClassifierElement classifier = null;
            if (this.getClassifier() instanceof ComponentTemplate) {
                if (parent != null && parent.getClassifier() != null) {
                    classifier = parent.getClassifier().findChildOfType((ComponentTemplate)this.getClassifier());
                }
                if (classifier == null) {
                    classifier = (ClassifierElement)((ComponentTemplate)this.getClassifier()).toUmlElement();
                }
            } else {
                classifier = this.getClassifier();
            }
            result = classifier == null ? new DeploymentElement(this.getName(), new Comment(this.getStereotype().getCustomization().getElementDescription().getDefault(), this.getHelpers()), this.getHelpers()) : new DeploymentElement(this.getName(), new Comment(this.getStereotype().getCustomization().getElementDescription().getDefault(), this.getHelpers()), classifier, this.getHelpers());
            for (BridgeStereotype stereotype : this.getStereotypes()) {
                if (stereotype.getName().equals(this.getTemplateStereotype().getName())) continue;
                result.addStereotype(stereotype);
            }
        }
        return result;
    }
}

