/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.uml;

import ch.e2e.builder.compiler.document.importer.ExtensionElement;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeDependency;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.ClassifierElement;
import ch.e2e.builder.compiler.uml.DependencyList;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.ModelPackage;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.NullValue;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.PropertyDefinition;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.dom.DomUtilities;
import ch.e2e.util.StringTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataModel {
    private ModelPackage model;
    private HashMap<BridgeStereotype, ArrayList<UmlElement>> usedStereotypes;
    private ArrayList<String> addedElements = new ArrayList();
    private ArrayList<Module> modules = new ArrayList();
    private ArrayList<String> moduleNames = new ArrayList();
    private Module module;
    private ArrayList<String> extendedShares = new ArrayList();
    private List<BridgePackage> sharedPackages;
    private String modelID;
    private String name;
    private Boolean nameBasedOperationSyntax = false;
    private Helpers helpers;
    Map<String, Object> extensionParameters = new HashMap<String, Object>();

    public void putExtensionParameter(String name, Object value) {
        this.extensionParameters.put(name, value);
    }

    public DataModel(String idPrefix, Helpers helpers) {
        this(idPrefix, helpers.getPackagesFactory().createRootPackage(), helpers);
    }

    public DataModel(String name, String idPrefix, Helpers helpers) {
        this(name, idPrefix, helpers.getPackagesFactory().createRootPackage(), helpers);
    }

    public DataModel(String idPrefix, BridgePackage root, Helpers helpers) {
        this(null, idPrefix, root, helpers);
    }

    public DataModel(String name, String idPrefix, BridgePackage root, Helpers helpers) {
        this.helpers = helpers;
        this.name = name;
        this.modelID = idPrefix + name + '_' + name.hashCode();
        this.model = new ModelPackage(root);
        this.usedStereotypes = new HashMap();
        this.sharedPackages = new ArrayList<BridgePackage>();
    }

    protected Helpers getHelpers() {
        return this.helpers;
    }

    public Boolean isNamedBasedOperationSyntax() {
        return this.nameBasedOperationSyntax;
    }

    public void setNamedBasedOperationSyntax(Boolean nameBasedOperationSyntax) {
        this.nameBasedOperationSyntax = nameBasedOperationSyntax;
    }

    public String getName() {
        return this.name;
    }

    public String getModelId() {
        return this.modelID;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
        this.addModule(module);
    }

    public ArrayList<Module> getModules() {
        return this.modules;
    }

    public boolean containsElement(String xmiId) {
        return this.addedElements.contains(xmiId);
    }

    public void addElement(UmlElement umlElement) {
        if (umlElement instanceof BridgeOperation) {
            ((BridgeOperation)umlElement).setNamedBasedOperationSyntax(this.nameBasedOperationSyntax);
        }
        if (!this.addedElements.contains(umlElement.getXmiID()) && this.checkModule(umlElement.getModule())) {
            this.addedElements.add(umlElement.getXmiID());
            ModelPackage owningPackage = this.findOwningPackage(umlElement);
            this.addModule(umlElement.getModule());
            if (owningPackage != null) {
                owningPackage.addUmlElement(umlElement);
                umlElement.setOwningPackage(owningPackage.getOrigin());
            }
            this.addStereotypeElement(umlElement);
            this.addChildren(umlElement);
        }
    }

    public void addSharedPackage(BridgePackage sharedPackage) {
        this.sharedPackages.add(sharedPackage);
        if (this.module != null) {
            this.module.addMountPointId(sharedPackage.getXmiID());
        }
    }

    public List<BridgePackage> getSharedPackages() {
        return this.sharedPackages;
    }

    public Document createDocument() {
        Document document = DomUtilities.newDocument((String)"XMITransformationModel");
        document.getDocumentElement().setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", this.getModelId());
        document.getDocumentElement().setAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1");
        document.getDocumentElement().appendChild(this.generateExtensionElement(document));
        this.addSharedPackages(document);
        Element dataElement = document.createElement("datamodel");
        dataElement.appendChild(this.toXMI(document));
        Element stereotypes = document.createElement("stereotypes");
        stereotypes.appendChild(this.sterotypesToXmi(document));
        this.addMountPoints(document);
        document.getDocumentElement().appendChild(dataElement);
        document.getDocumentElement().appendChild(stereotypes);
        this.updateShares(document);
        return document;
    }

    private Element generateExtensionElement(Document document) {
        return ExtensionElement.createExtensionElement(document, this.generateExtensionImportedElement(document));
    }

    protected Element generateExtensionImportedElement(Document document) {
        Element importedElement = ExtensionElement.createExtensionImportedElement(document, this.extensionParameters);
        importedElement.setAttribute("nameBasedOperationSyntax", this.isNamedBasedOperationSyntax() != false ? "true" : "false");
        return importedElement;
    }

    public void addPackage(BridgePackage owningPackage) {
        if (this.checkModule(owningPackage.getModule())) {
            this.findModelPackage(owningPackage);
        }
    }

    public ModelPackage getModel() {
        return this.model;
    }

    public DocumentFragment toXMI(Document ownerDocument) {
        DocumentFragment documentFragment = ownerDocument.createDocumentFragment();
        ArrayList<UmlElement> checkedElements = new ArrayList<UmlElement>();
        this.addChildPackages(documentFragment, this.model.getPackages(), checkedElements);
        return documentFragment;
    }

    public DocumentFragment sterotypesToXmi(Document ownerDocument) {
        DocumentFragment documentFragement = ownerDocument.createDocumentFragment();
        ArrayList<BridgeStereotype> usedStereotypesKeyList = new ArrayList<BridgeStereotype>(this.usedStereotypes.keySet());
        Collections.sort(usedStereotypesKeyList, new Comparator<BridgeStereotype>(){

            @Override
            public int compare(BridgeStereotype o1, BridgeStereotype o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (BridgeStereotype stereotype : usedStereotypesKeyList) {
            String packageName = stereotype.getOwningPackage().getName().replace(' ', '_');
            String namespaceURI = "http://e2e.ch/bridge/profile";
            ownerDocument.getDocumentElement().setAttribute("xmlns:" + packageName, namespaceURI);
            ArrayList<UmlElement> umlElements = this.usedStereotypes.get(stereotype);
            Collections.sort(umlElements, new Comparator<UmlElement>(){

                @Override
                public int compare(UmlElement o1, UmlElement o2) {
                    return o1.getXmiID().compareTo(o2.getXmiID());
                }
            });
            for (UmlElement umlElement : umlElements) {
                Element element = ownerDocument.createElementNS(namespaceURI, packageName + ':' + stereotype.getName());
                if (stereotype.containsBaseclass(umlElement.getBaseclass())) {
                    element.setAttribute("base_" + umlElement.getBaseclass(), umlElement.getXmiID());
                } else {
                    element.setAttribute("base_" + stereotype.getDefaultBaseclass(), umlElement.getXmiID());
                }
                String xmiId = String.valueOf(umlElement.getXmiID().hashCode() + stereotype.getXmiID().hashCode());
                element.setAttributeNS("http://schema.omg.org/spec/XMI/2.1", "xmi:id", xmiId + "_typelink");
                for (PropertyDefinition definition : stereotype.getPropertyDefinitions().values()) {
                    try {
                        Property property = umlElement.getProperty(definition.getName(), stereotype);
                        Object value = property.findVisibleValue(umlElement.getProperties().values());
                        if (value == null || value instanceof NullValue) continue;
                        if (value instanceof UmlElement && !this.checkModule(((UmlElement)value).getModule())) {
                            this.addModule(((UmlElement)value).getModule());
                        }
                        property.toXmi(element, value, this.module, this.getHelpers().getXmiIDFactory());
                    }
                    catch (NoSuchPropertyException property) {}
                }
                for (Property property : stereotype.getProperties().values()) {
                    Object value = property.getValue();
                    if (value == null || value instanceof NullValue || !property.isRequired()) continue;
                    if (value instanceof UmlElement && !this.checkModule(((UmlElement)value).getModule())) {
                        this.addModule(((UmlElement)value).getModule());
                    }
                    property.toXmi(element, value, this.module, this.getHelpers().getXmiIDFactory());
                }
                documentFragement.appendChild(element);
            }
            this.addModule(stereotype);
        }
        return documentFragement;
    }

    public boolean checkModule(Module module) {
        return module == null || module.equals(this.module);
    }

    public void addModule(Module module) {
        if (module != null && !this.modules.contains(module)) {
            this.modules.add(module);
            String moduleName = module.getName();
            if (moduleName.endsWith(".xml.zip")) {
                moduleName = moduleName.substring(0, moduleName.length() - 8);
            } else if (moduleName.endsWith(".xml")) {
                moduleName = moduleName.substring(0, moduleName.length() - 4);
            }
            this.moduleNames.add(moduleName);
        }
    }

    public boolean containsModule(String name) {
        return this.moduleNames.contains(name);
    }

    protected ModelPackage findModelPackage(BridgePackage owningPackage) {
        ArrayList<BridgePackage> packageTree = new ArrayList<BridgePackage>();
        while (owningPackage != null) {
            packageTree.add(0, owningPackage);
            owningPackage = owningPackage.getOwningPackage();
        }
        if (((BridgePackage)packageTree.get(0)).getName().equals(this.model.getOrigin().getName())) {
            packageTree.remove(0);
        }
        ModelPackage modelPackage = this.model;
        for (BridgePackage bridgePackage : packageTree) {
            if (modelPackage.getPackage(bridgePackage.getName()) == null) {
                modelPackage = modelPackage.addPackage(bridgePackage);
                this.addStereotypeElement(bridgePackage);
                continue;
            }
            modelPackage = modelPackage.getPackage(bridgePackage.getName());
        }
        return modelPackage;
    }

    protected void addPackage(Node dataElement, ModelPackage modelPackage, ArrayList<UmlElement> checkedElements) {
        if (this.checkModule(modelPackage.getOrigin().getModule())) {
            Element packageElement = modelPackage.getOrigin().toXMI(dataElement.getOwnerDocument(), this.module, this.getHelpers().getXmiIDFactory());
            this.addChildPackages(packageElement, modelPackage.getPackages(), checkedElements);
            this.addChildElements(packageElement, modelPackage.getUmlElements(), checkedElements);
            dataElement.appendChild(packageElement);
        } else if (modelPackage.getOrigin().getOwningPackage().equals(this.model.getOrigin())) {
            Element packageElement = modelPackage.getOrigin().toXMI(dataElement.getOwnerDocument(), this.module, this.getHelpers().getXmiIDFactory());
            dataElement.appendChild(packageElement);
        }
    }

    private void addChildren(UmlElement umlElement) {
        for (UmlElement child : umlElement.getAllChildren()) {
            this.addElement(child);
        }
        for (UmlElement element : umlElement.getAdditionalElements()) {
            if (element == null) continue;
            this.addElement(element);
        }
        for (Property property : umlElement.getProperties().values()) {
            if (property.getValue() == null || !(property.getValue() instanceof UmlElement)) continue;
            this.addElement((UmlElement)property.getValue());
        }
        if (umlElement instanceof BridgeClass) {
            BridgeClass bridgeClass = (BridgeClass)umlElement;
            for (BridgeAttribute attribute : bridgeClass.getAttributes()) {
                this.addElement(attribute);
            }
            for (BridgeOperation operation : bridgeClass.getOperations()) {
                this.addElement(operation);
            }
            for (Generalization general : bridgeClass.getGenerals()) {
                this.addElement(general.getTypeClass());
            }
            for (BridgeClass realization : bridgeClass.getRealizations()) {
                this.addElement(realization);
            }
        }
        if (umlElement instanceof DeploymentElement && !(umlElement instanceof BridgeDependency)) {
            if (((DeploymentElement)umlElement).getClassifier() != null) {
                this.addElement(((DeploymentElement)umlElement).getClassifier());
            }
            DependencyList dependencies = umlElement.getBridgeDependencies();
            for (BridgeDependency dependency : dependencies) {
                this.addElement(dependency);
            }
        }
        if (umlElement instanceof BridgeRealization && ((BridgeRealization)umlElement).getClassifier() != null) {
            this.addElement(((BridgeRealization)umlElement).getClassifier());
        }
    }

    private void updateShares(Document ownerDocument) {
        if (this.extendedShares.size() > 0) {
            Element extendedSharesElement = ownerDocument.createElement("extendedShares");
            for (String sharedPackage : this.extendedShares) {
                Element share = ownerDocument.createElement("share");
                share.setAttribute("sharedPackage", sharedPackage);
                extendedSharesElement.appendChild(share);
            }
            for (String sharedPackage : this.extendedShares) {
                Element reshare = ownerDocument.createElement("reSharedPackage");
                reshare.setAttribute("sharedPackage", sharedPackage);
                extendedSharesElement.appendChild(reshare);
            }
            ownerDocument.getDocumentElement().appendChild(extendedSharesElement);
        }
    }

    private void addMountPoints(Document ownerDocument) {
        ArrayList<Module> modules = new ArrayList<Module>(this.modules);
        if (this.module != null) {
            modules.remove(this.module);
        }
        this.addMountPoints(ownerDocument, modules, this.modelID);
    }

    private void addMountPoints(Document ownerDocument, ArrayList<Module> modules, String rootElementID) {
        String modelFolder = this.getModule().getURI().toString();
        modelFolder = modelFolder.substring(0, modelFolder.lastIndexOf("/"));
        Element mountTable = ownerDocument.createElement("mountTable");
        for (Module module : modules) {
            mountTable.appendChild(module.toXmi(ownerDocument, rootElementID, modelFolder));
        }
        ownerDocument.getDocumentElement().appendChild(mountTable);
    }

    private ModelPackage findModelPackage(String path) {
        String[] packages = path.split("/");
        if (packages[0].equals(this.model.getOrigin().getName())) {
            String[] newPackages = new String[packages.length - 1];
            System.arraycopy(packages, 1, newPackages, 0, newPackages.length);
            packages = newPackages;
        }
        ModelPackage parent = this.model;
        for (String packageName : packages) {
            ModelPackage child = parent.getPackage(packageName);
            if (child == null) {
                BridgePackage childPackage = this.getHelpers().getPackagesFactory().getPackage(parent.getOrigin(), packageName, this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
                parent.addPackage(childPackage);
                parent = parent.getPackage(packageName);
                this.addStereotypeElement(childPackage);
                continue;
            }
            parent = child;
        }
        return parent;
    }

    private ModelPackage findOwningPackage(UmlElement umlElement) {
        ModelPackage modelPackage = null;
        BridgePackage owningPackage = umlElement.getOwningPackage();
        if (owningPackage == null) {
            if (umlElement.getStereotype() != null) {
                String defaultPackage = (String)umlElement.getStereotype().getCustomizationProperty("defaultPackage");
                if (defaultPackage != null) {
                    UmlElement parent = umlElement.getParent();
                    if (parent == null && umlElement instanceof ClassifierElement) {
                        UmlElement umlElement2 = parent = ((ClassifierElement)umlElement).getRealization(0) == null ? null : ((ClassifierElement)umlElement).getRealization(0).getParent();
                    }
                    if (parent != null) {
                        if (defaultPackage.indexOf("parent.package") != -1) {
                            defaultPackage = this.replaceParentPackage(umlElement, defaultPackage);
                        }
                        defaultPackage = StringTools.replaceProperty((String)defaultPackage, (String)"parent.name", (String)parent.getName());
                        if (parent.getParent() != null) {
                            defaultPackage = StringTools.replaceProperty((String)defaultPackage, (String)"parent.parent.name", (String)parent.getParent().getName());
                        }
                    }
                    defaultPackage = StringTools.replaceProperty((String)defaultPackage, (String)"name", (String)umlElement.getName());
                    modelPackage = this.findModelPackage(defaultPackage);
                    umlElement.setOwningPackage(modelPackage.getOrigin());
                } else if (umlElement instanceof BridgeDependency && umlElement.getParent() != null) {
                    modelPackage = this.findOwningPackage(umlElement.getParent());
                }
            }
        } else {
            modelPackage = this.findModelPackage(owningPackage);
        }
        return modelPackage;
    }

    private String replaceParentPackage(UmlElement umlElement, String defaultPackage) {
        for (UmlElement parent = umlElement.getParent(); parent != null; parent = parent.getParent()) {
            ModelPackage parentPackage = this.findOwningPackage(parent);
            if (parentPackage == null) continue;
            defaultPackage = StringTools.replaceProperty((String)defaultPackage, (String)"parent.package", (String)parentPackage.getOrigin().getPath());
            break;
        }
        return defaultPackage;
    }

    private void addChildPackages(Node dataElement, Collection<ModelPackage> packages, ArrayList<UmlElement> checkedElements) {
        for (ModelPackage modelPackage : packages) {
            this.addPackage(dataElement, modelPackage, checkedElements);
        }
    }

    private void addChildElements(Element packageElement, List<UmlElement> children, List<UmlElement> checkedElements) {
        Collections.sort(children, new Comparator<UmlElement>(){

            @Override
            public int compare(UmlElement o1, UmlElement o2) {
                return o1.getXmiID().compareTo(o2.getXmiID());
            }
        });
        for (UmlElement child : children) {
            if (!this.checkModule(child.getModule())) continue;
            if (child.getAllUsedModules().size() > 0) {
                this.findShares(child, checkedElements);
            }
            packageElement.appendChild(child.toXMI(packageElement.getOwnerDocument(), this.getHelpers().getXmiIDFactory()));
        }
    }

    private void findShares(UmlElement umlElement, List<UmlElement> checkedElements) {
        if (!checkedElements.contains(umlElement)) {
            checkedElements.add(umlElement);
            this.addModule(umlElement);
            for (UmlElement child : umlElement.getAllChildren()) {
                this.findShares(child, checkedElements);
            }
            for (UmlElement element : umlElement.getAdditionalElements()) {
                if (element == null) continue;
                this.findShares(element, checkedElements);
            }
            for (Property property : umlElement.getProperties().values()) {
                if (property.getValue() == null || !(property.getValue() instanceof UmlElement)) continue;
                this.findShares((UmlElement)property.getValue(), checkedElements);
            }
            if (umlElement instanceof BridgeClass) {
                BridgeClass bridgeClass = (BridgeClass)umlElement;
                for (BridgeAttribute attribute : bridgeClass.getAttributes()) {
                    this.findShares(attribute, checkedElements);
                }
                for (BridgeOperation operation : bridgeClass.getOperations()) {
                    this.findShares(operation, checkedElements);
                }
            }
        }
    }

    private void addStereotypeElement(UmlElement umlElement) {
        ArrayList<BridgeStereotype> stereotypes = umlElement.getStereotypes();
        if (stereotypes != null) {
            for (BridgeStereotype stereotype : stereotypes) {
                ArrayList<UmlElement> elementList = this.usedStereotypes.get(stereotype);
                if (elementList == null) {
                    elementList = new ArrayList();
                    this.usedStereotypes.put(stereotype, elementList);
                }
                boolean found = false;
                for (UmlElement element : elementList) {
                    if (!element.getXmiID().equals(umlElement.getXmiID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                elementList.add(umlElement);
            }
        }
    }

    private void addModule(UmlElement umlElement) {
        if (!this.checkModule(umlElement.getModule())) {
            UmlElement parent = umlElement;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            this.addExtendedShare(parent.getOwningPackage(), umlElement.getModule());
        }
        this.addModule(umlElement.getModule());
        for (UmlElement child : umlElement.getAllChildrenUsingOtherModule()) {
            this.addModule(child.getModule());
            this.addExtendedShare(child.getOwningPackage(), child.getModule());
        }
    }

    private void addModule(BridgeStereotype stereotype) {
        Module module = stereotype.getModule();
        this.addModule(module);
        this.addExtendedShare(stereotype.getOwningPackage(), module);
    }

    private void addExtendedShare(BridgePackage owningPackage, Module module) {
        if (!this.checkModule(module)) {
            while (owningPackage != null) {
                if (module.containsMountPoint(owningPackage.getXmiID())) {
                    if (!this.extendedShares.contains(owningPackage.getXmiID())) {
                        this.extendedShares.add(owningPackage.getXmiID());
                    }
                    owningPackage = null;
                    continue;
                }
                owningPackage = owningPackage.getOwningPackage();
            }
        }
    }

    private Element addSharedPackages(Document document) {
        Element shareTable = null;
        if (this.sharedPackages.size() > 0) {
            shareTable = document.createElement("shareTable");
            for (BridgePackage sharedPackage : this.sharedPackages) {
                Element share = document.createElement("share");
                share.setAttribute("sharedPackage", sharedPackage.getXmiID());
                shareTable.appendChild(share);
            }
            document.getDocumentElement().appendChild(shareTable);
        }
        return shareTable;
    }
}

